/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.vocabulary;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.VocabularyTermPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.AbstractListObjectById;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IVocabularyDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ListVocabularyTermByPermId
extends AbstractListObjectById<VocabularyTermPermId, VocabularyTermPE> {
    private IVocabularyDAO vocabularyDAO;

    public ListVocabularyTermByPermId(IVocabularyDAO vocabularyDAO) {
        this.vocabularyDAO = vocabularyDAO;
    }

    @Override
    public Class<VocabularyTermPermId> getIdClass() {
        return VocabularyTermPermId.class;
    }

    @Override
    public VocabularyTermPermId createId(VocabularyTermPE term) {
        return new VocabularyTermPermId(term.getCode(), term.getVocabulary().getCode());
    }

    @Override
    public List<VocabularyTermPE> listByIds(IOperationContext context, List<VocabularyTermPermId> ids) {
        HashSet<String> loadedVocabularies = new HashSet<String>();
        HashMap<String, VocabularyTermPE> termsMap = new HashMap<String, VocabularyTermPE>();
        for (VocabularyTermPermId id : ids) {
            if (loadedVocabularies.contains(id.getVocabularyCode())) continue;
            VocabularyPE vocabulary = this.vocabularyDAO.tryFindVocabularyByCode(id.getVocabularyCode());
            if (vocabulary != null) {
                for (VocabularyTermPE term : vocabulary.getTerms()) {
                    termsMap.put(term.getVocabulary().getCode() + " " + term.getCode(), term);
                }
            }
            loadedVocabularies.add(id.getVocabularyCode());
        }
        LinkedList<VocabularyTermPE> terms = new LinkedList<VocabularyTermPE>();
        for (VocabularyTermPermId id : ids) {
            VocabularyTermPE term = (VocabularyTermPE)termsMap.get(id.getVocabularyCode() + " " + id.getCode());
            if (term == null) continue;
            terms.add(term);
        }
        return terms;
    }
}

