/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth;

import ch.systemsx.cisd.openbis.generic.shared.authorization.AuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import java.util.HashSet;
import java.util.Set;

public class AuthorisationInformation {
    private final boolean instanceRole;
    private final Set<Long> spaceIds;
    private final Set<Long> projectIds;

    public AuthorisationInformation(boolean instanceRole, Set<Long> spaceIds, Set<Long> projectIds) {
        this.instanceRole = instanceRole;
        this.spaceIds = spaceIds;
        this.projectIds = projectIds;
    }

    public boolean isInstanceRole() {
        return this.instanceRole;
    }

    public Set<Long> getSpaceIds() {
        return this.spaceIds;
    }

    public Set<Long> getProjectIds() {
        return this.projectIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorisationInformation that = (AuthorisationInformation)o;
        if (!this.spaceIds.equals(that.spaceIds)) {
            return false;
        }
        return this.projectIds.equals(that.projectIds);
    }

    public int hashCode() {
        int result = this.spaceIds.hashCode();
        result = 31 * result + this.projectIds.hashCode();
        return result;
    }

    public static AuthorisationInformation getInstance(PersonPE personPE, AuthorizationConfig authorizationConfig) {
        HashSet<Long> spaceIds = new HashSet<Long>();
        HashSet<Long> projectIds = new HashSet<Long>();
        boolean instanceRole = personPE.isSystemUser();
        boolean projectLevelAuthorizationEnabled = authorizationConfig.isProjectLevelEnabled() && authorizationConfig.isProjectLevelUser(personPE.getUserId());
        for (RoleAssignmentPE roleAssignmentPE : personPE.getAllPersonRoles()) {
            if (roleAssignmentPE.getSpace() != null) {
                spaceIds.add(roleAssignmentPE.getSpace().getId());
            }
            if (roleAssignmentPE.getProject() != null && projectLevelAuthorizationEnabled) {
                projectIds.add(roleAssignmentPE.getProject().getId());
            }
            instanceRole = instanceRole || roleAssignmentPE.getRoleLevel() == RoleWithHierarchy.RoleLevel.INSTANCE;
        }
        return new AuthorisationInformation(instanceRole, spaceIds, projectIds);
    }
}

