/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth;

import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.ISQLAuthorisationInformationProviderDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.sql.ISQLExecutor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PostgresAuthorisationInformationProviderDAO
implements ISQLAuthorisationInformationProviderDAO {
    private ISQLExecutor executor;

    public PostgresAuthorisationInformationProviderDAO(ISQLExecutor executor) {
        this.executor = executor;
    }

    @Override
    public Set<Long> getAuthorisedSamples(Set<Long> requestedIDs, AuthorisationInformation authInfo) {
        if (requestedIDs.isEmpty()) {
            return requestedIDs;
        }
        String query = "SELECT id\nFROM " + TableMapper.SAMPLE.getEntitiesTable() + "\n" + "WHERE" + " " + "id" + " " + "IN" + "(" + "SELECT" + " " + "UNNEST" + "(" + '?' + ")" + ")" + " " + "AND" + "\n" + "(" + "space_id" + " " + "IN" + " " + "(" + "SELECT" + " " + "UNNEST" + "(" + '?' + ")" + ")" + " " + "OR" + "\n" + "proj_id" + " " + "IN" + " " + "(" + "SELECT" + " " + "UNNEST" + "(" + '?' + ")" + ")" + " " + "OR" + " " + "expe_id" + " " + "IN" + " " + "(" + "SELECT" + " " + "id" + " " + "FROM" + " " + TableMapper.EXPERIMENT.getEntitiesTable() + " " + "WHERE" + " " + "proj_id" + " " + "IN" + " " + "(SELECT UNNEST(?))" + ")" + "OR" + "\n" + "space_id" + " " + "IS NULL" + " " + "AND" + " " + "proj_id" + " " + "IS NULL" + ")";
        Long[] projectIds = authInfo.getProjectIds().toArray(new Long[0]);
        List<Object> args = Arrays.asList(requestedIDs.toArray(new Long[0]), authInfo.getSpaceIds().toArray(new Long[0]), projectIds, projectIds);
        List<Map<String, Object>> queryResultList = this.executor.execute(query, args);
        return this.collectIDs(queryResultList);
    }

    @Override
    public Set<Long> getAuthorisedExperiments(Set<Long> requestedIDs, AuthorisationInformation authInfo) {
        if (requestedIDs.isEmpty()) {
            return requestedIDs;
        }
        String e = "e";
        String p = "p";
        String query = "SELECT e.id\nFROM " + TableMapper.EXPERIMENT.getEntitiesTable() + " " + "e" + "\n" + "INNER JOIN" + " " + "projects" + " " + "p" + " " + "ON" + " " + "p" + "." + "id" + " " + "=" + " " + "e" + "." + "proj_id" + " " + "WHERE" + " " + "e" + "." + "id" + " " + "IN" + " " + "(" + "SELECT" + " " + "UNNEST" + "(" + '?' + ")" + ")" + " " + "AND" + " " + "(" + "p" + "." + "space_id" + " " + "IN" + " " + "(" + "SELECT" + " " + "UNNEST" + "(" + '?' + ")" + ")" + " " + "OR" + " " + "e" + "." + "proj_id" + " " + "IN" + " " + "(" + "SELECT" + " " + "UNNEST" + "(" + '?' + ")" + ")" + ")";
        List<Object> args = Arrays.asList(requestedIDs.toArray(new Long[0]), authInfo.getSpaceIds().toArray(new Long[0]), authInfo.getProjectIds().toArray(new Long[0]));
        List<Map<String, Object>> queryResultList = this.executor.execute(query, args);
        return this.collectIDs(queryResultList);
    }

    @Override
    public Set<Long> getAuthorisedProjects(Set<Long> requestedIDs, AuthorisationInformation authInfo) {
        if (requestedIDs.isEmpty()) {
            return requestedIDs;
        }
        String p = "p";
        String query = "SELECT p.id\nFROM " + TableMapper.PROJECT.getEntitiesTable() + " " + "p" + "\n" + "WHERE" + " " + "p" + "." + "id" + " " + "IN" + " " + "(" + "SELECT" + " " + "UNNEST" + "(" + '?' + ")" + ")" + " " + "AND" + " " + "(" + "p" + "." + "space_id" + " " + "IN" + " " + "(" + "SELECT" + " " + "UNNEST" + "(" + '?' + ")" + ")" + " " + "OR" + " " + "p" + "." + "id" + " " + "IN" + " " + "(" + "SELECT" + " " + "UNNEST" + "(" + '?' + ")" + ")" + ")";
        List<Object> args = Arrays.asList(requestedIDs.toArray(new Long[0]), authInfo.getSpaceIds().toArray(new Long[0]), authInfo.getProjectIds().toArray(new Long[0]));
        List<Map<String, Object>> queryResultList = this.executor.execute(query, args);
        return this.collectIDs(queryResultList);
    }

    @Override
    public Set<Long> getAuthorisedSpaces(Set<Long> requestedIDs, AuthorisationInformation authInfo) {
        if (requestedIDs.isEmpty()) {
            return requestedIDs;
        }
        String s = "s";
        String p = "p";
        String query = "SELECT s.id\nFROM " + TableMapper.SPACE.getEntitiesTable() + " " + "s" + "\n" + "LEFT JOIN" + " " + TableMapper.PROJECT.getEntitiesTable() + " " + "p" + " " + "ON" + " " + "p" + "." + "space_id" + " " + "=" + " " + "s" + "." + "id" + "\n" + "WHERE" + " " + "s" + "." + "id" + " " + "IN" + " " + "(" + "SELECT" + " " + "UNNEST" + "(" + '?' + ")" + ")" + " " + "AND" + " " + "(" + "s" + "." + "id" + " " + "IN" + " " + "(" + "SELECT" + " " + "UNNEST" + "(" + '?' + ")" + ")" + " " + "OR" + " " + "p" + "." + "id" + " " + "IN" + " " + "(" + "SELECT" + " " + "UNNEST" + "(" + '?' + ")" + ")" + ")";
        List<Object> args = Arrays.asList(requestedIDs.toArray(new Long[0]), authInfo.getSpaceIds().toArray(new Long[0]), authInfo.getProjectIds().toArray(new Long[0]));
        List<Map<String, Object>> queryResultList = this.executor.execute(query, args);
        return this.collectIDs(queryResultList);
    }

    @Override
    public Set<Long> getAuthorisedDatasets(Set<Long> requestedIDs, AuthorisationInformation authInfo) {
        if (requestedIDs.isEmpty()) {
            return requestedIDs;
        }
        Long[] projectIds = authInfo.getProjectIds().toArray(new Long[0]);
        Long[] spaceIds = authInfo.getSpaceIds().toArray(new Long[0]);
        String d = "d";
        String ep = "ep";
        String sp = "sp";
        String exp = "exp";
        String samp = "samp";
        String query = "SELECT d.id\nFROM " + TableMapper.DATA_SET.getEntitiesTable() + " " + "d" + "\n" + "LEFT JOIN" + " " + TableMapper.EXPERIMENT.getEntitiesTable() + " " + "exp" + " " + "ON" + " " + "d" + "." + "expe_id" + " " + "=" + " " + "exp" + "." + "id" + "\n" + "LEFT JOIN" + " " + TableMapper.PROJECT.getEntitiesTable() + " " + "ep" + " " + "ON" + " " + "exp" + "." + "proj_id" + " " + "=" + " " + "ep" + "." + "id" + "\n" + "LEFT JOIN" + " " + TableMapper.SAMPLE.getEntitiesTable() + " " + "samp" + " " + "ON" + " " + "d" + "." + "samp_id" + " " + "=" + " " + "samp" + "." + "id" + "\n" + "LEFT JOIN" + " " + TableMapper.PROJECT.getEntitiesTable() + " " + "sp" + " " + "ON" + " " + "samp" + "." + "proj_id" + " " + "=" + " " + "sp" + "." + "id" + "\n" + "WHERE" + " " + "d" + "." + "id" + " " + "IN" + " " + "(SELECT UNNEST(?))" + " " + "AND" + " " + "(" + "ep" + "." + "id" + " " + "IN" + " " + "(SELECT UNNEST(?))" + " " + "OR" + " " + "sp" + "." + "id" + " " + "IN" + " " + "(SELECT UNNEST(?))" + " " + "OR" + "\n" + "ep" + "." + "space_id" + " " + "IN" + " " + "(SELECT UNNEST(?))" + " " + "OR" + " " + "samp" + "." + "space_id" + " " + "IN" + " " + "(SELECT UNNEST(?))" + " " + "OR" + " " + "sp" + "." + "space_id" + " " + "IN" + " " + "(SELECT UNNEST(?))" + ")";
        List<Object> args = Arrays.asList(requestedIDs.toArray(new Long[0]), projectIds, projectIds, spaceIds, spaceIds, spaceIds);
        List<Map<String, Object>> queryResultList = this.executor.execute(query, args);
        return this.collectIDs(queryResultList);
    }

    @Override
    public Set<Long> getTagsOfUser(Set<Long> requestedIDs, Long userID) {
        if (requestedIDs.isEmpty()) {
            return requestedIDs;
        }
        String query = "SELECT id \nFROM metaprojects\nWHERE owner = ? AND id IN(SELECT UNNEST(?))";
        List<Object> args = Arrays.asList(userID, requestedIDs.toArray(new Long[0]));
        List<Map<String, Object>> queryResultList = this.executor.execute("SELECT id \nFROM metaprojects\nWHERE owner = ? AND id IN(SELECT UNNEST(?))", args);
        return this.collectIDs(queryResultList);
    }

    private Set<Long> collectIDs(List<Map<String, Object>> queryResultList) {
        return queryResultList.stream().map(stringObjectMap -> (Long)stringObjectMap.get("id")).collect(Collectors.toSet());
    }
}

