/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.dao;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractCompositeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.BooleanPropertySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DatePropertySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberPropertySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchFieldType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchOperator;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StrictlyStringPropertySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.fetchoptions.GlobalSearchObjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchObjectKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.DataType;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.relationship.IGetRelationshipIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.dao.ISQLSearchDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.CriteriaMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.sql.ISQLExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.GlobalSearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.OrderTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SelectQuery;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.TranslatorUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class PostgresSearchDAO
implements ISQLSearchDAO {
    private static final String[] POSTGRES_TYPES = Arrays.asList(DataType.INTEGER, DataType.REAL, DataType.BOOLEAN, DataType.DATE, DataType.TIMESTAMP, DataType.XML).stream().map(Enum::toString).collect(Collectors.toList()).toArray(new String[0]);
    private static final String PROPERTY_CODE_ALIAS = "property_code";
    private static final String TYPE_CODE_ALIAS = "type_code";
    private ISQLExecutor sqlExecutor;

    public PostgresSearchDAO(ISQLExecutor sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
    }

    @Override
    public Set<Long> queryDBForIdsWithGlobalSearchMatchCriteria(Long userId, AbstractCompositeSearchCriteria criterion, TableMapper tableMapper, String idsColumnName, AuthorisationInformation authorisationInformation) {
        Collection criteria = criterion.getCriteria();
        SearchOperator operator = criterion.getOperator();
        String finalIdColumnName = idsColumnName == null ? "id" : idsColumnName;
        TranslationContext translationContext = new TranslationContext();
        translationContext.setUserId(userId);
        translationContext.setTableMapper(tableMapper);
        translationContext.setParentCriterion(criterion);
        translationContext.setCriteria(criteria);
        translationContext.setOperator(operator);
        translationContext.setIdColumnName(finalIdColumnName);
        translationContext.setAuthorisationInformation(authorisationInformation);
        this.assertPropertyTypesConsistent(translationContext);
        boolean containsProperties = criteria.stream().anyMatch(subcriterion -> subcriterion instanceof AbstractFieldSearchCriteria && ((AbstractFieldSearchCriteria)subcriterion).getFieldType().equals((Object)SearchFieldType.PROPERTY));
        this.updateWithDataTypes(translationContext, containsProperties);
        SelectQuery selectQuery = SearchCriteriaTranslator.translate(translationContext);
        List<Map<String, Object>> result = this.sqlExecutor.execute(selectQuery.getQuery(), selectQuery.getArgs());
        return result.stream().map(stringLongMap -> (Long)stringLongMap.get(finalIdColumnName)).collect(Collectors.toSet());
    }

    private void assertPropertyTypesConsistent(TranslationContext translationContext) {
        Map<String, String> dataTypeByPropertyCode;
        if (translationContext.getDataTypeByPropertyCode() == null) {
            String pt = "pt";
            String dt = "dt";
            String propertyTypeAlias = "propertytype";
            String dataTypeAlias = "datatype";
            String isManagedInternallyAlias = "ismanagedinternally";
            String sql = "SELECT pt.code propertytype, pt.is_managed_internally ismanagedinternally, dt.code datatype\nFROM property_types pt\nINNER JOIN data_types dt ON pt.daty_id = dt.id";
            List<Map<String, Object>> queryResultList = this.sqlExecutor.execute("SELECT pt.code propertytype, pt.is_managed_internally ismanagedinternally, dt.code datatype\nFROM property_types pt\nINNER JOIN data_types dt ON pt.daty_id = dt.id", Collections.emptyList());
            dataTypeByPropertyCode = queryResultList.stream().collect(Collectors.toMap(valueByColumnName -> ((Boolean)valueByColumnName.get("ismanagedinternally") != false ? "$" : "") + (String)valueByColumnName.get("propertytype"), valueByColumnName -> (String)valueByColumnName.get("datatype")));
            translationContext.setDataTypeByPropertyCode(dataTypeByPropertyCode);
        } else {
            dataTypeByPropertyCode = translationContext.getDataTypeByPropertyCode();
        }
        translationContext.getCriteria().forEach(criterion -> {
            String dataType;
            String fieldName;
            if (criterion instanceof StrictlyStringPropertySearchCriteria) {
                fieldName = ((StrictlyStringPropertySearchCriteria)criterion).getFieldName();
                dataType = (String)dataTypeByPropertyCode.get(fieldName);
                if (!(DataTypeCode.VARCHAR.toString().equals(dataType) || DataTypeCode.MULTILINE_VARCHAR.toString().equals(dataType) || DataTypeCode.HYPERLINK.toString().equals(dataType) || DataTypeCode.XML.toString().equals(dataType))) {
                    this.throwInconsistencyException((ISearchCriteria)criterion, dataType, fieldName, dataTypeByPropertyCode);
                }
            }
            if (criterion instanceof NumberPropertySearchCriteria) {
                fieldName = ((NumberPropertySearchCriteria)criterion).getFieldName();
                dataType = (String)dataTypeByPropertyCode.get(fieldName);
                if (!DataTypeCode.INTEGER.toString().equals(dataType) && !DataTypeCode.REAL.toString().equals(dataType)) {
                    this.throwInconsistencyException((ISearchCriteria)criterion, dataType, fieldName, dataTypeByPropertyCode);
                }
            } else if (criterion instanceof DatePropertySearchCriteria) {
                fieldName = ((DatePropertySearchCriteria)criterion).getFieldName();
                dataType = (String)dataTypeByPropertyCode.get(fieldName);
                if (!DataTypeCode.TIMESTAMP.toString().equals(dataType) && !DataTypeCode.DATE.toString().equals(dataType)) {
                    this.throwInconsistencyException((ISearchCriteria)criterion, dataType, fieldName, dataTypeByPropertyCode);
                }
            } else if (criterion instanceof BooleanPropertySearchCriteria) {
                fieldName = ((BooleanPropertySearchCriteria)criterion).getFieldName();
                dataType = (String)dataTypeByPropertyCode.get(fieldName);
                if (!DataTypeCode.BOOLEAN.toString().equals(dataType)) {
                    this.throwInconsistencyException((ISearchCriteria)criterion, dataType, fieldName, dataTypeByPropertyCode);
                }
            }
        });
    }

    private void throwInconsistencyException(ISearchCriteria criterion, String dataType, String fieldName, Map<String, String> dataTypeByPropertyCode) {
        throw new UserFailureException(String.format("Criterion of type %s cannot be applied to the data type %s. [fieldName=%s, dataTypeByPropertyCode=%s]", criterion.getClass().getSimpleName(), dataType, fieldName, dataTypeByPropertyCode.toString()));
    }

    @Override
    public List<Map<String, Object>> queryDBForIdsWithGlobalSearchMatchCriteria(Long userId, GlobalSearchCriteria criterion, String idsColumnName, AuthorisationInformation authorisationInformation, Set<GlobalSearchObjectKind> objectKinds, GlobalSearchObjectFetchOptions fetchOptions, boolean onlyTotalCount) {
        TranslationContext translationContext = PostgresSearchDAO.buildTranslationContext(userId, criterion, idsColumnName, authorisationInformation, objectKinds, fetchOptions);
        SelectQuery selectQuery = GlobalSearchCriteriaTranslator.translateToShortQuery(translationContext, onlyTotalCount);
        return this.sqlExecutor.execute(selectQuery.getQuery(), selectQuery.getArgs());
    }

    @Override
    public List<Map<String, Object>> queryDBForIdsWithGlobalSearchContainsCriteria(Long userId, GlobalSearchCriteria criterion, String idsColumnName, AuthorisationInformation authorisationInformation, Set<GlobalSearchObjectKind> objectKinds, GlobalSearchObjectFetchOptions fetchOptions, boolean onlyTotalCount) {
        TranslationContext translationContext = PostgresSearchDAO.buildTranslationContext(userId, criterion, idsColumnName, authorisationInformation, objectKinds, fetchOptions);
        SelectQuery selectQuery = GlobalSearchCriteriaTranslator.translateToShortContainsQuery(translationContext, onlyTotalCount);
        return this.sqlExecutor.execute(selectQuery.getQuery(), selectQuery.getArgs());
    }

    @Override
    public Collection<Map<String, Object>> queryDBWithNonRecursiveCriteria(Collection<Map<String, Object>> idsAndRanksResult, Long userId, GlobalSearchCriteria criterion, String idsColumnName, AuthorisationInformation authorisationInformation, Set<GlobalSearchObjectKind> objectKinds, GlobalSearchObjectFetchOptions fetchOptions) {
        TranslationContext translationContext = PostgresSearchDAO.buildTranslationContext(userId, criterion, idsColumnName, authorisationInformation, objectKinds, fetchOptions);
        EnumMap<GlobalSearchObjectKind, Set<Long>> idSetByObjectKindMap = new EnumMap<GlobalSearchObjectKind, Set<Long>>(GlobalSearchObjectKind.class);
        EnumMap<GlobalSearchObjectKind, Map> objectKindToRecordByIdMap = new EnumMap<GlobalSearchObjectKind, Map>(GlobalSearchObjectKind.class);
        EnumMap<GlobalSearchObjectKind, Map> objectKindToIndexByIdMap = new EnumMap<GlobalSearchObjectKind, Map>(GlobalSearchObjectKind.class);
        GlobalSearchObjectKind[] objectKindValues = GlobalSearchObjectKind.values();
        int i = 0;
        for (Map<String, Object> stringObjectMap : idsAndRanksResult) {
            Long id = (Long)stringObjectMap.get("id");
            Integer objectKindOrdinal = (Integer)stringObjectMap.get("object_kind_ordinal");
            GlobalSearchObjectKind objectKind = objectKindValues[objectKindOrdinal];
            Set idSet = idSetByObjectKindMap.computeIfAbsent(objectKind, k -> new HashSet());
            idSet.add(id);
            Map recordByIdMap = objectKindToRecordByIdMap.computeIfAbsent(objectKind, k -> new HashMap());
            recordByIdMap.put(id, stringObjectMap);
            Map indexByIdMap = objectKindToIndexByIdMap.computeIfAbsent(objectKind, k -> new HashMap());
            indexByIdMap.put(id, i);
            ++i;
        }
        SelectQuery detailsSelectQuery = GlobalSearchCriteriaTranslator.translateToDetailsQuery(translationContext, idSetByObjectKindMap);
        List<Map<String, Object>> detailsResult = this.sqlExecutor.execute(detailsSelectQuery.getQuery(), detailsSelectQuery.getArgs());
        EnumMap objectKindToDetailedRecordByIdMap = new EnumMap(GlobalSearchObjectKind.class);
        detailsResult.forEach(record -> {
            Long id = (Long)record.get("id");
            Integer objectKindOrdinal = (Integer)record.get("object_kind_ordinal");
            GlobalSearchObjectKind objectKind = objectKindValues[objectKindOrdinal];
            Map recordByIdMap = objectKindToDetailedRecordByIdMap.computeIfAbsent(objectKind, k -> new HashMap());
            recordByIdMap.put(id, record);
        });
        detailsResult.forEach(record -> {
            GlobalSearchObjectKind objectKind = objectKindValues[(Integer)record.get("object_kind_ordinal")];
            Map detailedRecordByIdMap = (Map)objectKindToRecordByIdMap.get(objectKind);
            record.put("rank", ((Map)detailedRecordByIdMap.get((Long)record.get("id"))).get("rank"));
        });
        detailsResult.sort((record1, record2) -> {
            Long id1 = (Long)record1.get("id");
            Integer objectKindOrdinal1 = (Integer)record1.get("object_kind_ordinal");
            GlobalSearchObjectKind objectKind1 = objectKindValues[objectKindOrdinal1];
            Long id2 = (Long)record2.get("id");
            Integer objectKindOrdinal2 = (Integer)record2.get("object_kind_ordinal");
            GlobalSearchObjectKind objectKind2 = objectKindValues[objectKindOrdinal2];
            return (Integer)((Map)objectKindToIndexByIdMap.get(objectKind1)).get(id1) - (Integer)((Map)objectKindToIndexByIdMap.get(objectKind2)).get(id2);
        });
        return detailsResult;
    }

    private static TranslationContext buildTranslationContext(Long userId, GlobalSearchCriteria criterion, String idsColumnName, AuthorisationInformation authorisationInformation, Set<GlobalSearchObjectKind> objectKinds, GlobalSearchObjectFetchOptions fetchOptions) {
        Collection criteria = criterion.getCriteria();
        SearchOperator operator = criterion.getOperator();
        String finalIdColumnName = idsColumnName == null ? "id" : idsColumnName;
        TranslationContext translationContext = new TranslationContext();
        translationContext.setUserId(userId);
        translationContext.setParentCriterion((AbstractCompositeSearchCriteria)criterion);
        translationContext.setCriteria(criteria);
        translationContext.setOperator(operator);
        translationContext.setIdColumnName(finalIdColumnName);
        translationContext.setAuthorisationInformation(authorisationInformation);
        translationContext.setFetchOptions(fetchOptions);
        translationContext.setObjectKinds(objectKinds);
        return translationContext;
    }

    @Override
    public Set<Long> findChildIDs(TableMapper tableMapper, Set<Long> parentIdSet, IGetRelationshipIdExecutor.RelationshipType relationshipType) {
        String rel = "rel";
        String child = "child";
        String sql = "SELECT DISTINCT child.id\nFROM " + tableMapper.getRelationshipsTable() + " " + "rel" + "\n" + "INNER JOIN" + " " + tableMapper.getEntitiesTable() + " " + "child" + " " + "ON" + " " + "rel" + "." + tableMapper.getRelationshipsTableChildIdField() + " " + "=" + " " + "child" + "." + "id" + "\n" + "WHERE" + " " + tableMapper.getRelationshipsTableParentIdField() + " " + "IN" + " " + "(" + "SELECT" + " " + "UNNEST" + "(" + '?' + ")" + ")" + " " + "AND" + " " + "relationship_id" + " " + "=" + " " + "(" + "SELECT" + " " + "id" + " " + "FROM" + " " + "relationship_types" + " " + "WHERE" + " " + "code" + " " + "=" + " " + '?' + ")";
        List<Object> args = Arrays.asList(parentIdSet.toArray(new Long[0]), relationshipType.toString());
        List<Map<String, Object>> queryResultList = this.sqlExecutor.execute(sql, args);
        return queryResultList.stream().map(stringObjectMap -> (Long)stringObjectMap.get("id")).collect(Collectors.toSet());
    }

    @Override
    public Set<Long> findParentIDs(TableMapper tableMapper, Set<Long> childIdSet, IGetRelationshipIdExecutor.RelationshipType relationshipType) {
        String rel = "rel";
        String parent = "parent";
        String sql = "SELECT DISTINCT parent.id\nFROM " + tableMapper.getRelationshipsTable() + " " + "rel" + "\n" + "INNER JOIN" + " " + tableMapper.getEntitiesTable() + " " + "parent" + " " + "ON" + " " + "rel" + "." + tableMapper.getRelationshipsTableParentIdField() + " " + "=" + " " + "parent" + "." + "id" + "\n" + "WHERE" + " " + tableMapper.getRelationshipsTableChildIdField() + " " + "IN" + " " + "(" + "SELECT" + " " + "UNNEST" + "(" + '?' + ")" + ")" + " " + "AND" + " " + "relationship_id" + " " + "=" + " " + "(" + "SELECT" + " " + "id" + " " + "FROM" + " " + "relationship_types" + " " + "WHERE" + " " + "code" + " " + "=" + " " + '?' + ")";
        List<Object> args = Arrays.asList(childIdSet.toArray(new Long[0]), relationshipType.toString());
        List<Map<String, Object>> queryResultList = this.sqlExecutor.execute(sql, args);
        return queryResultList.stream().map(stringObjectMap -> (Long)stringObjectMap.get("id")).collect(Collectors.toSet());
    }

    @Override
    public List<Long> sortIDs(TableMapper tableMapper, Collection<Long> filteredIDs, SortOptions<?> sortOptions) {
        TranslationContext translationContext = new TranslationContext();
        translationContext.setTableMapper(tableMapper);
        translationContext.setIds(filteredIDs);
        translationContext.setSortOptions(sortOptions);
        boolean containsProperties = sortOptions.getSortings().stream().anyMatch(sorting -> TranslatorUtils.isPropertySortingFieldName(sorting.getField()));
        this.updateWithDataTypes(translationContext, containsProperties);
        SelectQuery orderQuery = OrderTranslator.translateToOrderQuery(translationContext);
        List<Map<String, Object>> orderQueryResultList = this.sqlExecutor.execute(orderQuery.getQuery(), orderQuery.getArgs());
        return orderQueryResultList.stream().map(valueByColumnName -> (Long)valueByColumnName.get("id")).collect(Collectors.toList());
    }

    private void updateWithDataTypes(TranslationContext translationContext, boolean containsProperties) {
        Map<String, String> typeByPropertyName;
        translationContext.setTypesToFilter(POSTGRES_TYPES);
        if (containsProperties) {
            SelectQuery dataTypesQuery = PostgresSearchDAO.translateToSearchTypeQuery(translationContext);
            List<Map<String, Object>> dataTypesQueryResultList = this.sqlExecutor.execute(dataTypesQuery.getQuery(), dataTypesQuery.getArgs());
            typeByPropertyName = dataTypesQueryResultList.stream().collect(Collectors.toMap(valueByColumnName -> (String)valueByColumnName.get(PROPERTY_CODE_ALIAS), valueByColumnName -> (String)valueByColumnName.get(TYPE_CODE_ALIAS)));
        } else {
            typeByPropertyName = Collections.emptyMap();
        }
        translationContext.setDataTypeByPropertyName(typeByPropertyName);
    }

    private static SelectQuery translateToSearchTypeQuery(TranslationContext translationContext) {
        TableMapper tableMapper = translationContext.getTableMapper();
        String queryString = "SELECT DISTINCT CASE WHEN is_managed_internally THEN '$' ELSE '' END||o3.code property_code, o4.code type_code\nFROM " + tableMapper.getAttributeTypesTable() + " " + "o3" + " " + "\n" + "INNER JOIN" + " " + "data_types" + " " + "o4" + " " + "ON" + " " + "o3" + "." + tableMapper.getAttributeTypesTableDataTypeIdField() + " " + "=" + " " + "o4" + "." + "id" + "\n" + "WHERE" + " " + "o4" + "." + "code" + " " + "IN" + " " + "(" + "SELECT" + " " + "UNNEST" + "(" + '?' + ")" + ")";
        return new SelectQuery(queryString, Collections.singletonList(translationContext.getTypesToFilter()));
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        CriteriaMapper.initCriteriaToManagerMap(applicationContext);
    }
}

