/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper;

import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import java.util.HashMap;
import java.util.Map;

public class AttributesMapper {
    public static final String PERM_ID_ATTRIBUTE = "perm id";
    private static final Map<String, String> ATTRIBUTE_ID_TO_COLUMN_NAME = new HashMap<String, String>();
    private static final Map<String, String> ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME = new HashMap<String, String>();

    private AttributesMapper() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static String getColumnName(String attributeId, String tableName, String defaultValue) {
        if ("metaprojects".equals(tableName) && "codes".equals(attributeId)) {
            return "name";
        }
        return PERM_ID_ATTRIBUTE.equals(attributeId) || "ids".equals(attributeId) ? ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.getOrDefault(tableName, defaultValue) : ATTRIBUTE_ID_TO_COLUMN_NAME.getOrDefault(attributeId, defaultValue);
    }

    static {
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("code", "code");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("codes", "code");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("id", "id");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("description", "description");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("modification_date", "modification_timestamp");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("registration_date", "registration_timestamp");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("userIds", "user_id");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("externalCode", "external_code");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("archivingRequested", "archiving_requested");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("presentInArchive", "present_in_archive");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("shareId", "share_id");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("speedHint", "speed_hint");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("storageConfirmation", "storage_confirmation");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("gitCommitHash", "git_commit_hash");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("gitRepositoryId", "git_repository_id");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("event_id", "id");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("event_type", "event_type");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("event_entity_type", "entity_type");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("event_entity_space", "entity_space");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("event_entity_space_id", "entity_space_perm_id");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("event_entity_project", "entity_project");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("event_entity_project_id", "entity_project_perm_id");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("event_entity_registrator", "entity_registerer");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("event_entity_registration_date", "entity_registration_timestamp");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("event_identifier", "identifier");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("event_reason", "reason");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("event_description", "description");
        ATTRIBUTE_ID_TO_COLUMN_NAME.put("event_registration_date", "registration_timestamp");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("authorization_groups", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("controlled_vocabularies", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("controlled_vocabulary_terms", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("data_set_types", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("data_stores", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put(TableMapper.DATA_SET.getEntitiesTable(), "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("data_types", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("grid_custom_columns", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("experiment_types", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("file_format_types", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("spaces", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("locator_types", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("material_types", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("materials", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("operation_executions", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("property_types", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("sample_types", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("relationship_types", "code");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put(TableMapper.EXPERIMENT.getEntitiesTable(), "perm_id");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("projects", "perm_id");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put(TableMapper.SAMPLE.getEntitiesTable(), "perm_id");
        ENTITIES_TABLE_TO_PERM_ID_COLUMN_NAME.put("semantic_annotations", "perm_id");
    }
}

