/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.PSQLTypes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum TableMapper {
    MATERIAL("materials", "maty_id", "property_types", "daty_id", "material_types", "material_type_property_types", "maty_id", "prty_id", "material_properties", "mate_id", "mtpt_id", null, null, null, "data", "mate_id", "mate_id", EntityKind.MATERIAL, true, false),
    MATERIAL_TYPE("material_types", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, EntityKind.MATERIAL, false, false),
    EXPERIMENT("experiments", "exty_id", "property_types", "daty_id", "experiment_types", "experiment_type_property_types", "exty_id", "prty_id", "experiment_properties", "expe_id", "etpt_id", null, null, null, "data", "expe_id", "expe_id", EntityKind.EXPERIMENT, true, true),
    EXPERIMENT_TYPE("experiment_types", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, EntityKind.EXPERIMENT, false, false),
    SAMPLE("samples", "saty_id", "property_types", "daty_id", "sample_types", "sample_type_property_types", "saty_id", "prty_id", "sample_properties", "samp_id", "stpt_id", "sample_relationships", "sample_id_parent", "sample_id_child", "data", "samp_id", "samp_id", EntityKind.SAMPLE, true, true),
    SAMPLE_TYPE("sample_types", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, EntityKind.SAMPLE, false, false),
    DATA_SET("data", "dsty_id", "property_types", "daty_id", "data_set_types", "data_set_type_property_types", "dsty_id", "prty_id", "data_set_properties", "ds_id", "dstpt_id", "data_set_relationships", "data_id_parent", "data_id_child", "data", "id", "data_id", EntityKind.DATA_SET, true, true),
    DATA_SET_TYPE("data_set_types", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, EntityKind.DATA_SET, false, false),
    PERSON("persons", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, true, false),
    PROJECT("projects", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, true, true),
    SPACE("spaces", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, true, false),
    TAG("metaprojects", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, false),
    SEMANTIC_ANNOTATION("semantic_annotations", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, false),
    PROPERTY_TYPE("property_types", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, true, false),
    SAMPLE_PROPERTY_ASSIGNMENT("sample_type_property_types", null, null, null, null, null, "saty_id", null, null, null, null, null, null, null, null, null, null, EntityKind.SAMPLE, true, false),
    CONTENT_COPIES("content_copies", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, true, false),
    EXTERNAL_DATA("external_data", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, false),
    EXTERNAL_DMS("external_data_management_systems", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, false),
    FILE_FORMAT_TYPES("file_format_types", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, false),
    LOCATOR_TYPES("locator_types", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, false),
    CONTROLLED_VOCABULARY_TERMS("controlled_vocabulary_terms", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, true, false),
    EVENT("events_search", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, true, false);

    private String entitiesTable;
    private String entitiesTableEntityTypeIdField;
    private String attributeTypesTableDataTypeIdField;
    private String attributeTypesTable;
    private String entityTypesTable;
    private String entityTypesAttributeTypesTable;
    private String entityTypesAttributeTypesTableEntityTypeIdField;
    private String entityTypesAttributeTypesTableAttributeTypeIdField;
    private String valuesTable;
    private String valuesTableEntityIdField;
    private String valuesTableEntityTypeAttributeTypeIdField;
    private String relationshipsTable;
    private String relationshipsTableParentIdField;
    private String relationshipsTableChildIdField;
    private String dataTable;
    private String dataTableEntityIdField;
    private String metaprojectAssignmentsEntityIdField;
    private EntityKind entityKind;
    private Map<String, PSQLTypes> fieldToSQLTypeMap = new HashMap<String, PSQLTypes>();
    private Map<PSQLTypes, Set<String>> sqlTypeToFieldsMap = new HashMap<PSQLTypes, Set<String>>();
    private final boolean withRegistrator;
    private final boolean withModifier;

    private TableMapper(String entitiesTable, String entitiesTableEntityTypeIdField, String attributeTypesTable, String attributeTypesTableDataTypeIdField, String entityTypesTable, String entityTypesAttributeTypesTable, String entityTypesAttributeTypesTableEntityTypeIdField, String entityTypesAttributeTypesTableAttributeTypeIdField, String valuesTable, String valuesTableEntityIdField, String valuesTableEntityTypeAttributeTypeIdField, String relationshipsTable, String relationshipsTableParentIdField, String relationshipsTableChildIdField, String dataTable, String dataTableEntityIdField, String metaprojectAssignmentsEntityIdField, EntityKind entityKind, boolean withRegistrator, boolean withModifier) {
        this.entitiesTable = entitiesTable;
        this.entitiesTableEntityTypeIdField = entitiesTableEntityTypeIdField;
        this.attributeTypesTable = attributeTypesTable;
        this.attributeTypesTableDataTypeIdField = attributeTypesTableDataTypeIdField;
        this.entityTypesTable = entityTypesTable;
        this.entityTypesAttributeTypesTable = entityTypesAttributeTypesTable;
        this.entityTypesAttributeTypesTableEntityTypeIdField = entityTypesAttributeTypesTableEntityTypeIdField;
        this.entityTypesAttributeTypesTableAttributeTypeIdField = entityTypesAttributeTypesTableAttributeTypeIdField;
        this.valuesTable = valuesTable;
        this.valuesTableEntityIdField = valuesTableEntityIdField;
        this.valuesTableEntityTypeAttributeTypeIdField = valuesTableEntityTypeAttributeTypeIdField;
        this.relationshipsTable = relationshipsTable;
        this.relationshipsTableParentIdField = relationshipsTableParentIdField;
        this.relationshipsTableChildIdField = relationshipsTableChildIdField;
        this.dataTable = dataTable;
        this.dataTableEntityIdField = dataTableEntityIdField;
        this.metaprojectAssignmentsEntityIdField = metaprojectAssignmentsEntityIdField;
        this.entityKind = entityKind;
        this.withRegistrator = withRegistrator;
        this.withModifier = withModifier;
    }

    public static TableMapper toEntityMapper(EntityKind entityKind, boolean isEntityType) {
        return TableMapper.valueOf(entityKind.name() + (isEntityType ? "_TYPE" : ""));
    }

    public String getEntitiesTable() {
        return this.entitiesTable;
    }

    public String getEntitiesTableEntityTypeIdField() {
        return this.entitiesTableEntityTypeIdField;
    }

    public String getAttributeTypesTable() {
        return this.attributeTypesTable;
    }

    public String getAttributeTypesTableDataTypeIdField() {
        return this.attributeTypesTableDataTypeIdField;
    }

    public String getEntityTypesTable() {
        return this.entityTypesTable;
    }

    public String getEntityTypesAttributeTypesTable() {
        return this.entityTypesAttributeTypesTable;
    }

    public String getEntityTypesAttributeTypesTableEntityTypeIdField() {
        return this.entityTypesAttributeTypesTableEntityTypeIdField;
    }

    public String getEntityTypesAttributeTypesTableAttributeTypeIdField() {
        return this.entityTypesAttributeTypesTableAttributeTypeIdField;
    }

    public String getValuesTable() {
        return this.valuesTable;
    }

    public String getValuesTableEntityIdField() {
        return this.valuesTableEntityIdField;
    }

    public String getValuesTableEntityTypeAttributeTypeIdField() {
        return this.valuesTableEntityTypeAttributeTypeIdField;
    }

    public String getRelationshipsTable() {
        return this.relationshipsTable;
    }

    public String getRelationshipsTableParentIdField() {
        return this.relationshipsTableParentIdField;
    }

    public String getRelationshipsTableChildIdField() {
        return this.relationshipsTableChildIdField;
    }

    public String getDataTable() {
        return this.dataTable;
    }

    public String getDataTableEntityIdField() {
        return this.dataTableEntityIdField;
    }

    public Map<String, PSQLTypes> getFieldToSQLTypeMap() {
        return this.fieldToSQLTypeMap;
    }

    public String getMetaprojectAssignmentsEntityIdField() {
        return this.metaprojectAssignmentsEntityIdField;
    }

    public EntityKind getEntityKind() {
        return this.entityKind;
    }

    public boolean hasRegistrator() {
        return this.withRegistrator;
    }

    public boolean hasModifier() {
        return this.withModifier;
    }

    private static void initSampleFieldToSQLTypeMap() {
        Map<String, PSQLTypes> fields = TableMapper.SAMPLE.fieldToSQLTypeMap;
        fields.put("code", PSQLTypes.VARCHAR);
        fields.put("perm_id", PSQLTypes.VARCHAR);
        fields.put("registration_timestamp", PSQLTypes.TIMESTAMP_WITH_TZ);
    }

    private static void initSampleTypeFieldToSQLTypeMap() {
        Map<String, PSQLTypes> fields = TableMapper.SAMPLE_TYPE.fieldToSQLTypeMap;
        fields.put("code", PSQLTypes.VARCHAR);
        fields.put("modification_timestamp", PSQLTypes.TIMESTAMP_WITH_TZ);
    }

    private static void initExperimentFieldToSQLTypeMap() {
        Map<String, PSQLTypes> fields = TableMapper.EXPERIMENT.fieldToSQLTypeMap;
        fields.put("code", PSQLTypes.VARCHAR);
        fields.put("perm_id", PSQLTypes.VARCHAR);
        fields.put("registration_timestamp", PSQLTypes.TIMESTAMP_WITH_TZ);
    }

    private static void initExperimentTypeFieldToSQLTypeMap() {
        Map<String, PSQLTypes> fields = TableMapper.EXPERIMENT_TYPE.fieldToSQLTypeMap;
        fields.put("code", PSQLTypes.VARCHAR);
        fields.put("modification_timestamp", PSQLTypes.TIMESTAMP_WITH_TZ);
    }

    private static void initPersonFieldToSQLTypeMap() {
        Map<String, PSQLTypes> fields = TableMapper.PERSON.fieldToSQLTypeMap;
        fields.put("user_id", PSQLTypes.VARCHAR);
        fields.put("registration_timestamp", PSQLTypes.TIMESTAMP_WITH_TZ);
    }

    private static void initSampleSQLTypeToFieldsMap() {
        Map<PSQLTypes, Set<String>> map = TableMapper.SAMPLE.sqlTypeToFieldsMap;
        map.put(PSQLTypes.VARCHAR, new HashSet<String>(Arrays.asList("code", "perm_id")));
        map.put(PSQLTypes.TIMESTAMP_WITH_TZ, new HashSet<String>(Arrays.asList("registration_timestamp")));
    }

    private static void initSampleTypeSQLTypeToFieldsMap() {
        Map<PSQLTypes, Set<String>> map = TableMapper.SAMPLE_TYPE.sqlTypeToFieldsMap;
        map.put(PSQLTypes.VARCHAR, new HashSet<String>(Arrays.asList("code")));
        map.put(PSQLTypes.TIMESTAMP_WITH_TZ, new HashSet<String>(Arrays.asList("modification_timestamp")));
    }

    private static void initPersonSQLTypeToFieldsMap() {
        Map<PSQLTypes, Set<String>> map = TableMapper.PERSON.sqlTypeToFieldsMap;
        map.put(PSQLTypes.VARCHAR, new HashSet<String>(Arrays.asList("user_id")));
        map.put(PSQLTypes.TIMESTAMP_WITH_TZ, new HashSet<String>(Arrays.asList("registration_timestamp")));
    }

    private static void initExperimentSQLTypeToFieldsMap() {
        Map<PSQLTypes, Set<String>> map = TableMapper.EXPERIMENT.sqlTypeToFieldsMap;
        map.put(PSQLTypes.VARCHAR, new HashSet<String>(Arrays.asList("code", "perm_id")));
    }

    private static void initExperimentTypeSQLTypeToFieldsMap() {
        Map<PSQLTypes, Set<String>> map = TableMapper.SAMPLE_TYPE.sqlTypeToFieldsMap;
        map.put(PSQLTypes.VARCHAR, new HashSet<String>(Arrays.asList("code")));
        map.put(PSQLTypes.TIMESTAMP_WITH_TZ, new HashSet<String>(Arrays.asList("modification_timestamp")));
    }

    private static void initProjectFieldToSQLTypeMap() {
        Map<String, PSQLTypes> fields = TableMapper.PROJECT.fieldToSQLTypeMap;
        fields.put("code", PSQLTypes.VARCHAR);
        fields.put("registration_timestamp", PSQLTypes.TIMESTAMP_WITH_TZ);
    }

    private static void initProjectSQLTypeToFieldsMap() {
        Map<PSQLTypes, Set<String>> map = TableMapper.PROJECT.sqlTypeToFieldsMap;
        map.put(PSQLTypes.VARCHAR, new HashSet<String>(Arrays.asList("code", "description")));
        map.put(PSQLTypes.TIMESTAMP_WITH_TZ, new HashSet<String>(Arrays.asList("registration_timestamp")));
    }

    private static void initSpaceFieldToSQLTypeMap() {
        Map<String, PSQLTypes> fields = TableMapper.SPACE.fieldToSQLTypeMap;
        fields.put("code", PSQLTypes.VARCHAR);
        fields.put("description", PSQLTypes.VARCHAR);
        fields.put("registration_timestamp", PSQLTypes.TIMESTAMP_WITH_TZ);
    }

    private static void initSpaceSQLTypeToFieldsMap() {
        Map<PSQLTypes, Set<String>> map = TableMapper.SPACE.sqlTypeToFieldsMap;
        map.put(PSQLTypes.VARCHAR, new HashSet<String>(Arrays.asList("code")));
        map.put(PSQLTypes.TIMESTAMP_WITH_TZ, new HashSet<String>(Arrays.asList("registration_timestamp")));
    }

    private static void initDataSetFieldToSQLTypeMap() {
        Map<String, PSQLTypes> fields = TableMapper.DATA_SET.fieldToSQLTypeMap;
        fields.put("code", PSQLTypes.VARCHAR);
        fields.put("registration_timestamp", PSQLTypes.TIMESTAMP_WITH_TZ);
    }

    private static void initDataSetSQLTypeToFieldsMap() {
        Map<PSQLTypes, Set<String>> map = TableMapper.DATA_SET.sqlTypeToFieldsMap;
        map.put(PSQLTypes.VARCHAR, new HashSet<String>(Arrays.asList("code")));
        map.put(PSQLTypes.TIMESTAMP_WITH_TZ, new HashSet<String>(Arrays.asList("registration_timestamp")));
    }

    private static void initMaterialsFieldToSQLTypeMap() {
        Map<String, PSQLTypes> fields = TableMapper.MATERIAL.fieldToSQLTypeMap;
        fields.put("code", PSQLTypes.VARCHAR);
        fields.put("registration_timestamp", PSQLTypes.TIMESTAMP_WITH_TZ);
    }

    private static void initMaterialsSQLTypeToFieldsMap() {
        Map<PSQLTypes, Set<String>> map = TableMapper.MATERIAL.sqlTypeToFieldsMap;
        map.put(PSQLTypes.VARCHAR, new HashSet<String>(Arrays.asList("code")));
        map.put(PSQLTypes.TIMESTAMP_WITH_TZ, new HashSet<String>(Arrays.asList("registration_timestamp")));
    }

    private static void initDataSetTypeFieldToSQLTypeMap() {
        Map<String, PSQLTypes> fields = TableMapper.DATA_SET_TYPE.fieldToSQLTypeMap;
        fields.put("code", PSQLTypes.VARCHAR);
        fields.put("modification_timestamp", PSQLTypes.TIMESTAMP_WITH_TZ);
    }

    private static void initDataSetTypeSQLTypeToFieldsMap() {
        Map<PSQLTypes, Set<String>> map = TableMapper.DATA_SET_TYPE.sqlTypeToFieldsMap;
        map.put(PSQLTypes.VARCHAR, new HashSet<String>(Arrays.asList("code")));
        map.put(PSQLTypes.TIMESTAMP_WITH_TZ, new HashSet<String>(Arrays.asList("modification_timestamp")));
    }

    static {
        TableMapper.initSampleFieldToSQLTypeMap();
        TableMapper.initSampleSQLTypeToFieldsMap();
        TableMapper.initSampleTypeFieldToSQLTypeMap();
        TableMapper.initSampleTypeSQLTypeToFieldsMap();
        TableMapper.initPersonFieldToSQLTypeMap();
        TableMapper.initPersonSQLTypeToFieldsMap();
        TableMapper.initExperimentFieldToSQLTypeMap();
        TableMapper.initExperimentSQLTypeToFieldsMap();
        TableMapper.initExperimentTypeFieldToSQLTypeMap();
        TableMapper.initExperimentTypeSQLTypeToFieldsMap();
        TableMapper.initProjectFieldToSQLTypeMap();
        TableMapper.initProjectSQLTypeToFieldsMap();
        TableMapper.initSpaceFieldToSQLTypeMap();
        TableMapper.initSpaceSQLTypeToFieldsMap();
        TableMapper.initDataSetFieldToSQLTypeMap();
        TableMapper.initDataSetSQLTypeToFieldsMap();
        TableMapper.initMaterialsFieldToSQLTypeMap();
        TableMapper.initMaterialsSQLTypeToFieldsMap();
        TableMapper.initDataSetTypeFieldToSQLTypeMap();
        TableMapper.initDataSetTypeSQLTypeToFieldsMap();
    }
}

