/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractCompositeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchOperator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.relationship.IGetRelationshipIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.ISQLAuthorisationInformationProviderDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.dao.ISQLSearchDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.hibernate.IID2PEMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.AbstractLocalSearchManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractCompositeEntitySearchManager<CRITERIA extends AbstractCompositeSearchCriteria, OBJECT, OBJECT_PE>
extends AbstractLocalSearchManager<CRITERIA, OBJECT, OBJECT_PE> {
    public AbstractCompositeEntitySearchManager(ISQLSearchDAO searchDAO, ISQLAuthorisationInformationProviderDAO authProvider, IID2PEMapper<Long, OBJECT_PE> idsTranslator) {
        super(searchDAO, authProvider, idsTranslator);
    }

    protected abstract Class<? extends AbstractCompositeSearchCriteria> getParentsSearchCriteriaClass();

    protected abstract Class<? extends AbstractCompositeSearchCriteria> getChildrenSearchCriteriaClass();

    protected Set<Long> doSearchForIDs(Long userId, AuthorisationInformation authorisationInformation, CRITERIA criteria, String idsColumnName, TableMapper tableMapper) {
        List<ISearchCriteria> mainCriteria;
        AbstractCompositeSearchCriteria emptyCriteria = this.createEmptyCriteria(false);
        Class<AbstractCompositeSearchCriteria> parentsSearchCriteriaClass = this.getParentsSearchCriteriaClass();
        Class<AbstractCompositeSearchCriteria> childrenSearchCriteriaClass = this.getChildrenSearchCriteriaClass();
        if (parentsSearchCriteriaClass != null && childrenSearchCriteriaClass != null) {
            mainCriteria = this.getOtherCriteriaThan((AbstractCompositeSearchCriteria)criteria, parentsSearchCriteriaClass, childrenSearchCriteriaClass, emptyCriteria.getClass());
        } else if (parentsSearchCriteriaClass == null && childrenSearchCriteriaClass == null) {
            mainCriteria = criteria.getCriteria();
        } else {
            throw new RuntimeException("Either both or none of parent/child search criteria should be null.");
        }
        CompositeEntityCriteriaVo criteriaVo = new CompositeEntityCriteriaVo(mainCriteria, this.getCriteria((AbstractCompositeSearchCriteria)criteria, parentsSearchCriteriaClass), this.getCriteria((AbstractCompositeSearchCriteria)criteria, childrenSearchCriteriaClass), Collections.emptyList(), this.getCriteria((AbstractCompositeSearchCriteria)criteria, emptyCriteria.getClass()), criteria.getOperator(), criteria.isNegated());
        return this.doSearchForIDs(userId, criteriaVo, idsColumnName, tableMapper, authorisationInformation);
    }

    protected Set<Long> doSearchForIDs(Long userId, CompositeEntityCriteriaVo criteriaVo, String idsColumnName, TableMapper tableMapper, AuthorisationInformation authorisationInformation) {
        Set<Long> childrenCriteriaIntermediateResults;
        Set<Long> containerCriteriaIntermediateResults;
        Set<Long> parentCriteriaIntermediateResults;
        Set<Long> mainCriteriaIntermediateResults;
        Collection<? extends ISearchCriteria> parentRelationshipsCriteria = criteriaVo.getParentsCriteria();
        Collection<? extends ISearchCriteria> childRelationshipsCriteria = criteriaVo.getChildrenCriteria();
        Collection<? extends ISearchCriteria> containerCriteria = criteriaVo.getContainerCriteria();
        Collection<? extends AbstractCompositeSearchCriteria> nestedCriteria = criteriaVo.getNestedCriteria();
        Collection<ISearchCriteria> mainCriteria = criteriaVo.getMainCriteria();
        SearchOperator finalSearchOperator = criteriaVo.getSearchOperator();
        boolean negated = criteriaVo.isNegated();
        if (!mainCriteria.isEmpty()) {
            AbstractCompositeSearchCriteria containerCriterion = this.createEmptyCriteria(negated);
            containerCriterion.withOperator(finalSearchOperator);
            containerCriterion.setCriteria(mainCriteria);
            mainCriteriaIntermediateResults = this.getSearchDAO().queryDBForIdsWithGlobalSearchMatchCriteria(userId, containerCriterion, tableMapper, idsColumnName, authorisationInformation);
        } else {
            mainCriteriaIntermediateResults = null;
        }
        if (!parentRelationshipsCriteria.isEmpty()) {
            Set<Long> finalParentIds = this.findFinalRelationshipIds(userId, authorisationInformation, finalSearchOperator, parentRelationshipsCriteria, tableMapper);
            Set<Long> finalParentIdsFiltered = this.filterIDsByUserRights(userId, authorisationInformation, finalParentIds);
            parentCriteriaIntermediateResults = this.getChildrenIdsOf(finalParentIdsFiltered, tableMapper, IGetRelationshipIdExecutor.RelationshipType.PARENT_CHILD);
        } else {
            parentCriteriaIntermediateResults = null;
        }
        if (!containerCriteria.isEmpty()) {
            Set<Long> finalContainerIds = this.findFinalRelationshipIds(userId, authorisationInformation, finalSearchOperator, containerCriteria, tableMapper);
            Set<Long> finalContainerIdsFiltered = this.filterIDsByUserRights(userId, authorisationInformation, finalContainerIds);
            containerCriteriaIntermediateResults = this.getChildrenIdsOf(finalContainerIdsFiltered, tableMapper, IGetRelationshipIdExecutor.RelationshipType.CONTAINER_COMPONENT);
        } else {
            containerCriteriaIntermediateResults = null;
        }
        if (!childRelationshipsCriteria.isEmpty()) {
            Set<Long> finalChildrenIds = this.findFinalRelationshipIds(userId, authorisationInformation, finalSearchOperator, childRelationshipsCriteria, tableMapper);
            Set<Long> finalChildrenIdsFiltered = this.filterIDsByUserRights(userId, authorisationInformation, finalChildrenIds);
            childrenCriteriaIntermediateResults = this.getParentsIdsOf(finalChildrenIdsFiltered, tableMapper, IGetRelationshipIdExecutor.RelationshipType.PARENT_CHILD);
        } else {
            childrenCriteriaIntermediateResults = null;
        }
        Collection<Object> nestedCriteriaIntermediateResults = !nestedCriteria.isEmpty() ? (Collection)nestedCriteria.stream().map((? super T criteria) -> this.doSearchForIDs(userId, authorisationInformation, criteria, idsColumnName, tableMapper)).collect(Collectors.toList()) : Collections.emptyList();
        Set<Long> results = AbstractCompositeEntitySearchManager.containsValues(mainCriteriaIntermediateResults) || AbstractCompositeEntitySearchManager.containsValues(parentCriteriaIntermediateResults) || AbstractCompositeEntitySearchManager.containsValues(containerCriteriaIntermediateResults) || AbstractCompositeEntitySearchManager.containsValues(childrenCriteriaIntermediateResults) || AbstractCompositeEntitySearchManager.containsValues(nestedCriteriaIntermediateResults) ? AbstractCompositeEntitySearchManager.mergeResults(finalSearchOperator, mainCriteriaIntermediateResults != null ? Collections.singleton(mainCriteriaIntermediateResults) : Collections.emptySet(), childrenCriteriaIntermediateResults != null ? Collections.singleton(childrenCriteriaIntermediateResults) : Collections.emptySet(), parentCriteriaIntermediateResults != null ? Collections.singleton(parentCriteriaIntermediateResults) : Collections.emptySet(), containerCriteriaIntermediateResults != null ? Collections.singleton(containerCriteriaIntermediateResults) : Collections.emptySet(), nestedCriteriaIntermediateResults) : (mainCriteria.isEmpty() && parentRelationshipsCriteria.isEmpty() && childRelationshipsCriteria.isEmpty() && nestedCriteria.isEmpty() ? this.getAllIds(userId, authorisationInformation, idsColumnName, tableMapper, null) : Collections.emptySet());
        return this.filterIDsByUserRights(userId, authorisationInformation, results);
    }

    private Set<Long> findFinalRelationshipIds(Long userId, AuthorisationInformation authorisationInformation, SearchOperator operator, Collection<? extends ISearchCriteria> relatedEntitiesCriteria, TableMapper tableMapper) {
        List relatedIds = relatedEntitiesCriteria.stream().flatMap(entitySearchCriteria -> {
            Set<Long> foundParentIds = this.doSearchForIDs(userId, authorisationInformation, (AbstractCompositeSearchCriteria)entitySearchCriteria, "id", tableMapper);
            return foundParentIds.isEmpty() ? Stream.empty() : Stream.of(foundParentIds);
        }).collect(Collectors.toList());
        return AbstractCompositeEntitySearchManager.mergeResults(operator, relatedIds);
    }

    protected Set<Long> getAllIds(Long userId, AuthorisationInformation authorisationInformation, String idsColumnName, TableMapper tableMapper) {
        AbstractCompositeSearchCriteria criteria = this.createEmptyCriteria(false);
        AbstractCompositeSearchCriteria containerCriterion = this.createEmptyCriteria(false);
        containerCriterion.setCriteria(Collections.singletonList(criteria));
        return this.getSearchDAO().queryDBForIdsWithGlobalSearchMatchCriteria(userId, containerCriterion, tableMapper, idsColumnName, authorisationInformation);
    }

    private Set<Long> getChildrenIdsOf(Set<Long> parentIdSet, TableMapper tableMapper, IGetRelationshipIdExecutor.RelationshipType relationshipType) {
        return this.getSearchDAO().findChildIDs(tableMapper, parentIdSet, relationshipType);
    }

    private Set<Long> getParentsIdsOf(Set<Long> childIdSet, TableMapper tableMapper, IGetRelationshipIdExecutor.RelationshipType relationshipType) {
        return this.getSearchDAO().findParentIDs(tableMapper, childIdSet, relationshipType);
    }

    protected static class CompositeEntityCriteriaVo {
        private final Collection<ISearchCriteria> mainCriteria;
        private final Collection<? extends ISearchCriteria> parentsCriteria;
        private final Collection<? extends ISearchCriteria> childrenCriteria;
        private final Collection<? extends ISearchCriteria> containerCriteria;
        private final Collection<? extends AbstractCompositeSearchCriteria> nestedCriteria;
        private final SearchOperator searchOperator;
        private final boolean negated;

        public CompositeEntityCriteriaVo(Collection<ISearchCriteria> mainCriteria, Collection<? extends ISearchCriteria> parentsCriteria, Collection<? extends ISearchCriteria> childrenCriteria, Collection<? extends ISearchCriteria> containerCriteria, Collection<? extends AbstractCompositeSearchCriteria> nestedCriteria, SearchOperator searchOperator, boolean negated) {
            this.mainCriteria = mainCriteria;
            this.parentsCriteria = parentsCriteria;
            this.childrenCriteria = childrenCriteria;
            this.containerCriteria = containerCriteria;
            this.nestedCriteria = nestedCriteria;
            this.searchOperator = searchOperator;
            this.negated = negated;
        }

        public Collection<ISearchCriteria> getMainCriteria() {
            return this.mainCriteria;
        }

        public Collection<? extends ISearchCriteria> getParentsCriteria() {
            return this.parentsCriteria;
        }

        public Collection<? extends ISearchCriteria> getChildrenCriteria() {
            return this.childrenCriteria;
        }

        public Collection<? extends ISearchCriteria> getContainerCriteria() {
            return this.containerCriteria;
        }

        public Collection<? extends AbstractCompositeSearchCriteria> getNestedCriteria() {
            return this.nestedCriteria;
        }

        public SearchOperator getSearchOperator() {
            return this.searchOperator;
        }

        public boolean isNegated() {
            return this.negated;
        }
    }
}

