/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractCompositeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchOperator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.ISQLAuthorisationInformationProviderDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.dao.ISQLSearchDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.hibernate.IID2PEMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.AbstractSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.DummyCompositeSearchCriterion;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.IFieldSearchCriterionFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.ILocalSearchManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractLocalSearchManager<CRITERIA extends ISearchCriteria, OBJECT, OBJECT_PE>
extends AbstractSearchManager<OBJECT>
implements ILocalSearchManager<CRITERIA, OBJECT, OBJECT_PE> {
    private final IID2PEMapper<Long, OBJECT_PE> idsTranslator;

    public AbstractLocalSearchManager(ISQLSearchDAO searchDAO, ISQLAuthorisationInformationProviderDAO authProvider, IID2PEMapper<Long, OBJECT_PE> idsTranslator) {
        super(authProvider, searchDAO);
        this.idsTranslator = idsTranslator;
    }

    @Override
    protected List<ISearchCriteria> getOtherCriteriaThan(AbstractCompositeSearchCriteria searchCriteria, Class<? extends ISearchCriteria> ... classes) {
        return searchCriteria.getCriteria().stream().filter(criterion -> Arrays.stream(classes).noneMatch(clazz -> clazz.isInstance(criterion))).collect(Collectors.toList());
    }

    protected static <E> Set<E> mergeResults(SearchOperator operator, Collection<Set<E>> ... intermediateResultsToMerge) {
        Collection intermediateResults = Arrays.stream(intermediateResultsToMerge).reduce(new ArrayList(), (sets1, sets2) -> {
            if (sets2 != null) {
                sets1.addAll(sets2);
            }
            return sets1;
        });
        switch (operator) {
            case AND: {
                return AbstractLocalSearchManager.intersection(intermediateResults);
            }
            case OR: {
                return AbstractLocalSearchManager.union(intermediateResults);
            }
        }
        throw new IllegalArgumentException("Unexpected value for search operator: " + operator);
    }

    protected static <E> Set<E> intersection(Collection<Set<E>> sets) {
        return !sets.isEmpty() ? (Set)sets.stream().reduce(new HashSet(sets.iterator().next()), (set1, set2) -> {
            if (set2 != null) {
                set1.retainAll((Collection<?>)set2);
            }
            return set1;
        }) : new HashSet(0);
    }

    protected static <E> Set<E> union(Collection<Set<E>> sets) {
        return sets.stream().reduce(new HashSet(), (set1, set2) -> {
            if (set2 != null) {
                set1.addAll(set2);
            }
            return set1;
        });
    }

    @Override
    public Collection<OBJECT_PE> map(Collection<Long> ids) {
        return this.idsTranslator.map(ids);
    }

    @Override
    protected <T, C extends AbstractFieldSearchCriteria<T>> C convertToOtherCriterion(AbstractFieldSearchCriteria<T> criterion, IFieldSearchCriterionFactory<C> factory) {
        C result = factory.create();
        result.setFieldValue(criterion.getFieldValue());
        return result;
    }

    @Override
    protected Set<Long> searchForIDs(Long userId, AuthorisationInformation authorisationInformation, AbstractCompositeSearchCriteria criteria, String idsColumnName, TableMapper tableMapper) {
        AbstractCompositeSearchCriteria emptyCriterion = this.createEmptyCriteria(criteria.isNegated());
        List<?> nestedCriteria = this.getCriteria(criteria, emptyCriterion.getClass());
        List<ISearchCriteria> mainCriteria = this.getOtherCriteriaThan(criteria, emptyCriterion.getClass());
        AbstractCompositeSearchCriteria containerCriterion = this.createEmptyCriteria(criteria.isNegated());
        containerCriterion.withOperator(criteria.getOperator());
        containerCriterion.setCriteria(mainCriteria);
        Set<Long> mainCriteriaIntermediateResults = !mainCriteria.isEmpty() ? this.getSearchDAO().queryDBForIdsWithGlobalSearchMatchCriteria(userId, containerCriterion, tableMapper, idsColumnName, authorisationInformation) : null;
        Collection<Object> nestedCriteriaIntermediateResults = !nestedCriteria.isEmpty() ? (Collection)nestedCriteria.stream().map((? super T nestedCriterion) -> this.searchForIDs(userId, authorisationInformation, nestedCriterion, emptyCriterion, idsColumnName)).collect(Collectors.toList()) : Collections.emptyList();
        Set<Long> resultBeforeFiltering = AbstractLocalSearchManager.containsValues(mainCriteriaIntermediateResults) || AbstractLocalSearchManager.containsValues(nestedCriteriaIntermediateResults) ? AbstractLocalSearchManager.mergeResults(criteria.getOperator(), mainCriteriaIntermediateResults != null ? Collections.singleton(mainCriteriaIntermediateResults) : Collections.emptySet(), nestedCriteriaIntermediateResults) : (mainCriteria.isEmpty() && nestedCriteria.isEmpty() ? this.getAllIds(userId, authorisationInformation, idsColumnName, tableMapper, containerCriterion) : Collections.emptySet());
        return this.filterIDsByUserRights(userId, authorisationInformation, resultBeforeFiltering);
    }

    @Override
    protected Set<Long> searchForIDsByCriteriaCollection(Long userId, AuthorisationInformation authorisationInformation, Collection<ISearchCriteria> criteria, SearchOperator finalSearchOperator, TableMapper tableMapper, String idsColumnName) {
        if (!criteria.isEmpty()) {
            DummyCompositeSearchCriterion containerCriterion = new DummyCompositeSearchCriterion(criteria, finalSearchOperator);
            Set<Long> mainCriteriaNotFilteredResults = this.getSearchDAO().queryDBForIdsWithGlobalSearchMatchCriteria(userId, containerCriterion, tableMapper, idsColumnName, authorisationInformation);
            return this.filterIDsByUserRights(userId, authorisationInformation, mainCriteriaNotFilteredResults);
        }
        return Collections.emptySet();
    }

    protected abstract AbstractCompositeSearchCriteria createEmptyCriteria(boolean var1);

    protected Set<Long> getAllIds(Long userId, AuthorisationInformation authorisationInformation, String idsColumnName, TableMapper tableMapper, AbstractCompositeSearchCriteria containerCriterion) {
        AbstractCompositeSearchCriteria emptyCriteria = this.createEmptyCriteria(false);
        AbstractCompositeSearchCriteria emptyContainerCriterion = this.createEmptyCriteria(false);
        emptyContainerCriterion.setCriteria(Collections.singletonList(emptyCriteria));
        return this.getSearchDAO().queryDBForIdsWithGlobalSearchMatchCriteria(userId, emptyContainerCriterion, tableMapper, idsColumnName, authorisationInformation);
    }
}

