/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractCompositeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchOperator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.ISQLAuthorisationInformationProviderDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.dao.ISQLSearchDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.DummyCompositeSearchCriterion;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.IFieldSearchCriterionFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractSearchManager<OBJECT> {
    protected final ISQLAuthorisationInformationProviderDAO authProvider;
    private final ISQLSearchDAO searchDAO;

    public AbstractSearchManager(ISQLAuthorisationInformationProviderDAO authProvider, ISQLSearchDAO searchDAO) {
        this.authProvider = authProvider;
        this.searchDAO = searchDAO;
    }

    protected static boolean containsValues(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public Set<Long> filterIDsByUserRights(Long userId, AuthorisationInformation authorisationInformation, Set<Long> ids) {
        if (authorisationInformation.isInstanceRole()) {
            return ids;
        }
        return this.doFilterIDsByUserRights(ids, authorisationInformation);
    }

    protected abstract Set<Long> doFilterIDsByUserRights(Set<Long> var1, AuthorisationInformation var2);

    protected List<ISearchCriteria> getOtherCriteriaThan(AbstractCompositeSearchCriteria searchCriteria, Class<? extends ISearchCriteria> ... classes) {
        return searchCriteria.getCriteria().stream().filter(criterion -> Arrays.stream(classes).noneMatch(clazz -> clazz.isInstance(criterion))).collect(Collectors.toList());
    }

    protected <T extends ISearchCriteria> List<T> getCriteria(AbstractCompositeSearchCriteria compositeSearchCriteria, Class<T> clazz) {
        return clazz != null ? compositeSearchCriteria.getCriteria().stream().filter(clazz::isInstance).collect(Collectors.toList()) : Collections.emptyList();
    }

    protected static <E> Set<E> mergeResults(SearchOperator operator, Collection<Set<E>> ... intermediateResultsToMerge) {
        Collection intermediateResults = Arrays.stream(intermediateResultsToMerge).reduce(new ArrayList(), (sets, sets2) -> {
            if (sets2 != null) {
                sets.addAll(sets2);
            }
            return sets;
        });
        switch (operator) {
            case AND: {
                return AbstractSearchManager.intersection(intermediateResults);
            }
            case OR: {
                return AbstractSearchManager.union(intermediateResults);
            }
        }
        throw new IllegalArgumentException("Unexpected value for search operator: " + operator);
    }

    protected static <E> Set<E> intersection(Collection<Set<E>> sets) {
        return !sets.isEmpty() ? (Set)sets.stream().reduce(new HashSet(sets.iterator().next()), (set1, set2) -> {
            if (set2 != null) {
                set1.retainAll((Collection<?>)set2);
            }
            return set1;
        }) : new HashSet(0);
    }

    protected static <E> Set<E> union(Collection<Set<E>> sets) {
        return sets.stream().reduce(new HashSet(), (set1, set2) -> {
            if (set2 != null) {
                set1.addAll(set2);
            }
            return set1;
        });
    }

    protected static <E> Set<E> getSmallestSet(Collection<Set<E>> candidates) {
        Set smallestSet = candidates.stream().min((o1, o2) -> {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            return o2 == null ? -1 : o1.size() - o2.size();
        }).orElse(null);
        return smallestSet;
    }

    protected ISQLSearchDAO getSearchDAO() {
        return this.searchDAO;
    }

    protected ISQLAuthorisationInformationProviderDAO getAuthProvider() {
        return this.authProvider;
    }

    protected List<Long> doSortIDs(Collection<Long> filteredIDs, SortOptions<OBJECT> sortOptions, TableMapper tableMapper) {
        return this.getSearchDAO().sortIDs(tableMapper, filteredIDs, sortOptions);
    }

    protected <T, C extends AbstractFieldSearchCriteria<T>> C convertToOtherCriterion(AbstractFieldSearchCriteria<T> criterion, IFieldSearchCriterionFactory<C> factory) {
        C result = factory.create();
        result.setFieldValue(criterion.getFieldValue());
        return result;
    }

    protected Set<Long> searchForIDs(Long userId, AuthorisationInformation authorisationInformation, AbstractCompositeSearchCriteria criteria, String idsColumnName, TableMapper tableMapper) {
        Set<Long> mainCriteriaIntermediateResults = this.getSearchDAO().queryDBForIdsWithGlobalSearchMatchCriteria(userId, criteria, tableMapper, idsColumnName, authorisationInformation);
        Set<Long> resultBeforeFiltering = AbstractSearchManager.containsValues(mainCriteriaIntermediateResults) ? mainCriteriaIntermediateResults : Collections.emptySet();
        return this.filterIDsByUserRights(userId, authorisationInformation, resultBeforeFiltering);
    }

    protected Set<Long> searchForIDsByCriteriaCollection(Long userId, AuthorisationInformation authorisationInformation, Collection<ISearchCriteria> criteria, SearchOperator finalSearchOperator, TableMapper tableMapper, String idsColumnName) {
        if (!criteria.isEmpty()) {
            DummyCompositeSearchCriterion containerCriterion = new DummyCompositeSearchCriterion(criteria, finalSearchOperator);
            Set<Long> mainCriteriaNotFilteredResults = this.getSearchDAO().queryDBForIdsWithGlobalSearchMatchCriteria(userId, containerCriterion, tableMapper, idsColumnName, authorisationInformation);
            return this.filterIDsByUserRights(userId, authorisationInformation, mainCriteriaNotFilteredResults);
        }
        return Collections.emptySet();
    }
}

