/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractCompositeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.PermIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetChildrenSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetContainerSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetParentsSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.ISQLAuthorisationInformationProviderDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.dao.ISQLSearchDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.hibernate.IID2PEMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.AbstractCompositeEntitySearchManager;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DataSetSearchManager
extends AbstractCompositeEntitySearchManager<DataSetSearchCriteria, DataSet, Long> {
    public DataSetSearchManager(ISQLSearchDAO searchDAO, ISQLAuthorisationInformationProviderDAO authProvider, IID2PEMapper<Long, Long> idsMapper) {
        super(searchDAO, authProvider, idsMapper);
    }

    protected Class<? extends AbstractCompositeSearchCriteria> getContainerSearchCriteriaClass() {
        return DataSetContainerSearchCriteria.class;
    }

    @Override
    protected Class<? extends AbstractCompositeSearchCriteria> getParentsSearchCriteriaClass() {
        return DataSetParentsSearchCriteria.class;
    }

    @Override
    protected Class<? extends AbstractCompositeSearchCriteria> getChildrenSearchCriteriaClass() {
        return DataSetChildrenSearchCriteria.class;
    }

    protected DataSetSearchCriteria createEmptyCriteria(boolean negated) {
        DataSetSearchCriteria dataSetSearchCriteria = new DataSetSearchCriteria();
        if (negated) {
            dataSetSearchCriteria.negate();
        }
        return dataSetSearchCriteria;
    }

    @Override
    protected Set<Long> doFilterIDsByUserRights(Set<Long> ids, AuthorisationInformation authorisationInformation) {
        return this.getAuthProvider().getAuthorisedDatasets(ids, authorisationInformation);
    }

    private CodeSearchCriteria convertToCodeSearchCriterion(PermIdSearchCriteria permIdSearchCriteria) {
        CodeSearchCriteria codeSearchCriteria = new CodeSearchCriteria();
        codeSearchCriteria.setFieldValue((Object)((AbstractStringValue)permIdSearchCriteria.getFieldValue()));
        return codeSearchCriteria;
    }

    @Override
    public Set<Long> searchForIDs(Long userId, AuthorisationInformation authorisationInformation, DataSetSearchCriteria criteria, AbstractCompositeSearchCriteria parentCriteria, String idsColumnName) {
        Class<? extends AbstractCompositeSearchCriteria> parentsSearchCriteriaClass = this.getParentsSearchCriteriaClass();
        Class<? extends AbstractCompositeSearchCriteria> containerSearchCriteriaClass = this.getContainerSearchCriteriaClass();
        Class<? extends AbstractCompositeSearchCriteria> childrenSearchCriteriaClass = this.getChildrenSearchCriteriaClass();
        List<? extends AbstractCompositeSearchCriteria> parentsCriteria = this.getCriteria((AbstractCompositeSearchCriteria)criteria, parentsSearchCriteriaClass);
        List<? extends AbstractCompositeSearchCriteria> containerCriteria = this.getCriteria((AbstractCompositeSearchCriteria)criteria, containerSearchCriteriaClass);
        List<? extends AbstractCompositeSearchCriteria> childrenCriteria = this.getCriteria((AbstractCompositeSearchCriteria)criteria, childrenSearchCriteriaClass);
        List<DataSetSearchCriteria> nestedCriteria = this.getCriteria((AbstractCompositeSearchCriteria)criteria, DataSetSearchCriteria.class);
        List<ISearchCriteria> mainCriteria = this.getOtherCriteriaThan((AbstractCompositeSearchCriteria)criteria, parentsSearchCriteriaClass, childrenSearchCriteriaClass, containerSearchCriteriaClass, DataSetSearchCriteria.class);
        Collection newMainCriteria = mainCriteria.stream().map((? super T searchCriterion) -> searchCriterion instanceof PermIdSearchCriteria ? this.convertToCodeSearchCriterion((PermIdSearchCriteria)searchCriterion) : searchCriterion).collect(Collectors.toList());
        Collection newParentsCriteria = parentsCriteria.stream().map((? super T searchCriterion) -> searchCriterion instanceof PermIdSearchCriteria ? this.convertToCodeSearchCriterion((PermIdSearchCriteria)searchCriterion) : searchCriterion).collect(Collectors.toList());
        Collection newContainerCriteria = containerCriteria.stream().map((? super T searchCriterion) -> searchCriterion instanceof PermIdSearchCriteria ? this.convertToCodeSearchCriterion((PermIdSearchCriteria)searchCriterion) : searchCriterion).collect(Collectors.toList());
        Collection newChildrenCriteria = childrenCriteria.stream().map((? super T searchCriterion) -> searchCriterion instanceof PermIdSearchCriteria ? this.convertToCodeSearchCriterion((PermIdSearchCriteria)searchCriterion) : searchCriterion).collect(Collectors.toList());
        AbstractCompositeEntitySearchManager.CompositeEntityCriteriaVo criteriaVo = new AbstractCompositeEntitySearchManager.CompositeEntityCriteriaVo(newMainCriteria, newParentsCriteria, newChildrenCriteria, newContainerCriteria, nestedCriteria, criteria.getOperator(), criteria.isNegated());
        return super.doSearchForIDs(userId, criteriaVo, idsColumnName, TableMapper.DATA_SET, authorisationInformation);
    }

    @Override
    public List<Long> sortIDs(Collection<Long> ids, SortOptions<DataSet> sortOptions) {
        return this.doSortIDs(ids, sortOptions, TableMapper.DATA_SET);
    }
}

