/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortOrder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.Sorting;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringContainsExactlyValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringContainsValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringMatchesValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringStartsWithValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.GlobalSearchObject;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.fetchoptions.GlobalSearchObjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchObjectKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchTextCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.ISQLAuthorisationInformationProviderDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.dao.ISQLSearchDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.IGlobalSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.GlobalSearchCriteriaTranslator;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyMatch;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Span;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GlobalSearchManager
implements IGlobalSearchManager {
    private static final String PERM_ID_FIELD_NAME = "Perm ID";
    private static final String IDENTIFIER_FIELD_NAME = "Identifier";
    private static final String CODE_FIELD_NAME = "Code";
    private static final String PROPERTY_NAME = "Property";
    private static final String ENTITY_TYPE_FIELD_NAME = "Entity type";
    private static final String PROJECT_FIELD_NAME = "Project";
    private static final String SPACE_FIELD_NAME = "Space";
    private static final Map<String, String> ALIAS_BY_FIELD_NAME = new HashMap<String, String>(4);
    protected final ISQLAuthorisationInformationProviderDAO authProvider;
    private final ISQLSearchDAO searchDAO;

    public GlobalSearchManager(ISQLAuthorisationInformationProviderDAO authProvider, ISQLSearchDAO searchDAO) {
        this.searchDAO = searchDAO;
        this.authProvider = authProvider;
    }

    @Override
    public Collection<Map<String, Object>> searchForIDs(Long userId, AuthorisationInformation authorisationInformation, GlobalSearchCriteria criteria, String idsColumnName, Set<GlobalSearchObjectKind> objectKinds, GlobalSearchObjectFetchOptions fetchOptions, boolean onlyTotalCount) {
        boolean hasStringContains;
        if (objectKinds == null || objectKinds.isEmpty()) {
            return GlobalSearchManager.createEmptyResult(onlyTotalCount);
        }
        boolean hasStringMatches = criteria.getCriteria().stream().anyMatch(criterion -> criterion instanceof GlobalSearchTextCriteria && (((GlobalSearchTextCriteria)criterion).getFieldValue() instanceof StringMatchesValue || ((GlobalSearchTextCriteria)criterion).getFieldValue() instanceof StringStartsWithValue));
        List stringContainsGlobalSearchTextCriteria = criteria.getCriteria().stream().filter(criterion -> criterion instanceof GlobalSearchTextCriteria && (((GlobalSearchTextCriteria)criterion).getFieldValue() instanceof StringContainsValue || ((GlobalSearchTextCriteria)criterion).getFieldValue() instanceof StringContainsExactlyValue)).map(criterion -> (GlobalSearchTextCriteria)criterion).collect(Collectors.toList());
        boolean bl = hasStringContains = !stringContainsGlobalSearchTextCriteria.isEmpty();
        if (hasStringMatches && hasStringContains) {
            throw new IllegalArgumentException("Cannot combine matches and contains criteria in global search.");
        }
        if (!hasStringMatches && !hasStringContains) {
            return GlobalSearchManager.createEmptyResult(onlyTotalCount);
        }
        if (hasStringMatches) {
            return this.searchForIdsUsingMatches(userId, criteria, idsColumnName, authorisationInformation, objectKinds, fetchOptions, onlyTotalCount);
        }
        return this.searchForIdsUsingContains(userId, criteria, idsColumnName, authorisationInformation, objectKinds, fetchOptions, onlyTotalCount);
    }

    private List<Map<String, Object>> searchForIdsUsingMatches(Long userId, GlobalSearchCriteria criteria, String idsColumnName, AuthorisationInformation authorisationInformation, Set<GlobalSearchObjectKind> objectKinds, GlobalSearchObjectFetchOptions fetchOptions, boolean onlyTotalCount) {
        List filteredCriteria = criteria.getCriteria().stream().filter(criterion -> !(criterion instanceof GlobalSearchTextCriteria) || !((String)((AbstractStringValue)((GlobalSearchTextCriteria)criterion).getFieldValue()).getValue()).trim().isEmpty()).collect(Collectors.toList());
        if (filteredCriteria.isEmpty()) {
            return GlobalSearchManager.createEmptyResult(onlyTotalCount);
        }
        criteria.setCriteria(filteredCriteria);
        return this.searchDAO.queryDBForIdsWithGlobalSearchMatchCriteria(userId, criteria, idsColumnName, authorisationInformation, objectKinds, fetchOptions, onlyTotalCount);
    }

    private List<Map<String, Object>> searchForIdsUsingContains(Long userId, GlobalSearchCriteria criteria, String idsColumnName, AuthorisationInformation authorisationInformation, Set<GlobalSearchObjectKind> objectKinds, GlobalSearchObjectFetchOptions fetchOptions, boolean onlyTotalCount) {
        List filteredCriteria = criteria.getCriteria().stream().filter(criterion -> !(criterion instanceof GlobalSearchTextCriteria) || !((String)((AbstractStringValue)((GlobalSearchTextCriteria)criterion).getFieldValue()).getValue()).trim().isEmpty()).flatMap(criterion -> {
            AbstractStringValue fieldValue;
            AbstractStringValue abstractStringValue = fieldValue = criterion instanceof GlobalSearchTextCriteria ? (AbstractStringValue)((GlobalSearchTextCriteria)criterion).getFieldValue() : null;
            if (fieldValue instanceof StringContainsValue) {
                return Arrays.stream(((String)fieldValue.getValue()).split("\\s+")).map(value -> {
                    StringContainsExactlyValue stringContainsExactlyValue = new StringContainsExactlyValue(value);
                    GlobalSearchTextCriteria mappedCriterion = new GlobalSearchTextCriteria();
                    mappedCriterion.setFieldValue((Object)stringContainsExactlyValue);
                    return mappedCriterion;
                });
            }
            return Stream.of(criterion);
        }).collect(Collectors.toList());
        if (filteredCriteria.isEmpty()) {
            return GlobalSearchManager.createEmptyResult(onlyTotalCount);
        }
        criteria.setCriteria(filteredCriteria);
        return this.searchDAO.queryDBForIdsWithGlobalSearchContainsCriteria(userId, criteria, idsColumnName, authorisationInformation, objectKinds, fetchOptions, onlyTotalCount);
    }

    private static List<Map<String, Object>> createEmptyResult(boolean onlyTotalCount) {
        return onlyTotalCount ? Collections.singletonList(Collections.singletonMap("total_count", 0L)) : Collections.emptyList();
    }

    @Override
    public Collection<Map<String, Object>> searchForDetails(Collection<Map<String, Object>> idsAndRanksResult, Long userId, AuthorisationInformation authorisationInformation, GlobalSearchCriteria criteria, String idsColumnName, Set<GlobalSearchObjectKind> objectKinds, GlobalSearchObjectFetchOptions fetchOptions) {
        return GlobalSearchManager.containsValues(idsAndRanksResult) ? this.searchDAO.queryDBWithNonRecursiveCriteria(idsAndRanksResult, userId, criteria, idsColumnName, authorisationInformation, objectKinds, fetchOptions) : Collections.emptySet();
    }

    @Override
    public List<Map<String, Object>> sortRecords(Collection<Map<String, Object>> records, SortOptions<GlobalSearchObject> sortOptions) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(records);
        List sortingList = sortOptions.getSortings();
        result.sort((o1, o2) -> {
            for (Sorting sorting : sortingList) {
                Comparable v1 = this.getPropertyByKey((Map<String, Object>)o1, sorting.getField());
                Comparable v2 = this.getPropertyByKey((Map<String, Object>)o2, sorting.getField());
                if (v1 != null && v2 != null && !v1.equals(v2)) {
                    return sorting.getOrder().isAsc() ? v1.compareTo(v2) : -v1.compareTo(v2);
                }
                if (v1 == null && v2 != null) {
                    return GlobalSearchManager.sortOrderToInt(sorting.getOrder());
                }
                if (v1 == null || v2 != null) continue;
                return -GlobalSearchManager.sortOrderToInt(sorting.getOrder());
            }
            return 0;
        });
        return result;
    }

    private <T extends Comparable<T>> Comparable<T> getPropertyByKey(Map<String, Object> record, String field) {
        String alias = ALIAS_BY_FIELD_NAME.get(field);
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Unknown field %s", field));
        }
        return (Comparable)record.get(alias);
    }

    private static int sortOrderToInt(SortOrder sortOrder) {
        return sortOrder.isAsc() ? 1 : -1;
    }

    protected static boolean containsValues(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    @Override
    public Collection<MatchingEntity> map(Collection<Map<String, Object>> records, boolean withMatches) {
        return records.stream().map(stringObjectMap -> GlobalSearchManager.mapRecordToMatchingEntity(stringObjectMap, withMatches)).collect(Collectors.toMap(matchingEntity -> matchingEntity.getEntityKind() + "-" + matchingEntity.getId(), Function.identity(), (existingMatchingEntity, newMatchingEntity) -> GlobalSearchManager.mergeMatchingEntities(existingMatchingEntity, newMatchingEntity, withMatches), LinkedHashMap::new)).values();
    }

    private static MatchingEntity mapRecordToMatchingEntity(Map<String, Object> fieldsMap, boolean withMatches) {
        Float rank;
        MatchingEntity matchingEntity = new MatchingEntity();
        matchingEntity.setCode((String)fieldsMap.get("code"));
        EntityKind entityKind = EntityKind.valueOf((String)GlobalSearchObjectKind.values()[(Integer)fieldsMap.get("object_kind_ordinal")].toString());
        matchingEntity.setEntityKind(entityKind);
        matchingEntity.setId((Long)fieldsMap.get("id"));
        matchingEntity.setPermId((String)fieldsMap.get("perm_id"));
        String entityTypesCode = (String)fieldsMap.get("enty_code");
        if (entityTypesCode != null) {
            matchingEntity.setEntityType(new BasicEntityType(entityTypesCode));
        }
        matchingEntity.setIdentifier((String)fieldsMap.get("identifier"));
        if (entityKind == EntityKind.EXPERIMENT || entityKind == EntityKind.DATA_SET) {
            Space space = new Space();
            space.setCode((String)fieldsMap.get("space_code"));
            matchingEntity.setSpace(space);
        }
        matchingEntity.setScore((rank = (Float)fieldsMap.get("rank")) != null ? (double)rank.floatValue() : 0.0);
        ArrayList<PropertyMatch> matches = new ArrayList<PropertyMatch>();
        if (withMatches) {
            GlobalSearchManager.mapPropertyMatches(fieldsMap, matches);
            GlobalSearchManager.mapAttributeMatches(fieldsMap, entityKind, matches);
        }
        matchingEntity.setMatches(matches);
        return matchingEntity;
    }

    private static MatchingEntity mergeMatchingEntities(MatchingEntity existingMatchingEntity, MatchingEntity newMatchingEntity, boolean withMatches) {
        existingMatchingEntity.setScore(existingMatchingEntity.getScore() + newMatchingEntity.getScore());
        if (withMatches) {
            List<PropertyMatch> existingMatches = existingMatchingEntity.getMatches();
            List<PropertyMatch> newMatches = newMatchingEntity.getMatches();
            Collection<PropertyMatch> mergedMatches = GlobalSearchManager.mergeMatches(existingMatches, newMatches);
            existingMatchingEntity.setMatches(new ArrayList<PropertyMatch>(mergedMatches));
        }
        return existingMatchingEntity;
    }

    private static Collection<PropertyMatch> mergeMatches(Collection<PropertyMatch> existingMatches, Collection<PropertyMatch> newMatches) {
        ArrayList<PropertyMatch> combinedMatches = new ArrayList<PropertyMatch>(existingMatches);
        combinedMatches.addAll(newMatches);
        return combinedMatches.stream().collect(Collectors.toMap(propertyMatch -> Arrays.asList(propertyMatch.getCode(), propertyMatch.getValue()), Function.identity(), (existingPropertyMatch, newPropertyMatch) -> {
            List<Span> existingSpans = existingPropertyMatch.getSpans();
            List<Span> newSpans = newPropertyMatch.getSpans();
            if (existingSpans != null && newSpans != null) {
                existingSpans.addAll(newSpans);
            }
            return existingPropertyMatch;
        }, HashMap::new)).values();
    }

    private static void mapAttributeMatches(Map<String, Object> fieldsMap, EntityKind entityKind, List<PropertyMatch> matches) {
        GlobalSearchManager.mapAttributeMatch(fieldsMap, matches, "entity_type_match", ENTITY_TYPE_FIELD_NAME);
        GlobalSearchManager.mapAttributeMatch(fieldsMap, matches, "project_match", PROJECT_FIELD_NAME);
        GlobalSearchManager.mapAttributeMatch(fieldsMap, matches, "space_match", SPACE_FIELD_NAME);
        switch (entityKind) {
            case MATERIAL: {
                GlobalSearchManager.mapAttributeMatch(fieldsMap, matches, "identifier", IDENTIFIER_FIELD_NAME);
                break;
            }
            case SAMPLE: {
                GlobalSearchManager.mapAttributeMatch(fieldsMap, matches, "sample_identifier_match", IDENTIFIER_FIELD_NAME);
            }
            case EXPERIMENT: {
                GlobalSearchManager.mapAttributeMatch(fieldsMap, matches, "code_match", CODE_FIELD_NAME);
                GlobalSearchManager.mapAttributeMatch(fieldsMap, matches, "perm_id_match", PERM_ID_FIELD_NAME);
                break;
            }
            case DATA_SET: {
                GlobalSearchManager.mapAttributeMatch(fieldsMap, matches, "code_match", PERM_ID_FIELD_NAME);
                GlobalSearchManager.mapAttributeMatch(fieldsMap, matches, "perm_id_match", PERM_ID_FIELD_NAME);
            }
        }
    }

    private static void mapPropertyMatches(Map<String, Object> fieldsMap, List<PropertyMatch> matches) {
        String sampleMatch;
        String materialMatch;
        String cvCodeMatch;
        String cvLabelMatch;
        String propertyValueMatch = (String)fieldsMap.get("property_value");
        if (propertyValueMatch != null) {
            GlobalSearchManager.addPropertyMatch(propertyValueMatch, fieldsMap, matches);
        }
        if ((cvLabelMatch = (String)fieldsMap.get("cv_label")) != null) {
            GlobalSearchManager.addPropertyMatch(cvLabelMatch, fieldsMap, matches);
        }
        if ((cvCodeMatch = (String)fieldsMap.get("cv_code")) != null) {
            GlobalSearchManager.addPropertyMatch(cvCodeMatch, fieldsMap, matches);
        }
        if ((materialMatch = (String)fieldsMap.get("material_match")) != null) {
            GlobalSearchManager.addPropertyMatch(materialMatch, fieldsMap, matches);
        }
        if ((sampleMatch = (String)fieldsMap.get("sample_match")) != null) {
            GlobalSearchManager.addPropertyMatch(sampleMatch, fieldsMap, matches);
        }
    }

    private static void addPropertyMatch(String codeMatchString, Map<String, Object> fieldsMap, List<PropertyMatch> matches) {
        PropertyMatch propertyMatch = new PropertyMatch();
        propertyMatch.setCode("Property '" + fieldsMap.get("property_type_label") + "'");
        propertyMatch.setValue(codeMatchString);
        String headline = GlobalSearchManager.coalesceMap(fieldsMap, "value_headline", "label_headline", "code_headline");
        if (headline != null) {
            GlobalSearchManager.computeSpans(propertyMatch, headline);
        }
        matches.add(propertyMatch);
    }

    private static void computeSpans(PropertyMatch propertyMatch, String headline) {
        ArrayList<Span> spans = new ArrayList<Span>();
        int startSelLength = GlobalSearchCriteriaTranslator.START_SEL.length();
        int stopSelLength = GlobalSearchCriteriaTranslator.STOP_SEL.length();
        int combinedSelLength = startSelLength + stopSelLength;
        int cursorIndex = headline.indexOf(GlobalSearchCriteriaTranslator.START_SEL);
        int matchesCount = 0;
        while (cursorIndex >= 0) {
            int matchStartIndex = cursorIndex;
            int matchEndIndex = headline.indexOf(GlobalSearchCriteriaTranslator.STOP_SEL, matchStartIndex + startSelLength);
            Span span = new Span();
            span.setStart(matchStartIndex - matchesCount * combinedSelLength);
            span.setEnd(matchEndIndex - startSelLength - matchesCount * combinedSelLength);
            spans.add(span);
            cursorIndex = headline.indexOf(GlobalSearchCriteriaTranslator.START_SEL, matchEndIndex + stopSelLength);
            ++matchesCount;
        }
        propertyMatch.setSpans(spans);
    }

    private static String coalesceMap(Map<String, ?> map, String ... keys) {
        return Arrays.stream(keys).map(map::get).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static void mapAttributeMatch(Map<String, Object> fieldsMap, List<PropertyMatch> matches, String matchAlias, String code) {
        Object fieldMatch = fieldsMap.get(matchAlias);
        if (fieldMatch != null) {
            String codeMatchString = (String)fieldMatch;
            PropertyMatch propertyMatch = new PropertyMatch();
            propertyMatch.setCode(code);
            propertyMatch.setValue(codeMatchString);
            Span span = new Span();
            span.setStart(0);
            span.setEnd(codeMatchString.length());
            propertyMatch.setSpans(new ArrayList<Span>(Collections.singletonList(span)));
            matches.add(propertyMatch);
        }
    }

    static {
        ALIAS_BY_FIELD_NAME.put("SCORE", "rank");
        ALIAS_BY_FIELD_NAME.put("OBJECT_KIND", "object_kind_ordinal");
        ALIAS_BY_FIELD_NAME.put("OBJECT_PERM_ID", "OBJECT_PERM_ID");
        ALIAS_BY_FIELD_NAME.put("OBJECT_IDENTIFIER", "id");
    }
}

