/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractCompositeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchOperator;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.PhysicalDataSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.ISQLAuthorisationInformationProviderDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.dao.ISQLSearchDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.hibernate.IID2PEMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.AbstractLocalSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.DataSetKindSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.DummyCompositeSearchCriterion;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class PhysicalDataSetKindSearchManager
extends AbstractLocalSearchManager<PhysicalDataSearchCriteria, DataSetType, Long> {
    public PhysicalDataSetKindSearchManager(ISQLSearchDAO searchDAO, ISQLAuthorisationInformationProviderDAO authProvider, IID2PEMapper<Long, Long> idsMapper) {
        super(searchDAO, authProvider, idsMapper);
    }

    @Override
    protected AbstractCompositeSearchCriteria createEmptyCriteria(boolean negated) {
        return new PhysicalDataSearchCriteria();
    }

    @Override
    protected Set<Long> doFilterIDsByUserRights(Set<Long> ids, AuthorisationInformation authorisationInformation) {
        return ids;
    }

    @Override
    public Set<Long> searchForIDs(Long userId, AuthorisationInformation authorisationInformation, PhysicalDataSearchCriteria criteria, AbstractCompositeSearchCriteria parentCriteria, String idsColumnName) {
        SearchOperator searchOperator = criteria.getOperator();
        SearchOperator finalSearchOperator = searchOperator == null ? criteria.getOperator() : searchOperator;
        Set<Long> mainCriteriaIds = this.doSearchForIDs(userId, authorisationInformation, idsColumnName);
        if (!criteria.getCriteria().isEmpty()) {
            Set<Long> childCriteriaIds = this.searchForIDsByCriteriaCollection(userId, authorisationInformation, criteria.getCriteria(), finalSearchOperator, TableMapper.EXTERNAL_DATA, idsColumnName);
            mainCriteriaIds.retainAll(childCriteriaIds);
        }
        return mainCriteriaIds;
    }

    @Override
    public List<Long> sortIDs(Collection<Long> ids, SortOptions<DataSetType> sortOptions) {
        return this.doSortIDs(ids, sortOptions, TableMapper.EXTERNAL_DATA);
    }

    private Set<Long> doSearchForIDs(Long userId, AuthorisationInformation authorisationInformation, String idsColumnName) {
        DataSetKindSearchCriteria dataSetKindSearchCriteria = new DataSetKindSearchCriteria();
        dataSetKindSearchCriteria.thatEquals("PHYSICAL");
        DummyCompositeSearchCriterion compositeSearchCriterion = new DummyCompositeSearchCriterion();
        compositeSearchCriterion.setCriteria(Collections.singletonList(dataSetKindSearchCriteria));
        Set<Long> mainCriteriaIntermediateResults = this.getSearchDAO().queryDBForIdsWithGlobalSearchMatchCriteria(userId, compositeSearchCriterion, TableMapper.DATA_SET, idsColumnName, authorisationInformation);
        Set<Long> resultBeforeFiltering = PhysicalDataSetKindSearchManager.containsValues(mainCriteriaIntermediateResults) ? mainCriteriaIntermediateResults : Collections.emptySet();
        return this.filterIDsByUserRights(userId, authorisationInformation, resultBeforeFiltering);
    }
}

