/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractCompositeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyAssignment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.search.PropertyAssignmentSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.search.SemanticAnnotationSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.ISQLAuthorisationInformationProviderDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.dao.IPropertyAssignmentSearchDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.dao.ISQLSearchDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.hibernate.IID2PEMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.AbstractLocalSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.DummyCompositeSearchCriterion;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PropertyAssignmentSearchManager
extends AbstractLocalSearchManager<PropertyAssignmentSearchCriteria, PropertyAssignment, Long> {
    private final IPropertyAssignmentSearchDAO assignmentsSearchDAO;

    public PropertyAssignmentSearchManager(ISQLSearchDAO searchDAO, ISQLAuthorisationInformationProviderDAO authProvider, IID2PEMapper<Long, Long> idsMapper, IPropertyAssignmentSearchDAO assignmentsSearchDAO) {
        super(searchDAO, authProvider, idsMapper);
        this.assignmentsSearchDAO = assignmentsSearchDAO;
    }

    @Override
    protected Set<Long> doFilterIDsByUserRights(Set<Long> ids, AuthorisationInformation authorisationInformation) {
        return ids;
    }

    @Override
    public Set<Long> searchForIDs(Long userId, AuthorisationInformation authorisationInformation, PropertyAssignmentSearchCriteria criteria, AbstractCompositeSearchCriteria parentCriteria, String idsColumnName) {
        Set<Long> finalResults;
        Set<Long> mainCriteriaIntermediateResults = this.getSearchDAO().queryDBForIdsWithGlobalSearchMatchCriteria(userId, (AbstractCompositeSearchCriteria)criteria, TableMapper.SAMPLE_PROPERTY_ASSIGNMENT, idsColumnName, authorisationInformation);
        if (PropertyAssignmentSearchManager.isSampleTypeWithSemanticAnnotationsCriteria(parentCriteria, criteria)) {
            DummyCompositeSearchCriterion compositeSearchCriterion = new DummyCompositeSearchCriterion(criteria.getCriteria(), criteria.getOperator());
            Set<Long> propertyTypesIds = this.getSearchDAO().queryDBForIdsWithGlobalSearchMatchCriteria(userId, compositeSearchCriterion, TableMapper.SEMANTIC_ANNOTATION, "prty_id", authorisationInformation);
            Set<Long> assignmentIDsWithoutAnnotations = this.assignmentsSearchDAO.findAssignmentsWithoutAnnotations(propertyTypesIds, idsColumnName);
            finalResults = new HashSet<Long>(mainCriteriaIntermediateResults);
            finalResults.addAll(assignmentIDsWithoutAnnotations);
        } else {
            finalResults = mainCriteriaIntermediateResults;
        }
        return this.filterIDsByUserRights(userId, authorisationInformation, finalResults);
    }

    private static boolean isSampleTypeWithSemanticAnnotationsCriteria(AbstractCompositeSearchCriteria parentCriteria, PropertyAssignmentSearchCriteria criteria) {
        return parentCriteria.getClass() == SampleTypeSearchCriteria.class && criteria.getCriteria().stream().anyMatch(subcriterion -> subcriterion instanceof SemanticAnnotationSearchCriteria);
    }

    @Override
    public List<Long> sortIDs(Collection<Long> ids, SortOptions<PropertyAssignment> sortOptions) {
        return this.doSortIDs(ids, sortOptions, TableMapper.SAMPLE_PROPERTY_ASSIGNMENT);
    }

    @Override
    protected AbstractCompositeSearchCriteria createEmptyCriteria(boolean negated) {
        return new PropertyAssignmentSearchCriteria();
    }
}

