/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractCompositeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.search.SpaceSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.ISQLAuthorisationInformationProviderDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.dao.ISQLSearchDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.hibernate.IID2PEMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.AbstractLocalSearchManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SpaceSearchManager
extends AbstractLocalSearchManager<SpaceSearchCriteria, Space, Long> {
    public SpaceSearchManager(ISQLSearchDAO searchDAO, ISQLAuthorisationInformationProviderDAO authProvider, IID2PEMapper<Long, Long> idsMapper) {
        super(searchDAO, authProvider, idsMapper);
    }

    @Override
    protected AbstractCompositeSearchCriteria createEmptyCriteria(boolean negated) {
        return new SpaceSearchCriteria();
    }

    @Override
    protected Set<Long> doFilterIDsByUserRights(Set<Long> ids, AuthorisationInformation authorisationInformation) {
        return this.getAuthProvider().getAuthorisedSpaces(ids, authorisationInformation);
    }

    @Override
    public Set<Long> searchForIDs(Long userId, AuthorisationInformation authorisationInformation, SpaceSearchCriteria criteria, AbstractCompositeSearchCriteria parentCriteria, String idsColumnName) {
        Set<Long> mainCriteriaIntermediateResults = this.getSearchDAO().queryDBForIdsWithGlobalSearchMatchCriteria(userId, (AbstractCompositeSearchCriteria)criteria, TableMapper.SPACE, idsColumnName, authorisationInformation);
        Set<Long> resultBeforeFiltering = SpaceSearchManager.containsValues(mainCriteriaIntermediateResults) ? mainCriteriaIntermediateResults : Collections.emptySet();
        return this.filterIDsByUserRights(userId, authorisationInformation, resultBeforeFiltering);
    }

    @Override
    public List<Long> sortIDs(Collection<Long> ids, SortOptions<Space> sortOptions) {
        return this.doSortIDs(ids, sortOptions, TableMapper.SPACE);
    }
}

