/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractCompositeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NameSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.PermIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.Tag;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.search.TagSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.ISQLAuthorisationInformationProviderDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.dao.ISQLSearchDAO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.hibernate.IID2PEMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.AbstractLocalSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.DummyCompositeSearchCriterion;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TagSearchManager
extends AbstractLocalSearchManager<TagSearchCriteria, Tag, Long> {
    public TagSearchManager(ISQLSearchDAO searchDAO, ISQLAuthorisationInformationProviderDAO authProvider, IID2PEMapper<Long, Long> idsMapper) {
        super(searchDAO, authProvider, idsMapper);
    }

    @Override
    protected AbstractCompositeSearchCriteria createEmptyCriteria(boolean negated) {
        return new TagSearchCriteria();
    }

    @Override
    protected Set<Long> doFilterIDsByUserRights(Set<Long> ids, AuthorisationInformation authorisationInformation) {
        return ids;
    }

    private NameSearchCriteria convertToNameSearchCriterion(AbstractFieldSearchCriteria<AbstractStringValue> criterion) {
        return this.convertToOtherCriterion(criterion, () -> {
            NameSearchCriteria result = new NameSearchCriteria();
            if (criterion instanceof StringFieldSearchCriteria && ((StringFieldSearchCriteria)criterion).isUseWildcards()) {
                result.withWildcards();
            }
            return result;
        });
    }

    @Override
    public Set<Long> searchForIDs(Long userId, AuthorisationInformation authorisationInformation, TagSearchCriteria criteria, AbstractCompositeSearchCriteria parentCriteria, String idsColumnName) {
        Collection newCriteria = criteria.getCriteria().stream().map((? super T searchCriterion) -> {
            if (searchCriterion instanceof PermIdSearchCriteria) {
                return this.convertToNameSearchCriterion((AbstractFieldSearchCriteria<AbstractStringValue>)((PermIdSearchCriteria)searchCriterion));
            }
            return searchCriterion;
        }).collect(Collectors.toList());
        Set<Long> mainCriteriaIntermediateResults = this.getSearchDAO().queryDBForIdsWithGlobalSearchMatchCriteria(userId, new DummyCompositeSearchCriterion(newCriteria, criteria.getOperator()), TableMapper.TAG, idsColumnName, authorisationInformation);
        if (!TagSearchManager.containsValues(mainCriteriaIntermediateResults)) {
            return Collections.emptySet();
        }
        Set<Long> resultAfterFiltering = this.getAuthProvider().getTagsOfUser(mainCriteriaIntermediateResults, userId);
        if (!TagSearchManager.containsValues(resultAfterFiltering)) {
            return Collections.emptySet();
        }
        return this.filterIDsByUserRights(userId, authorisationInformation, resultAfterFiltering);
    }

    @Override
    public List<Long> sortIDs(Collection<Long> ids, SortOptions<Tag> sortOptions) {
        return this.doSortIDs(ids, sortOptions, TableMapper.TAG);
    }
}

