/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.sql;

import ch.ethz.sis.openbis.generic.server.asapi.v3.search.PSQLTypes;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.sql.ISQLExecutor;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractSQLExecutor
implements ISQLExecutor {
    private static final Logger OPERATION_LOG = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AbstractSQLExecutor.class);
    private static final Map<Class<?>, PSQLTypes> TYPE_CONVERSION_MAP = new HashMap();

    public abstract Connection getConnection();

    @Override
    public List<Map<String, Object>> execute(String sqlQuery, List<Object> args) {
        OPERATION_LOG.debug((Object)("QUERY: " + sqlQuery));
        if (OPERATION_LOG.isTraceEnabled()) {
            OPERATION_LOG.trace((Object)("ARGS: " + Arrays.deepToString(args.toArray())));
        }
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(sqlQuery);){
            this.setArgsForPreparedStatement(args, preparedStatement);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int columnCount = resultSetMetaData.getColumnCount();
                ArrayList<String> columnNames = new ArrayList<String>(columnCount);
                for (int index = 0; index < columnCount; ++index) {
                    columnNames.add(resultSetMetaData.getColumnName(index + 1));
                }
                while (resultSet.next()) {
                    LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                    for (String columnName : columnNames) {
                        row.put(columnName, resultSet.getObject(columnName));
                    }
                    results.add(row);
                }
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        OPERATION_LOG.debug((Object)("RESULTS COUNT: " + results.size()));
        OPERATION_LOG.trace((Object)("RESULTS: " + results));
        return results;
    }

    private void setArgsForPreparedStatement(List<Object> args, PreparedStatement preparedStatement) throws SQLException {
        for (int index = 0; index < args.size(); ++index) {
            Object object = args.get(index);
            if (object != null && object.getClass().isArray()) {
                Object[] objectArray = (Object[])object;
                Class<?> arrayObjectType = object.getClass().getComponentType();
                PSQLTypes psqlType = TYPE_CONVERSION_MAP.get(arrayObjectType);
                if (psqlType == null) {
                    throw new IllegalArgumentException("JDBCSQLExecutor don't support arrays of type: " + object.getClass().getName() + " - With elements of type: " + arrayObjectType.getName() + " - Data: " + Arrays.toString(objectArray));
                }
                preparedStatement.setArray(index + 1, preparedStatement.getConnection().createArrayOf(psqlType.toString(), objectArray));
                continue;
            }
            if (object instanceof Date) {
                Date date = (Date)object;
                preparedStatement.setTimestamp(index + 1, new Timestamp(date.getTime()));
                continue;
            }
            if (object instanceof Calendar) {
                Calendar calendar = (Calendar)object;
                preparedStatement.setTimestamp(index + 1, new Timestamp(calendar.getTimeInMillis()), calendar);
                continue;
            }
            preparedStatement.setObject(index + 1, object);
        }
    }

    static {
        TYPE_CONVERSION_MAP.put(Boolean.class, PSQLTypes.BOOLEAN);
        TYPE_CONVERSION_MAP.put(Character.class, PSQLTypes.CHARACTER);
        TYPE_CONVERSION_MAP.put(String.class, PSQLTypes.VARCHAR);
        TYPE_CONVERSION_MAP.put(Double.class, PSQLTypes.FLOAT8);
        TYPE_CONVERSION_MAP.put(Float.class, PSQLTypes.FLOAT4);
        TYPE_CONVERSION_MAP.put(Long.class, PSQLTypes.INT8);
        TYPE_CONVERSION_MAP.put(Integer.class, PSQLTypes.INT4);
        TYPE_CONVERSION_MAP.put(Short.class, PSQLTypes.INT2);
        TYPE_CONVERSION_MAP.put(Byte.class, PSQLTypes.INT2);
    }
}

