/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.Sorting;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchOperator;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringContainsExactlyValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringContainsValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringMatchesValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringStartsWithValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.fetchoptions.GlobalSearchObjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.fetchoptions.GlobalSearchObjectSortOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchObjectKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchObjectKindCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchTextCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchWildCardsCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.PSQLTypes;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.AttributesMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SelectQuery;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.AnyFieldSearchConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.TranslatorUtils;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.log4j.Logger;

public class GlobalSearchCriteriaTranslator {
    private static final Random RANDOM = new Random();
    public static final String START_SEL = "<" + GlobalSearchCriteriaTranslator.generateRandomString() + "--";
    public static final String STOP_SEL = "--" + GlobalSearchCriteriaTranslator.generateRandomString() + ">";
    public static final String RANK_ALIAS = "rank";
    public static final String IDENTIFIER_ALIAS = "identifier";
    public static final String OBJECT_KIND_ORDINAL_ALIAS = "object_kind_ordinal";
    public static final String SPACE_CODE_ALIAS = "space_code";
    public static final String CODE_MATCH_ALIAS = "code_match";
    public static final String PERM_ID_MATCH_ALIAS = "perm_id_match";
    public static final String TOTAL_COUNT_ALIAS = "total_count";
    public static final String SAMPLE_IDENTIFIER_MATCH_ALIAS = "sample_identifier_match";
    public static final String MATERIAL_MATCH_ALIAS = "material_match";
    public static final String SAMPLE_MATCH_ALIAS = "sample_match";
    public static final String ENTITY_TYPE_MATCH_ALIAS = "entity_type_match";
    public static final String PROJECT_MATCH_ALIAS = "project_match";
    public static final String SPACE_MATCH_ALIAS = "space_match";
    public static final String ENTITY_TYPES_CODE_ALIAS = "enty_code";
    public static final String PROPERTY_TYPE_LABEL_ALIAS = "property_type_label";
    public static final String CV_CODE_ALIAS = "cv_code";
    public static final String CV_LABEL_ALIAS = "cv_label";
    public static final String PROPERTY_VALUE_ALIAS = "property_value";
    public static final String VALUE_HEADLINE_ALIAS = "value_headline";
    public static final String LABEL_HEADLINE_ALIAS = "label_headline";
    public static final String CODE_HEADLINE_ALIAS = "code_headline";
    private static final String REG_CONFIG = "english";
    private static final String PROPERTIES_TABLE_ALIAS = "prop";
    private static final String ENTITY_TYPES_TABLE_ALIAS = "enty";
    private static final String CONTROLLED_VOCABULARY_TERMS_TABLE_ALIAS = "cvte";
    private static final String SAMPLES_TABLE_ALIAS = "samp";
    private static final String MATERIALS_TABLE_ALIAS = "mat";
    private static final String SPACE_TABLE_ALIAS = "space";
    private static final String PROJECT_TABLE_ALIAS = "proj";
    private static final String CONTAINER_TABLE_ALIAS = "cont";
    private static final String ENTITY_TYPES_ATTRIBUTE_TYPES_TABLE_ALIAS = "etpt";
    private static final String ATTRIBUTE_TYPES_TABLE_ALIAS = "prty";
    private static final String DATA_TYPES_TABLE_ALIAS = "daty";
    private static final String LINKED_SAMPLES_TABLE_ALIAS = "linked_samp";
    private static final String LINKED_EXPERIMENTS_TABLE_ALIAS = "linked_expe";
    private static final String LINKED_PROJECTS_TABLE_ALIAS = "linked_proj";
    private static final String LINKED_SPACE_TABLE_ALIAS = "linked_space";
    private static final String TS_HEADLINE_OPTIONS = "HighlightAll=TRUE, StartSel=" + START_SEL + ", StopSel=" + STOP_SEL;
    private static final Logger LOG = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, GlobalSearchCriteriaTranslator.class);
    private static final Map<String, String> ALIAS_BY_FIELD_NAME = new HashMap<String, String>(4);
    private static final String PREFIX_MATCH_SUFFIX = " || ':*'";

    private GlobalSearchCriteriaTranslator() {
        throw new UnsupportedOperationException();
    }

    private static String generateRandomString() {
        int leftLimit = 97;
        int rightLimit = 122;
        int targetStringLength = 10;
        return RANDOM.ints(97, 123).limit(10L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static SelectQuery translateToShortQuery(TranslationContext translationContext, boolean onlyTotalCount) {
        String setOperator;
        Collection<ISearchCriteria> subcriteria = translationContext.getCriteria();
        if (subcriteria == null) {
            throw new IllegalArgumentException("Null criteria provided.");
        }
        boolean withWildcards = subcriteria.stream().anyMatch(criterion -> criterion instanceof GlobalSearchWildCardsCriteria);
        if (withWildcards) {
            LOG.warn((Object)"Full text search with wildcards is not supported.");
        }
        StringBuilder sqlBuilder = new StringBuilder("(");
        Spliterator<ISearchCriteria> spliterator = subcriteria.stream().filter(criterion -> !(criterion instanceof GlobalSearchWildCardsCriteria) && !(criterion instanceof GlobalSearchObjectKindCriteria)).spliterator();
        String string = setOperator = translationContext.getOperator() == SearchOperator.OR ? "UNION" : "INTERSECT";
        if (spliterator.tryAdvance(criterion -> GlobalSearchCriteriaTranslator.translateShortCriterion(sqlBuilder, translationContext, criterion))) {
            StreamSupport.stream(spliterator, false).forEach(criterion -> {
                sqlBuilder.append(")").append("\n").append(setOperator).append("\n").append("(").append("\n");
                GlobalSearchCriteriaTranslator.translateShortCriterion(sqlBuilder, translationContext, criterion);
            });
        }
        sqlBuilder.append(")");
        StringBuilder prefixSqlBuilder = new StringBuilder();
        GlobalSearchCriteriaTranslator.buildOuterSelect(prefixSqlBuilder, onlyTotalCount);
        prefixSqlBuilder.append("\n").append("FROM").append(" ").append("(").append("\n").append("SELECT").append(" ").append("proj_id").append(",").append(" ").append("space_id").append(",").append(" ").append("id").append(",").append(" ").append("perm_id").append(" ").append("perm_id").append(",").append(" ").append(OBJECT_KIND_ORDINAL_ALIAS).append(",").append(" ").append("SUM").append("(").append(RANK_ALIAS).append(")").append(" ").append(RANK_ALIAS).append(",").append(" ").append(IDENTIFIER_ALIAS).append("\n").append("FROM").append(" ").append("(").append("\n");
        StringBuilder suffixSqlBuilder = new StringBuilder();
        suffixSqlBuilder.append(")").append(" ").append("q1").append("\n").append("GROUP BY").append(" ");
        suffixSqlBuilder.append("proj_id").append(",").append(" ");
        suffixSqlBuilder.append("space_id").append(",").append(" ");
        suffixSqlBuilder.append("expe_id").append(",").append(" ");
        suffixSqlBuilder.append("id").append(",").append(" ");
        suffixSqlBuilder.append("perm_id").append(",").append(" ");
        suffixSqlBuilder.append(OBJECT_KIND_ORDINAL_ALIAS).append(",").append(" ");
        suffixSqlBuilder.append(IDENTIFIER_ALIAS).append("\n");
        suffixSqlBuilder.append(")").append(" ").append("q2").append("\n");
        if (!onlyTotalCount) {
            GlobalSearchCriteriaTranslator.translateOrderBy(suffixSqlBuilder, translationContext);
            GlobalSearchCriteriaTranslator.translateLimitOffset(suffixSqlBuilder, translationContext);
        }
        return new SelectQuery(prefixSqlBuilder.toString() + sqlBuilder.toString() + suffixSqlBuilder.toString(), translationContext.getArgs());
    }

    private static void buildOuterSelect(StringBuilder sqlBuilder, boolean onlyTotalCount) {
        sqlBuilder.append("SELECT").append(" ");
        if (onlyTotalCount) {
            sqlBuilder.append("COUNT").append("(").append('*').append(")");
        } else {
            sqlBuilder.append("id").append(",").append(" ").append("perm_id").append(",").append(" ").append(OBJECT_KIND_ORDINAL_ALIAS).append(",").append(" ").append(RANK_ALIAS).append(",").append(" ").append(IDENTIFIER_ALIAS).append(",").append(" ").append("COUNT").append("(").append('*').append(")").append(" ").append("OVER").append("(").append(")");
        }
        sqlBuilder.append(" ").append(TOTAL_COUNT_ALIAS);
    }

    public static SelectQuery translateToShortContainsQuery(TranslationContext translationContext, boolean onlyTotalCount) {
        Collection<ISearchCriteria> subcriteria = translationContext.getCriteria();
        if (subcriteria == null) {
            throw new IllegalArgumentException("Null criteria provided.");
        }
        StringBuilder sqlBuilder = new StringBuilder();
        Spliterator<ISearchCriteria> spliterator = subcriteria.stream().filter(criterion -> !(criterion instanceof GlobalSearchObjectKindCriteria) && !(criterion instanceof GlobalSearchWildCardsCriteria)).spliterator();
        String setOperator = translationContext.getOperator() == SearchOperator.OR ? "UNION" : "INTERSECT";
        boolean useWildcards = subcriteria.stream().anyMatch(criterion -> criterion instanceof GlobalSearchWildCardsCriteria);
        GlobalSearchCriteriaTranslator.buildOuterSelect(sqlBuilder, onlyTotalCount);
        sqlBuilder.append("\n").append("FROM").append(" ").append("(").append("\n").append("(").append("\n");
        if (spliterator.tryAdvance(criterion -> GlobalSearchCriteriaTranslator.translateShortContainsCriterionCondition(sqlBuilder, translationContext, criterion, useWildcards))) {
            StreamSupport.stream(spliterator, false).forEach(criterion -> {
                sqlBuilder.append(")").append("\n").append(setOperator).append("\n").append("(").append("\n");
                GlobalSearchCriteriaTranslator.translateShortContainsCriterionCondition(sqlBuilder, translationContext, criterion, useWildcards);
            });
        }
        sqlBuilder.append(")").append("\n");
        sqlBuilder.append(")").append(" ").append("q");
        if (!onlyTotalCount) {
            sqlBuilder.append("\n");
            GlobalSearchCriteriaTranslator.translateOrderBy(sqlBuilder, translationContext);
            GlobalSearchCriteriaTranslator.translateLimitOffset(sqlBuilder, translationContext);
        }
        return new SelectQuery(sqlBuilder.toString(), translationContext.getArgs());
    }

    private static void translateShortContainsCriterionCondition(StringBuilder sqlBuilder, TranslationContext translationContext, ISearchCriteria criterion, boolean useWildcards) {
        Set<GlobalSearchObjectKind> objectKinds = translationContext.getObjectKinds();
        if (criterion instanceof GlobalSearchTextCriteria && objectKinds != null && !objectKinds.isEmpty()) {
            GlobalSearchTextCriteria globalSearchTextCriterion = (GlobalSearchTextCriteria)criterion;
            boolean containsSample = objectKinds.contains(GlobalSearchObjectKind.SAMPLE);
            boolean containsExperiment = objectKinds.contains(GlobalSearchObjectKind.EXPERIMENT);
            boolean containsDataSet = objectKinds.contains(GlobalSearchObjectKind.DATA_SET);
            boolean containsMaterial = objectKinds.contains(GlobalSearchObjectKind.MATERIAL);
            if (containsSample) {
                GlobalSearchCriteriaTranslator.buildShortSubquery(sqlBuilder, translationContext, useWildcards, globalSearchTextCriterion, TableMapper.SAMPLE);
            }
            if (containsExperiment) {
                if (containsSample) {
                    sqlBuilder.append("UNION ALL").append("\n");
                }
                GlobalSearchCriteriaTranslator.buildShortSubquery(sqlBuilder, translationContext, useWildcards, globalSearchTextCriterion, TableMapper.EXPERIMENT);
            }
            if (containsDataSet) {
                if (containsSample || containsExperiment) {
                    sqlBuilder.append("UNION ALL").append("\n");
                }
                GlobalSearchCriteriaTranslator.buildShortSubquery(sqlBuilder, translationContext, useWildcards, globalSearchTextCriterion, TableMapper.DATA_SET);
            }
            if (containsMaterial) {
                if (containsSample || containsExperiment || containsDataSet) {
                    sqlBuilder.append("UNION ALL").append("\n");
                }
                GlobalSearchCriteriaTranslator.buildShortSubquery(sqlBuilder, translationContext, useWildcards, globalSearchTextCriterion, TableMapper.MATERIAL);
            }
        }
    }

    private static void buildShortSubquery(StringBuilder sqlBuilder, TranslationContext translationContext, boolean useWildcards, GlobalSearchTextCriteria globalSearchTextCriterion, TableMapper tableMapper) {
        StringBuilder fromSqlBuilder = new StringBuilder();
        GlobalSearchCriteriaTranslator.buildShortContainsFrom(fromSqlBuilder, translationContext, globalSearchTextCriterion, tableMapper);
        GlobalSearchCriteriaTranslator.buildShortContainsSelect(sqlBuilder, translationContext, globalSearchTextCriterion, tableMapper);
        sqlBuilder.append((CharSequence)fromSqlBuilder);
        GlobalSearchCriteriaTranslator.buildShortContainsWhere(sqlBuilder, translationContext, globalSearchTextCriterion, tableMapper, useWildcards);
    }

    private static void buildShortContainsSelect(StringBuilder sqlBuilder, TranslationContext translationContext, GlobalSearchTextCriteria globalSearchTextCriterion, TableMapper tableMapper) {
        int objectKindOrdinal = GlobalSearchObjectKind.valueOf((String)tableMapper.toString()).ordinal();
        sqlBuilder.append("SELECT").append(" ").append("DISTINCT").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("id");
        sqlBuilder.append(",").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append(GlobalSearchCriteriaTranslator.getPermId(tableMapper)).append(" ").append("perm_id");
        sqlBuilder.append(",").append(" ").append(objectKindOrdinal).append(" ").append(OBJECT_KIND_ORDINAL_ALIAS);
        sqlBuilder.append(",").append(" ").append(0).append("::").append((Object)PSQLTypes.FLOAT4).append(" ").append(RANK_ALIAS);
        sqlBuilder.append(",").append(" ");
        Map<String, JoinInformation> aliases = translationContext.getAliases().get(globalSearchTextCriterion);
        boolean hasSpaces = GlobalSearchCriteriaTranslator.hasSpaces(tableMapper);
        boolean hasProjects = GlobalSearchCriteriaTranslator.hasProjects(tableMapper);
        GlobalSearchCriteriaTranslator.buildSelectIdentifier(sqlBuilder, tableMapper, hasSpaces, hasProjects, aliases.get("entity_type").getSubTableAlias(), hasSpaces ? aliases.get("spaces").getSubTableAlias() : null, hasProjects ? aliases.get("projects").getSubTableAlias() : null);
        sqlBuilder.append("\n");
    }

    private static void buildShortContainsFrom(StringBuilder sqlBuilder, TranslationContext translationContext, GlobalSearchTextCriteria globalSearchTextCriterion, TableMapper tableMapper) {
        sqlBuilder.append("FROM").append(" ").append(tableMapper.getEntitiesTable()).append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS);
        Map<String, JoinInformation> joinInformationMap = GlobalSearchCriteriaTranslator.getJoinInformationMap(tableMapper);
        joinInformationMap.values().forEach(joinInformation -> TranslatorUtils.appendJoin(sqlBuilder, joinInformation));
        translationContext.getAliases().put(globalSearchTextCriterion, joinInformationMap);
        sqlBuilder.append("\n");
    }

    private static void buildShortContainsWhere(StringBuilder sqlBuilder, TranslationContext translationContext, GlobalSearchTextCriteria globalSearchTextCriterion, TableMapper tableMapper, boolean useWildcards) {
        sqlBuilder.append("WHERE").append(" ");
        AnyFieldSearchConditionTranslator.translateAnyField((AbstractFieldSearchCriteria<AbstractStringValue>)globalSearchTextCriterion, useWildcards, tableMapper, translationContext.getArgs(), sqlBuilder, GlobalSearchCriteriaTranslator.getJoinInformationMap(tableMapper));
        GlobalSearchCriteriaTranslator.translateAuthorisation(sqlBuilder, translationContext, tableMapper);
        sqlBuilder.append("\n");
    }

    private static Map<String, JoinInformation> getJoinInformationMap(TableMapper tableMapper) {
        AtomicInteger indexCounter = new AtomicInteger(1);
        return TranslatorUtils.getFieldJoinInformationMap(tableMapper, () -> TranslatorUtils.getAlias(indexCounter));
    }

    private static void translateOrderBy(StringBuilder sqlBuilder, TranslationContext translationContext) {
        GlobalSearchObjectSortOptions sortOptions;
        GlobalSearchObjectSortOptions suppliedSortOptions = translationContext.getFetchOptions().getSortBy();
        if (suppliedSortOptions != null) {
            sortOptions = suppliedSortOptions;
        } else {
            sortOptions = new GlobalSearchObjectSortOptions();
            sortOptions.score().desc();
        }
        List sortings = sortOptions.getSortings();
        if (sortings != null && !sortings.isEmpty()) {
            sqlBuilder.append("ORDER BY").append(" ");
            Spliterator<Sorting> spliterator = sortings.stream().spliterator();
            if (spliterator.tryAdvance(sorting -> GlobalSearchCriteriaTranslator.addOrderByField(sqlBuilder, sorting))) {
                StreamSupport.stream(spliterator, false).forEach(sorting -> {
                    sqlBuilder.append(",").append(" ");
                    GlobalSearchCriteriaTranslator.addOrderByField(sqlBuilder, sorting);
                });
            }
            sqlBuilder.append(",").append(" ").append("id").append(" ").append("DESC");
            sqlBuilder.append(",").append(" ").append(OBJECT_KIND_ORDINAL_ALIAS).append(" ").append("ASC");
            sqlBuilder.append("\n");
        }
    }

    private static void addOrderByField(StringBuilder suffixSqlBuilder, Sorting sorting) {
        suffixSqlBuilder.append(ALIAS_BY_FIELD_NAME.get(sorting.getField())).append(" ").append(sorting.getOrder().toString());
    }

    private static void translateLimitOffset(StringBuilder suffixSqlBuilder, TranslationContext translationContext) {
        GlobalSearchObjectFetchOptions fetchOptions = translationContext.getFetchOptions();
        Integer foFromRecord = fetchOptions.getFrom();
        Integer foRecordsCount = fetchOptions.getCount();
        if (foRecordsCount != null) {
            suffixSqlBuilder.append("LIMIT").append(" ").append(foRecordsCount).append("\n");
        }
        if (foFromRecord != null) {
            suffixSqlBuilder.append("OFFSET").append(" ").append(foFromRecord).append("\n");
        }
    }

    private static void translateAuthorisation(StringBuilder sqlBuilder, TranslationContext translationContext, TableMapper tableMapper) {
        AuthorisationInformation authorisationInformation = translationContext.getAuthorisationInformation();
        List<Object> args = translationContext.getArgs();
        if (!authorisationInformation.isInstanceRole()) {
            if (tableMapper != TableMapper.MATERIAL) {
                sqlBuilder.append(" ").append("AND").append(" ").append("(").append("\n");
            }
            switch (tableMapper) {
                case SAMPLE: {
                    sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("space_id").append(" ").append("IN").append(" ").append("(").append("SELECT").append(" ").append("UNNEST").append("(").append('?').append(")").append(")").append(" ").append("OR").append("\n");
                    sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("proj_id").append(" ").append("IN").append(" ").append("(").append("SELECT").append(" ").append("UNNEST").append("(").append('?').append(")").append(")").append(" ").append("OR").append("\n");
                    sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("expe_id").append(" ").append("IN").append(" ").append("(").append("SELECT").append(" ").append("id").append(" ").append("FROM").append(" ").append(TableMapper.EXPERIMENT.getEntitiesTable()).append(" ").append("WHERE").append(" ").append("proj_id").append(" ").append("IN").append(" ").append("(SELECT UNNEST(?))").append(")").append(" ").append("OR").append("\n");
                    sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("space_id").append(" ").append("IS NULL").append(" ").append("AND").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("proj_id").append(" ").append("IS NULL").append("\n");
                    Long[] projectIds = authorisationInformation.getProjectIds().toArray(new Long[0]);
                    args.add(authorisationInformation.getSpaceIds().toArray(new Long[0]));
                    args.add(projectIds);
                    args.add(projectIds);
                    break;
                }
                case EXPERIMENT: {
                    sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("proj_id").append(" ").append("IN").append(" ").append("(").append("SELECT").append(" ").append("id").append(" ").append("FROM").append(" ").append("projects").append(" ").append("WHERE").append(" ").append("space_id").append(" ").append("IN").append(" ").append("(").append("SELECT").append(" ").append("UNNEST").append("(").append('?').append(")").append(")").append(")").append(" ").append("OR").append("\n");
                    sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("proj_id").append(" ").append("IN").append(" ").append("(").append("SELECT").append(" ").append("UNNEST").append("(").append('?').append(")").append(")").append("\n");
                    args.add(authorisationInformation.getSpaceIds().toArray(new Long[0]));
                    args.add(authorisationInformation.getProjectIds().toArray(new Long[0]));
                    break;
                }
                case DATA_SET: {
                    String d = "d";
                    String ep = "ep";
                    String sp = "sp";
                    String exp = "exp";
                    String samp = SAMPLES_TABLE_ALIAS;
                    sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("id").append(" ").append("IN").append(" ").append("(");
                    sqlBuilder.append("SELECT").append(" ").append("d").append(".").append("id").append("\n");
                    sqlBuilder.append("FROM").append(" ").append(TableMapper.DATA_SET.getEntitiesTable()).append(" ").append("d").append("\n");
                    sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.EXPERIMENT.getEntitiesTable()).append(" ").append("exp").append(" ").append("ON").append(" ").append("d").append(".").append("expe_id").append(" ").append("=").append(" ").append("exp").append(".").append("id").append("\n");
                    sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.PROJECT.getEntitiesTable()).append(" ").append("ep").append(" ").append("ON").append(" ").append("exp").append(".").append("proj_id").append(" ").append("=").append(" ").append("ep").append(".").append("id").append("\n");
                    sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.SAMPLE.getEntitiesTable()).append(" ").append(SAMPLES_TABLE_ALIAS).append(" ").append("ON").append(" ").append("d").append(".").append("samp_id").append(" ").append("=").append(" ").append(SAMPLES_TABLE_ALIAS).append(".").append("id").append("\n");
                    sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.PROJECT.getEntitiesTable()).append(" ").append("sp").append(" ").append("ON").append(" ").append(SAMPLES_TABLE_ALIAS).append(".").append("proj_id").append(" ").append("=").append(" ").append("sp").append(".").append("id").append("\n");
                    sqlBuilder.append("WHERE").append(" ").append("ep").append(".").append("id").append(" ").append("IN").append(" ").append("(SELECT UNNEST(?))").append(" ").append("OR").append(" ").append("sp").append(".").append("id").append(" ").append("IN").append(" ").append("(SELECT UNNEST(?))").append(" ").append("OR").append("\n").append("ep").append(".").append("space_id").append(" ").append("IN").append(" ").append("(SELECT UNNEST(?))").append(" ").append("OR").append(" ").append("sp").append(".").append("space_id").append(" ").append("IN").append(" ").append("(SELECT UNNEST(?))");
                    sqlBuilder.append(")").append("\n");
                    args.add(authorisationInformation.getProjectIds().toArray(new Long[0]));
                    args.add(authorisationInformation.getProjectIds().toArray(new Long[0]));
                    args.add(authorisationInformation.getSpaceIds().toArray(new Long[0]));
                    args.add(authorisationInformation.getSpaceIds().toArray(new Long[0]));
                    break;
                }
                case MATERIAL: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Full text search does not support this table mapper: " + (Object)((Object)tableMapper));
                }
            }
            if (tableMapper != TableMapper.MATERIAL) {
                sqlBuilder.append(")");
            }
        }
    }

    public static SelectQuery translateToDetailsQuery(TranslationContext translationContext, Map<GlobalSearchObjectKind, Set<Long>> idSetByObjectKindMap) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT *\n");
        sqlBuilder.append("FROM").append(" ").append("(").append("\n");
        sqlBuilder.append("(").append("\n");
        Spliterator<ISearchCriteria> spliterator = translationContext.getCriteria().stream().filter(criterion -> !(criterion instanceof GlobalSearchWildCardsCriteria) && !(criterion instanceof GlobalSearchObjectKindCriteria)).spliterator();
        if (spliterator.tryAdvance(criterion -> GlobalSearchCriteriaTranslator.translateDetailsCriterion(sqlBuilder, translationContext, criterion, idSetByObjectKindMap))) {
            StreamSupport.stream(spliterator, false).forEach(criterion -> {
                sqlBuilder.append(")").append("\n").append("UNION ALL").append("\n").append("(").append("\n");
                GlobalSearchCriteriaTranslator.translateDetailsCriterion(sqlBuilder, translationContext, criterion, idSetByObjectKindMap);
            });
        }
        sqlBuilder.append(")").append("\n");
        sqlBuilder.append(")").append(" ").append("q1").append("\n");
        return new SelectQuery(sqlBuilder.toString(), translationContext.getArgs());
    }

    private static void translateShortCriterion(StringBuilder sqlBuilder, TranslationContext translationContext, ISearchCriteria criterion) {
        Set<GlobalSearchObjectKind> objectKinds = translationContext.getObjectKinds();
        if (criterion instanceof GlobalSearchTextCriteria && objectKinds != null && !objectKinds.isEmpty() && (((GlobalSearchTextCriteria)criterion).getFieldValue() instanceof StringMatchesValue || ((GlobalSearchTextCriteria)criterion).getFieldValue() instanceof StringStartsWithValue)) {
            GlobalSearchTextCriteria globalSearchTextCriterion = (GlobalSearchTextCriteria)criterion;
            boolean containsSample = objectKinds.contains(GlobalSearchObjectKind.SAMPLE);
            boolean containsExperiment = objectKinds.contains(GlobalSearchObjectKind.EXPERIMENT);
            boolean containsDataSet = objectKinds.contains(GlobalSearchObjectKind.DATA_SET);
            boolean containsMaterial = objectKinds.contains(GlobalSearchObjectKind.MATERIAL);
            if (containsSample) {
                GlobalSearchCriteriaTranslator.buildShortSubquery(sqlBuilder, translationContext, globalSearchTextCriterion, TableMapper.SAMPLE);
            }
            if (containsExperiment) {
                if (containsSample) {
                    sqlBuilder.append("UNION ALL").append("\n");
                }
                GlobalSearchCriteriaTranslator.buildShortSubquery(sqlBuilder, translationContext, globalSearchTextCriterion, TableMapper.EXPERIMENT);
            }
            if (containsDataSet) {
                if (containsSample || containsExperiment) {
                    sqlBuilder.append("UNION ALL").append("\n");
                }
                GlobalSearchCriteriaTranslator.buildShortSubquery(sqlBuilder, translationContext, globalSearchTextCriterion, TableMapper.DATA_SET);
            }
            if (containsMaterial) {
                if (containsSample || containsExperiment || containsDataSet) {
                    sqlBuilder.append("UNION ALL").append("\n");
                }
                GlobalSearchCriteriaTranslator.buildShortSubquery(sqlBuilder, translationContext, globalSearchTextCriterion, TableMapper.MATERIAL);
            }
        }
    }

    private static void buildShortSubquery(StringBuilder sqlBuilder, TranslationContext translationContext, GlobalSearchTextCriteria globalSearchTextCriterion, TableMapper tableMapper) {
        GlobalSearchCriteriaTranslator.buildShortSelect(sqlBuilder, translationContext, globalSearchTextCriterion, tableMapper, true);
        GlobalSearchCriteriaTranslator.buildShortFrom(sqlBuilder, tableMapper, true);
        GlobalSearchCriteriaTranslator.buildShortWhere(sqlBuilder, translationContext, globalSearchTextCriterion, tableMapper, true);
        sqlBuilder.append("UNION ALL").append("\n");
        GlobalSearchCriteriaTranslator.buildShortSelect(sqlBuilder, translationContext, globalSearchTextCriterion, tableMapper, false);
        GlobalSearchCriteriaTranslator.buildShortFrom(sqlBuilder, tableMapper, false);
        GlobalSearchCriteriaTranslator.buildShortWhere(sqlBuilder, translationContext, globalSearchTextCriterion, tableMapper, false);
    }

    private static void translateDetailsCriterion(StringBuilder sqlBuilder, TranslationContext translationContext, ISearchCriteria criterion, Map<GlobalSearchObjectKind, Set<Long>> idSetByObjectKindMap) {
        Set<GlobalSearchObjectKind> objectKinds = translationContext.getObjectKinds();
        if (criterion instanceof GlobalSearchTextCriteria && objectKinds != null && !objectKinds.isEmpty()) {
            boolean containsMaterial;
            GlobalSearchTextCriteria globalSearchTextCriterion = (GlobalSearchTextCriteria)criterion;
            Set<Long> sampleIdSet = idSetByObjectKindMap.get(GlobalSearchObjectKind.SAMPLE);
            Set<Long> experimentIdSet = idSetByObjectKindMap.get(GlobalSearchObjectKind.EXPERIMENT);
            Set<Long> dataSetIdSet = idSetByObjectKindMap.get(GlobalSearchObjectKind.DATA_SET);
            Set<Long> materialIdSet = idSetByObjectKindMap.get(GlobalSearchObjectKind.MATERIAL);
            boolean containsSample = sampleIdSet != null;
            boolean containsExperiment = experimentIdSet != null;
            boolean containsDataSet = dataSetIdSet != null;
            boolean bl = containsMaterial = materialIdSet != null;
            if (containsSample) {
                GlobalSearchCriteriaTranslator.buildDetailsSubquery(sqlBuilder, translationContext, globalSearchTextCriterion, TableMapper.SAMPLE, sampleIdSet);
            }
            if (containsExperiment) {
                if (containsSample) {
                    sqlBuilder.append("UNION ALL").append("\n");
                }
                GlobalSearchCriteriaTranslator.buildDetailsSubquery(sqlBuilder, translationContext, globalSearchTextCriterion, TableMapper.EXPERIMENT, experimentIdSet);
            }
            if (containsDataSet) {
                if (containsSample || containsExperiment) {
                    sqlBuilder.append("UNION ALL").append("\n");
                }
                GlobalSearchCriteriaTranslator.buildDetailsSubquery(sqlBuilder, translationContext, globalSearchTextCriterion, TableMapper.DATA_SET, dataSetIdSet);
            }
            if (containsMaterial) {
                if (containsSample || containsExperiment || containsDataSet) {
                    sqlBuilder.append("UNION ALL").append("\n");
                }
                GlobalSearchCriteriaTranslator.buildDetailsSubquery(sqlBuilder, translationContext, globalSearchTextCriterion, TableMapper.MATERIAL, materialIdSet);
            }
        }
    }

    private static void buildDetailsSubquery(StringBuilder sqlBuilder, TranslationContext translationContext, GlobalSearchTextCriteria globalSearchTextCriterion, TableMapper tableMapper, Collection<Long> resultIds) {
        GlobalSearchCriteriaTranslator.buildDetailsSelect(sqlBuilder, translationContext, globalSearchTextCriterion, tableMapper, true);
        GlobalSearchCriteriaTranslator.buildDetailsFrom(sqlBuilder, tableMapper, true);
        GlobalSearchCriteriaTranslator.buildDetailsWhere(sqlBuilder, translationContext, globalSearchTextCriterion, resultIds, tableMapper, true);
        if (globalSearchTextCriterion.getFieldValue() instanceof StringMatchesValue || globalSearchTextCriterion.getFieldValue() instanceof StringStartsWithValue || globalSearchTextCriterion.getFieldValue() instanceof StringContainsExactlyValue || globalSearchTextCriterion.getFieldValue() instanceof StringContainsValue) {
            sqlBuilder.append("UNION ALL").append("\n");
            GlobalSearchCriteriaTranslator.buildDetailsSelect(sqlBuilder, translationContext, globalSearchTextCriterion, tableMapper, false);
            GlobalSearchCriteriaTranslator.buildDetailsFrom(sqlBuilder, tableMapper, false);
            GlobalSearchCriteriaTranslator.buildDetailsWhere(sqlBuilder, translationContext, globalSearchTextCriterion, resultIds, tableMapper, false);
        }
    }

    private static void buildShortSelect(StringBuilder sqlBuilder, TranslationContext translationContext, GlobalSearchTextCriteria criterion, TableMapper tableMapper, boolean forAttributes) {
        AbstractStringValue stringValue = (AbstractStringValue)criterion.getFieldValue();
        List<Object> args = translationContext.getArgs();
        boolean hasSpaces = GlobalSearchCriteriaTranslator.hasSpaces(tableMapper);
        boolean hasProjects = GlobalSearchCriteriaTranslator.hasProjects(tableMapper);
        boolean hasExperiments = GlobalSearchCriteriaTranslator.hasExperiments(tableMapper);
        String prefix = SearchCriteriaTranslator.MAIN_TABLE_ALIAS + ".";
        sqlBuilder.append("SELECT").append(" ");
        sqlBuilder.append(prefix).append("id").append(",").append(" ");
        GlobalSearchCriteriaTranslator.buildSelectIdentifier(sqlBuilder, tableMapper, hasSpaces, hasProjects, ENTITY_TYPES_TABLE_ALIAS, SPACE_TABLE_ALIAS, PROJECT_TABLE_ALIAS);
        sqlBuilder.append(",").append(" ");
        if (hasProjects) {
            sqlBuilder.append(prefix).append("proj_id");
        } else {
            sqlBuilder.append("NULL").append(" ").append("proj_id");
        }
        sqlBuilder.append(",").append(" ");
        if (hasSpaces) {
            sqlBuilder.append(prefix).append("space_id");
        } else {
            sqlBuilder.append("NULL").append(" ").append("space_id");
        }
        sqlBuilder.append(",").append(" ");
        if (hasExperiments) {
            sqlBuilder.append(prefix).append("expe_id");
        } else {
            sqlBuilder.append("NULL").append(" ").append("expe_id");
        }
        sqlBuilder.append(",").append(" ");
        int objectKindOrdinal = GlobalSearchObjectKind.valueOf((String)tableMapper.toString()).ordinal();
        if (forAttributes) {
            sqlBuilder.append(prefix).append(GlobalSearchCriteriaTranslator.getPermId(tableMapper)).append(" ").append("perm_id").append(",").append(" ").append(objectKindOrdinal).append(" ").append(OBJECT_KIND_ORDINAL_ALIAS).append(",").append(" ");
        } else {
            sqlBuilder.append(prefix).append(GlobalSearchCriteriaTranslator.getPermId(tableMapper)).append(",").append(" ").append(objectKindOrdinal).append(" ").append(OBJECT_KIND_ORDINAL_ALIAS).append(",").append(" ");
        }
        GlobalSearchCriteriaTranslator.appendRankCalculation(sqlBuilder, tableMapper, forAttributes, stringValue, args, SearchCriteriaTranslator.MAIN_TABLE_ALIAS, PROPERTIES_TABLE_ALIAS, MATERIALS_TABLE_ALIAS, SAMPLES_TABLE_ALIAS);
        sqlBuilder.append(" ").append(RANK_ALIAS).append("\n");
    }

    public static void appendRankCalculation(StringBuilder sqlBuilder, TableMapper tableMapper, boolean forAttributes, AbstractStringValue stringValue, List<Object> args, String mainTableAlias, String propertiesTableAlias, String materialsTableAlias, String samplesTableAlias) {
        if (forAttributes) {
            GlobalSearchCriteriaTranslator.buildTsRank(sqlBuilder, mainTableAlias, () -> GlobalSearchCriteriaTranslator.buildCastingTsQueryPart(sqlBuilder, stringValue, args));
        } else {
            GlobalSearchCriteriaTranslator.buildTsRank(sqlBuilder, propertiesTableAlias, () -> GlobalSearchCriteriaTranslator.buildTsQueryPart(sqlBuilder, stringValue, args));
            sqlBuilder.append(" ").append("+").append(" ");
            sqlBuilder.append("COALESCE").append("(");
            GlobalSearchCriteriaTranslator.buildTsRank(sqlBuilder, materialsTableAlias, () -> GlobalSearchCriteriaTranslator.buildCastingTsQueryPart(sqlBuilder, stringValue, args));
            sqlBuilder.append(",").append(" ").append(0).append(")");
            if (tableMapper == TableMapper.SAMPLE || tableMapper == TableMapper.EXPERIMENT || tableMapper == TableMapper.DATA_SET) {
                sqlBuilder.append(" ").append("+").append(" ");
                sqlBuilder.append("COALESCE").append("(");
                GlobalSearchCriteriaTranslator.buildTsRank(sqlBuilder, samplesTableAlias, () -> GlobalSearchCriteriaTranslator.buildCastingTsQueryPart(sqlBuilder, stringValue, args));
                sqlBuilder.append(",").append(" ").append(0).append(")");
            }
        }
    }

    private static void buildTsRank(StringBuilder sqlBuilder, String tsVectorReference, Runnable tsQueryBuilder) {
        sqlBuilder.append("ts_rank").append("(").append("ARRAY").append("[").append("'").append(0.001).append("'").append(",").append(" ").append("'").append(0.01).append("'").append(",").append(" ").append("'").append(0.1).append("'").append(",").append(" ").append("'").append(1.0).append("'").append("]").append("::").append((Object)PSQLTypes.FLOAT4).append("[").append("]").append(",").append(" ").append(tsVectorReference).append(".").append("tsvector_document").append(",").append(" ");
        tsQueryBuilder.run();
        sqlBuilder.append(")");
    }

    private static void buildShortFrom(StringBuilder sqlBuilder, TableMapper tableMapper, boolean forAttributes) {
        String entitiesTable = tableMapper.getEntitiesTable();
        sqlBuilder.append("FROM").append(" ").append(entitiesTable).append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append("\n");
        if (!forAttributes) {
            sqlBuilder.append("INNER JOIN").append(" ").append(tableMapper.getValuesTable()).append(" ").append(PROPERTIES_TABLE_ALIAS).append(" ").append("ON").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("id").append(" ").append("=").append(" ").append(PROPERTIES_TABLE_ALIAS).append(".").append(tableMapper.getValuesTableEntityIdField()).append("\n");
            sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.MATERIAL.getEntitiesTable()).append(" ").append(MATERIALS_TABLE_ALIAS).append(" ").append("ON").append(" ").append(PROPERTIES_TABLE_ALIAS).append(".").append("mate_prop_id").append(" ").append("=").append(" ").append(MATERIALS_TABLE_ALIAS).append(".").append("id").append("\n");
            if (tableMapper == TableMapper.SAMPLE || tableMapper == TableMapper.EXPERIMENT || tableMapper == TableMapper.DATA_SET) {
                sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.SAMPLE.getEntitiesTable()).append(" ").append(SAMPLES_TABLE_ALIAS).append(" ").append("ON").append(" ").append(PROPERTIES_TABLE_ALIAS).append(".").append("samp_prop_id").append(" ").append("=").append(" ").append(SAMPLES_TABLE_ALIAS).append(".").append("id").append("\n");
            }
        }
        if (tableMapper == TableMapper.EXPERIMENT) {
            GlobalSearchCriteriaTranslator.buildProjectAndSpacesJoin(sqlBuilder, tableMapper);
        }
        if (tableMapper == TableMapper.MATERIAL) {
            GlobalSearchCriteriaTranslator.buildEntityTypesJoin(sqlBuilder, tableMapper);
        }
    }

    private static void buildShortWhere(StringBuilder sqlBuilder, TranslationContext translationContext, GlobalSearchTextCriteria criterion, TableMapper tableMapper, boolean forAttributes) {
        List<Object> args = translationContext.getArgs();
        sqlBuilder.append("WHERE").append(" ").append("(");
        AbstractStringValue stringValue = (AbstractStringValue)criterion.getFieldValue();
        if (forAttributes) {
            String tsQuerySuffix = StringStartsWithValue.class.isAssignableFrom(stringValue.getClass()) ? PREFIX_MATCH_SUFFIX : "";
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("tsvector_document").append(" ").append("@@").append(" ").append("(").append('?').append(tsQuerySuffix).append(")").append("::").append("tsquery");
            String tsQueryText = GlobalSearchCriteriaTranslator.toTsQueryText(stringValue);
            args.add(tsQueryText);
        } else {
            GlobalSearchCriteriaTranslator.buildTsVectorMatch(sqlBuilder, stringValue, tableMapper, args);
        }
        sqlBuilder.append(")");
        GlobalSearchCriteriaTranslator.translateAuthorisation(sqlBuilder, translationContext, tableMapper);
        sqlBuilder.append("\n");
    }

    private static void buildDetailsSelect(StringBuilder sqlBuilder, TranslationContext translationContext, GlobalSearchTextCriteria criterion, TableMapper tableMapper, boolean forAttributes) {
        String[] stringArray;
        AbstractStringValue stringValue = (AbstractStringValue)criterion.getFieldValue();
        List<Object> args = translationContext.getArgs();
        int objectKindOrdinal = GlobalSearchObjectKind.valueOf((String)tableMapper.toString()).ordinal();
        boolean hasSpaces = GlobalSearchCriteriaTranslator.hasSpaces(tableMapper);
        boolean hasProjects = GlobalSearchCriteriaTranslator.hasProjects(tableMapper);
        sqlBuilder.append("SELECT").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("id").append(",").append("\n");
        switch (tableMapper) {
            case SAMPLE: 
            case EXPERIMENT: {
                sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("perm_id");
                break;
            }
            default: {
                sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("code").append(" ").append("perm_id");
            }
        }
        sqlBuilder.append(",").append("\n");
        sqlBuilder.append(ENTITY_TYPES_TABLE_ALIAS).append(".").append("code").append(" ").append(ENTITY_TYPES_CODE_ALIAS).append(",").append("\n");
        sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("code").append(",").append("\n");
        sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("pers_id_registerer").append(",").append("\n");
        sqlBuilder.append(objectKindOrdinal).append(" ").append(OBJECT_KIND_ORDINAL_ALIAS).append(",").append("\n");
        GlobalSearchCriteriaTranslator.buildSelectIdentifier(sqlBuilder, tableMapper, hasSpaces, hasProjects, ENTITY_TYPES_TABLE_ALIAS, SPACE_TABLE_ALIAS, PROJECT_TABLE_ALIAS);
        sqlBuilder.append(",").append("\n");
        if (hasSpaces || hasProjects) {
            sqlBuilder.append(SPACE_TABLE_ALIAS).append(".").append("code");
        } else if (tableMapper == TableMapper.DATA_SET) {
            sqlBuilder.append(LINKED_SPACE_TABLE_ALIAS).append(".").append("code");
        } else {
            sqlBuilder.append("NULL");
        }
        sqlBuilder.append(" ").append(SPACE_CODE_ALIAS).append(",").append("\n");
        if (stringValue instanceof StringMatchesValue) {
            stringArray = ((String)stringValue.getValue()).toLowerCase().trim().split("\\s+");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ((String)stringValue.getValue()).toLowerCase();
        }
        String[] criterionValues = stringArray;
        if (forAttributes) {
            boolean withWildcards = translationContext.getCriteria().stream().anyMatch(searchCriterion -> searchCriterion instanceof GlobalSearchWildCardsCriteria);
            Class<?> stringValueClass = stringValue.getClass();
            GlobalSearchCriteriaTranslator.buildCodeMatch(sqlBuilder, criterionValues, stringValueClass, tableMapper, withWildcards, args);
            GlobalSearchCriteriaTranslator.buildPermIdMatch(sqlBuilder, stringValueClass, criterionValues, tableMapper, withWildcards, args);
            sqlBuilder.append(",").append("\n");
            if (tableMapper == TableMapper.SAMPLE) {
                String sampleIdentifierColumnReference = SearchCriteriaTranslator.MAIN_TABLE_ALIAS + "." + "sample_identifier";
                GlobalSearchCriteriaTranslator.buildCaseWhen(sqlBuilder, new String[]{GlobalSearchCriteriaTranslator.makeCondition(sampleIdentifierColumnReference, args, criterionValues, stringValueClass, withWildcards)}, new String[]{sampleIdentifierColumnReference}, "NULL");
            } else {
                sqlBuilder.append("NULL");
            }
            sqlBuilder.append(" ").append(SAMPLE_IDENTIFIER_MATCH_ALIAS).append(",").append("\n");
            String entityTypeColumnReference = "enty.code";
            GlobalSearchCriteriaTranslator.buildCaseWhen(sqlBuilder, new String[]{GlobalSearchCriteriaTranslator.makeCondition("enty.code", args, criterionValues, stringValueClass, withWildcards)}, new String[]{"enty.code"}, "NULL");
            sqlBuilder.append(" ").append(ENTITY_TYPE_MATCH_ALIAS).append(",").append("\n");
            if (tableMapper == TableMapper.SAMPLE || tableMapper == TableMapper.EXPERIMENT) {
                String projectColumnReference = "proj.code";
                GlobalSearchCriteriaTranslator.buildCaseWhen(sqlBuilder, new String[]{GlobalSearchCriteriaTranslator.makeCondition("proj.code", args, criterionValues, stringValueClass, withWildcards)}, new String[]{"proj.code"}, "NULL");
            } else {
                sqlBuilder.append("NULL");
            }
            sqlBuilder.append(" ").append(PROJECT_MATCH_ALIAS).append(",").append("\n");
            if (tableMapper == TableMapper.SAMPLE || tableMapper == TableMapper.EXPERIMENT) {
                String spaceColumnReference = "space.code";
                GlobalSearchCriteriaTranslator.buildCaseWhen(sqlBuilder, new String[]{GlobalSearchCriteriaTranslator.makeCondition("space.code", args, criterionValues, stringValueClass, withWildcards)}, new String[]{"space.code"}, "NULL");
            } else {
                sqlBuilder.append("NULL");
            }
            sqlBuilder.append(" ").append(SPACE_MATCH_ALIAS).append(",").append("\n");
            sqlBuilder.append("NULL").append(" ").append(MATERIAL_MATCH_ALIAS).append(",").append("\n");
            sqlBuilder.append("NULL").append(" ").append(SAMPLE_MATCH_ALIAS).append(",").append("\n");
            sqlBuilder.append("NULL").append(" ").append(PROPERTY_TYPE_LABEL_ALIAS).append(",").append("\n");
            sqlBuilder.append("NULL").append(" ").append(PROPERTY_VALUE_ALIAS).append(",").append("\n");
            sqlBuilder.append("NULL").append(" ").append(CV_CODE_ALIAS).append(",").append("\n");
            sqlBuilder.append("NULL").append(" ").append(CV_LABEL_ALIAS).append(",").append("\n");
            sqlBuilder.append("NULL").append(" ").append(VALUE_HEADLINE_ALIAS).append(",").append("\n");
            sqlBuilder.append("NULL").append(" ").append(CODE_HEADLINE_ALIAS).append(",").append("\n");
            sqlBuilder.append("NULL").append(" ").append(LABEL_HEADLINE_ALIAS);
        } else {
            sqlBuilder.append("NULL").append(" ").append(CODE_MATCH_ALIAS).append(",").append("\n");
            sqlBuilder.append("NULL").append(" ").append(PERM_ID_MATCH_ALIAS).append(",").append("\n");
            sqlBuilder.append("NULL").append(" ").append(SAMPLE_IDENTIFIER_MATCH_ALIAS).append(",").append("\n");
            sqlBuilder.append("NULL").append(" ").append(ENTITY_TYPE_MATCH_ALIAS).append(",").append("\n");
            sqlBuilder.append("NULL").append(" ").append(PROJECT_MATCH_ALIAS).append(",").append("\n");
            sqlBuilder.append("NULL").append(" ").append(SPACE_MATCH_ALIAS).append(",").append("\n");
            GlobalSearchCriteriaTranslator.buildMaterialMatch(sqlBuilder, criterionValues, args);
            sqlBuilder.append(",").append("\n");
            if (tableMapper == TableMapper.SAMPLE || tableMapper == TableMapper.EXPERIMENT || tableMapper == TableMapper.DATA_SET) {
                GlobalSearchCriteriaTranslator.buildSampleMatch(sqlBuilder, criterionValues, args);
            } else {
                sqlBuilder.append("NULL").append(" ").append(SAMPLE_MATCH_ALIAS);
            }
            sqlBuilder.append(",").append("\n");
            sqlBuilder.append(ATTRIBUTE_TYPES_TABLE_ALIAS).append(".").append("label").append(" ").append(PROPERTY_TYPE_LABEL_ALIAS).append(",").append("\n");
            sqlBuilder.append(PROPERTIES_TABLE_ALIAS).append(".").append("value").append(" ").append(PROPERTY_VALUE_ALIAS).append(",").append("\n");
            sqlBuilder.append(CONTROLLED_VOCABULARY_TERMS_TABLE_ALIAS).append(".").append("code").append(" ").append(CV_CODE_ALIAS).append(",").append("\n");
            sqlBuilder.append(CONTROLLED_VOCABULARY_TERMS_TABLE_ALIAS).append(".").append("label").append(" ").append(CV_LABEL_ALIAS).append(",").append("\n");
            boolean useHeadline = translationContext.getFetchOptions().hasMatch();
            GlobalSearchCriteriaTranslator.buildTsHeadline(sqlBuilder, stringValue, args, "prop.value", VALUE_HEADLINE_ALIAS, useHeadline);
            sqlBuilder.append(",").append("\n");
            GlobalSearchCriteriaTranslator.buildTsHeadline(sqlBuilder, stringValue, args, "cvte.code", CODE_HEADLINE_ALIAS, useHeadline);
            sqlBuilder.append(",").append("\n");
            GlobalSearchCriteriaTranslator.buildTsHeadline(sqlBuilder, stringValue, args, "cvte.label", LABEL_HEADLINE_ALIAS, useHeadline);
        }
        sqlBuilder.append("\n");
    }

    private static void buildSelectIdentifier(StringBuilder sqlBuilder, TableMapper tableMapper, boolean hasSpaces, boolean hasProjects, String entityTypesTableAlias, String spaceTableAlias, String projectTableAlias) {
        switch (tableMapper) {
            case MATERIAL: {
                TranslatorUtils.buildTypeCodeIdentifierConcatenationString(sqlBuilder, entityTypesTableAlias);
                break;
            }
            case SAMPLE: {
                sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("sample_identifier");
                break;
            }
            default: {
                TranslatorUtils.buildFullIdentifierConcatenationString(sqlBuilder, hasSpaces || hasProjects ? spaceTableAlias : null, hasProjects ? projectTableAlias : null, null, false);
            }
        }
        sqlBuilder.append(" ").append(IDENTIFIER_ALIAS);
    }

    private static void addCoalesceOfValues(StringBuilder sqlBuilder, TableMapper tableMapper) {
        sqlBuilder.append("COALESCE").append("(");
        sqlBuilder.append(PROPERTIES_TABLE_ALIAS).append(".").append("value").append(",").append(" ");
        sqlBuilder.append(CONTROLLED_VOCABULARY_TERMS_TABLE_ALIAS).append(".").append("code").append(",").append(" ");
        sqlBuilder.append(CONTROLLED_VOCABULARY_TERMS_TABLE_ALIAS).append(".").append("label");
        if (tableMapper == TableMapper.SAMPLE || tableMapper == TableMapper.EXPERIMENT || tableMapper == TableMapper.DATA_SET) {
            sqlBuilder.append(",").append(" ");
            sqlBuilder.append(SAMPLES_TABLE_ALIAS).append(".").append("sample_identifier").append(",").append(" ");
            sqlBuilder.append(MATERIALS_TABLE_ALIAS).append(".").append("code");
        }
        sqlBuilder.append(")");
    }

    private static void buildSampleMatch(StringBuilder sqlBuilder, String[] values, List<Object> args) {
        sqlBuilder.append("CASE").append("\n");
        GlobalSearchCriteriaTranslator.appendWhenThen(sqlBuilder, SAMPLES_TABLE_ALIAS, "perm_id", values, args);
        GlobalSearchCriteriaTranslator.appendWhenThen(sqlBuilder, SAMPLES_TABLE_ALIAS, "code", values, args);
        GlobalSearchCriteriaTranslator.appendWhenThen(sqlBuilder, SAMPLES_TABLE_ALIAS, "sample_identifier", values, args);
        sqlBuilder.append('\t').append("ELSE").append(" ").append("NULL").append("\n");
        sqlBuilder.append("END").append(" ").append(SAMPLE_MATCH_ALIAS);
    }

    private static void buildMaterialMatch(StringBuilder sqlBuilder, String[] values, List<Object> args) {
        sqlBuilder.append("CASE").append("\n");
        GlobalSearchCriteriaTranslator.appendWhenThen(sqlBuilder, MATERIALS_TABLE_ALIAS, "code", values, args);
        sqlBuilder.append('\t').append("ELSE").append(" ").append("NULL").append("\n");
        sqlBuilder.append("END").append(" ").append(MATERIAL_MATCH_ALIAS);
    }

    private static void appendWhenThen(StringBuilder sqlBuilder, String tableAlias, String column, String[] values, List<Object> args) {
        sqlBuilder.append('\t').append("WHEN").append(" ").append("LOWER").append("(").append(tableAlias).append(".").append(column).append(")").append(" ").append("IN").append(" ").append("(SELECT UNNEST(?))").append(" ").append("THEN").append(" ").append(tableAlias).append(".").append(column).append("\n");
        args.add(values);
    }

    private static void buildTsHeadline(StringBuilder sqlBuilder, AbstractStringValue stringValue, List<Object> args, String field, String alias, boolean useHeadline) {
        if (useHeadline && (stringValue instanceof StringMatchesValue || stringValue instanceof StringStartsWithValue)) {
            sqlBuilder.append("ts_headline").append("(").append(field).append(",").append(" ");
            GlobalSearchCriteriaTranslator.buildTsQueryPart(sqlBuilder, stringValue, args);
            sqlBuilder.append(",").append(" ").append("'").append(TS_HEADLINE_OPTIONS).append("'");
            sqlBuilder.append(")");
        } else {
            sqlBuilder.append("NULL");
        }
        sqlBuilder.append(" ").append(alias);
    }

    private static void buildPropertiesMatchCondition(StringBuilder sqlBuilder, GlobalSearchTextCriteria criterion, TableMapper tableMapper, boolean withWildcards, List<Object> args) {
        AbstractStringValue stringValue = (AbstractStringValue)criterion.getFieldValue();
        GlobalSearchCriteriaTranslator.addCoalesceOfValues(sqlBuilder, tableMapper);
        TranslatorUtils.appendStringComparatorOp(stringValue, withWildcards, sqlBuilder, args);
    }

    private static void buildAttributesMatchCondition(StringBuilder sqlBuilder, GlobalSearchTextCriteria criterion, List<Object> args) {
        AbstractStringValue stringValue = (AbstractStringValue)criterion.getFieldValue();
        String tsQuerySuffix = stringValue instanceof StringStartsWithValue ? PREFIX_MATCH_SUFFIX : "";
        sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("tsvector_document").append(" ").append("@@").append(" ").append("(").append('?').append(tsQuerySuffix).append(")").append("::").append("tsquery");
        args.add(GlobalSearchCriteriaTranslator.toTsQueryText(stringValue));
    }

    private static void buildPermIdMatch(StringBuilder sqlBuilder, Class<? extends AbstractStringValue> stringValueClass, String[] criterionValues, TableMapper tableMapper, boolean withWildcards, List<Object> args) {
        switch (tableMapper) {
            case SAMPLE: 
            case EXPERIMENT: {
                String samplePermIdColumnReference = SearchCriteriaTranslator.MAIN_TABLE_ALIAS + "." + "perm_id";
                GlobalSearchCriteriaTranslator.buildCaseWhen(sqlBuilder, new String[]{GlobalSearchCriteriaTranslator.makeCondition(samplePermIdColumnReference, args, criterionValues, stringValueClass, withWildcards)}, new String[]{samplePermIdColumnReference}, "NULL");
                break;
            }
            default: {
                sqlBuilder.append("NULL");
            }
        }
        sqlBuilder.append(" ").append(PERM_ID_MATCH_ALIAS);
    }

    private static void buildCodeMatch(StringBuilder sqlBuilder, String[] criterionValues, Class<? extends AbstractStringValue> stringValueClass, TableMapper tableMapper, boolean withWildcards, List<Object> args) {
        String mainTableCode = SearchCriteriaTranslator.MAIN_TABLE_ALIAS + "." + "code";
        if (tableMapper == TableMapper.SAMPLE) {
            StringBuilder thenValueBuilder = new StringBuilder();
            String[] modifiedCriterionValues = StringContainsExactlyValue.class.isAssignableFrom(stringValueClass) ? criterionValues : Arrays.stream(criterionValues).flatMap(value -> {
                String[] splitValues = value.split(":", 2);
                return splitValues.length > 1 ? Stream.of(value, splitValues[0], splitValues[1]) : Stream.of(value);
            }).collect(Collectors.toList()).toArray(new String[0]);
            GlobalSearchCriteriaTranslator.buildCaseWhen(thenValueBuilder, new String[]{GlobalSearchCriteriaTranslator.makeCondition(mainTableCode, args, modifiedCriterionValues, stringValueClass, withWildcards)}, new String[]{mainTableCode}, "NULL");
            StringBuilder elseValueBuilder = new StringBuilder();
            String[] conditionValues = new String[]{GlobalSearchCriteriaTranslator.createSubstrCall(Character.valueOf('/'), null), mainTableCode, GlobalSearchCriteriaTranslator.createSubstrCall(Character.valueOf('/'), Character.valueOf(':'))};
            GlobalSearchCriteriaTranslator.buildCaseWhen(elseValueBuilder, new String[]{GlobalSearchCriteriaTranslator.makeCondition(conditionValues[0], args, modifiedCriterionValues, stringValueClass, withWildcards), GlobalSearchCriteriaTranslator.makeCondition(conditionValues[1], args, modifiedCriterionValues, stringValueClass, withWildcards), GlobalSearchCriteriaTranslator.makeCondition(conditionValues[2], args, modifiedCriterionValues, stringValueClass, withWildcards)}, conditionValues, "NULL");
            GlobalSearchCriteriaTranslator.buildCaseWhen(sqlBuilder, new String[]{SearchCriteriaTranslator.MAIN_TABLE_ALIAS + "." + "samp_id_part_of" + " " + "IS" + " " + "NULL"}, new String[]{thenValueBuilder.toString()}, elseValueBuilder.toString());
        } else {
            GlobalSearchCriteriaTranslator.buildCaseWhen(sqlBuilder, new String[]{GlobalSearchCriteriaTranslator.makeCondition(mainTableCode, args, criterionValues, stringValueClass, withWildcards)}, new String[]{mainTableCode}, "NULL");
        }
        sqlBuilder.append(" ").append(CODE_MATCH_ALIAS).append(",").append("\n");
    }

    private static String makeCondition(String matchingColumn, List<Object> args, String[] criterionValues, Class<? extends AbstractStringValue> stringValueClass, boolean withWildcards) {
        StringBuilder result = new StringBuilder();
        GlobalSearchCriteriaTranslator.appendFullCondition(result, matchingColumn, args, criterionValues, stringValueClass, withWildcards);
        return result.toString();
    }

    private static String createSubstrCall(Character char1, Character char2) {
        String mainTableSampleIdentifier = SearchCriteriaTranslator.MAIN_TABLE_ALIAS + "." + "sample_identifier";
        String result = "substr(" + mainTableSampleIdentifier + "," + " " + "length" + "(" + mainTableSampleIdentifier + ")" + " " + "-" + " " + GlobalSearchCriteriaTranslator.createStrposReverseCall(char1.charValue()) + " " + "+" + " " + "2";
        return char2 == null ? result + ")" : result + "," + " " + GlobalSearchCriteriaTranslator.createStrposReverseCall(char1.charValue()) + " " + "-" + " " + GlobalSearchCriteriaTranslator.createStrposReverseCall(char2.charValue()) + " " + "-" + " " + "1" + ")";
    }

    private static String createStrposReverseCall(char ch) {
        return "strpos(reverse(" + SearchCriteriaTranslator.MAIN_TABLE_ALIAS + "." + "sample_identifier" + ")" + "," + " " + "'" + ch + "'" + ")";
    }

    private static void buildCaseWhen(StringBuilder sqlBuilder, String[] conditions, String[] thenValues, String elseValue) {
        sqlBuilder.append("CASE").append("\n");
        for (int i = 0; i < conditions.length; ++i) {
            sqlBuilder.append(" ").append(" ").append("WHEN").append(" ").append(conditions[i]);
            sqlBuilder.append(" ").append("THEN").append(" ").append(thenValues[i]).append("\n");
        }
        sqlBuilder.append(" ").append(" ").append("ELSE").append(" ").append(elseValue).append(" ").append("END");
    }

    private static void buildWhenIn(StringBuilder sqlBuilder, List<Object> args, String[] criterionValues, String[] matchingColumns) {
        sqlBuilder.append("WHEN").append(" ");
        Spliterator<String> spliterator = Arrays.stream(matchingColumns).spliterator();
        if (spliterator.tryAdvance(matchingColumn -> GlobalSearchCriteriaTranslator.appendInCondition(sqlBuilder, matchingColumn, args, criterionValues))) {
            spliterator.forEachRemaining(matchingColumn -> {
                sqlBuilder.append(" ").append("OR").append(" ");
                GlobalSearchCriteriaTranslator.appendInCondition(sqlBuilder, matchingColumn, args, criterionValues);
            });
        }
    }

    private static void appendInCondition(StringBuilder sqlBuilder, String matchingColumn, List<Object> args, String[] criterionValues) {
        sqlBuilder.append("LOWER").append(" ").append("(").append(matchingColumn).append(")");
        sqlBuilder.append(" ").append("IN").append(" ").append("(").append("SELECT").append(" ").append("UNNEST").append("(").append('?').append(")").append(")");
        args.add(criterionValues);
    }

    private static void appendFullCondition(StringBuilder sqlBuilder, String matchingColumn, List<Object> args, String[] criterionValues, Class<? extends AbstractStringValue> stringValueClass, boolean withWildcards) {
        Spliterator<String> spliterator = Arrays.stream(criterionValues).spliterator();
        if (spliterator.tryAdvance(criterionValue -> GlobalSearchCriteriaTranslator.appendSingleCondition(sqlBuilder, matchingColumn, args, criterionValue, stringValueClass, withWildcards))) {
            spliterator.forEachRemaining(criterionValue -> {
                sqlBuilder.append(" ").append("OR").append(" ");
                GlobalSearchCriteriaTranslator.appendSingleCondition(sqlBuilder, matchingColumn, args, criterionValue, stringValueClass, withWildcards);
            });
        }
    }

    private static void appendSingleCondition(StringBuilder sqlBuilder, String matchingColumn, List<Object> args, String criterionValue, Class<? extends AbstractStringValue> stringValueClass, boolean withWildcards) {
        if (StringContainsExactlyValue.class.isAssignableFrom(stringValueClass) || StringContainsValue.class.isAssignableFrom(stringValueClass)) {
            sqlBuilder.append(matchingColumn);
            TranslatorUtils.appendStringComparatorOp(stringValueClass, criterionValue, withWildcards, sqlBuilder, args);
        } else {
            sqlBuilder.append("to_tsvector").append("(").append(matchingColumn).append(")");
            sqlBuilder.append(" ").append("@@").append(" ").append("to_tsquery").append("(");
            sqlBuilder.append("'").append(REG_CONFIG).append("'").append(",").append(" ");
            sqlBuilder.append('?');
            if (StringStartsWithValue.class.isAssignableFrom(stringValueClass)) {
                sqlBuilder.append(PREFIX_MATCH_SUFFIX);
            }
            sqlBuilder.append(")");
            args.add(GlobalSearchCriteriaTranslator.toTsQueryText(criterionValue, stringValueClass));
        }
    }

    private static void buildDetailsFrom(StringBuilder sqlBuilder, TableMapper tableMapper, boolean forAttributes) {
        String entitiesTable = tableMapper.getEntitiesTable();
        sqlBuilder.append("FROM").append(" ").append(entitiesTable).append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append("\n");
        if (!forAttributes) {
            sqlBuilder.append("LEFT JOIN").append(" ").append(tableMapper.getValuesTable()).append(" ").append(PROPERTIES_TABLE_ALIAS).append(" ").append("ON").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("id").append(" ").append("=").append(" ").append(PROPERTIES_TABLE_ALIAS).append(".").append(tableMapper.getValuesTableEntityIdField()).append("\n");
            sqlBuilder.append("LEFT JOIN").append(" ").append(tableMapper.getEntityTypesAttributeTypesTable()).append(" ").append(ENTITY_TYPES_ATTRIBUTE_TYPES_TABLE_ALIAS).append(" ").append("ON").append(" ").append(PROPERTIES_TABLE_ALIAS).append(".").append(tableMapper.getValuesTableEntityTypeAttributeTypeIdField()).append(" ").append("=").append(" ").append(ENTITY_TYPES_ATTRIBUTE_TYPES_TABLE_ALIAS).append(".").append("id").append("\n");
            sqlBuilder.append("LEFT JOIN").append(" ").append(tableMapper.getAttributeTypesTable()).append(" ").append(ATTRIBUTE_TYPES_TABLE_ALIAS).append(" ").append("ON").append(" ").append(ENTITY_TYPES_ATTRIBUTE_TYPES_TABLE_ALIAS).append(".").append(tableMapper.getEntityTypesAttributeTypesTableAttributeTypeIdField()).append(" ").append("=").append(" ").append(ATTRIBUTE_TYPES_TABLE_ALIAS).append(".").append("id").append("\n");
            sqlBuilder.append("LEFT JOIN").append(" ").append("data_types").append(" ").append(DATA_TYPES_TABLE_ALIAS).append(" ").append("ON").append(" ").append(ATTRIBUTE_TYPES_TABLE_ALIAS).append(".").append("daty_id").append(" ").append("=").append(" ").append(DATA_TYPES_TABLE_ALIAS).append(".").append("id").append("\n");
            sqlBuilder.append("LEFT JOIN").append(" ").append("controlled_vocabulary_terms").append(" ").append(CONTROLLED_VOCABULARY_TERMS_TABLE_ALIAS).append(" ").append("ON").append(" ").append(PROPERTIES_TABLE_ALIAS).append(".").append("cvte_id").append(" ").append("=").append(" ").append(CONTROLLED_VOCABULARY_TERMS_TABLE_ALIAS).append(".").append("id").append("\n");
            sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.MATERIAL.getEntitiesTable()).append(" ").append(MATERIALS_TABLE_ALIAS).append(" ").append("ON").append(" ").append(PROPERTIES_TABLE_ALIAS).append(".").append("mate_prop_id").append(" ").append("=").append(" ").append(MATERIALS_TABLE_ALIAS).append(".").append("id").append("\n");
            if (tableMapper == TableMapper.SAMPLE || tableMapper == TableMapper.EXPERIMENT || tableMapper == TableMapper.DATA_SET) {
                sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.SAMPLE.getEntitiesTable()).append(" ").append(SAMPLES_TABLE_ALIAS).append(" ").append("ON").append(" ").append(PROPERTIES_TABLE_ALIAS).append(".").append("samp_prop_id").append(" ").append("=").append(" ").append(SAMPLES_TABLE_ALIAS).append(".").append("id").append("\n");
            }
        }
        if (tableMapper == TableMapper.DATA_SET) {
            sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.SAMPLE.getEntitiesTable()).append(" ").append(LINKED_SAMPLES_TABLE_ALIAS).append(" ").append("ON").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("samp_id").append(" ").append("=").append(" ").append(LINKED_SAMPLES_TABLE_ALIAS).append(".").append("id").append("\n");
            sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.EXPERIMENT.getEntitiesTable()).append(" ").append(LINKED_EXPERIMENTS_TABLE_ALIAS).append(" ").append("ON").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("expe_id").append(" ").append("=").append(" ").append(LINKED_EXPERIMENTS_TABLE_ALIAS).append(".").append("id").append("\n");
            sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.PROJECT.getEntitiesTable()).append(" ").append(LINKED_PROJECTS_TABLE_ALIAS).append(" ").append("ON").append(" ").append(LINKED_EXPERIMENTS_TABLE_ALIAS).append(".").append("proj_id").append(" ").append("=").append(" ").append(LINKED_PROJECTS_TABLE_ALIAS).append(".").append("id").append("\n");
            sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.SPACE.getEntitiesTable()).append(" ").append(LINKED_SPACE_TABLE_ALIAS).append(" ").append("ON").append(" ").append(LINKED_SPACE_TABLE_ALIAS).append(".").append("id").append(" ").append("=").append(" ").append("COALESCE").append("(").append(LINKED_SAMPLES_TABLE_ALIAS).append(".").append("space_id").append(" ").append(",").append(" ").append(LINKED_PROJECTS_TABLE_ALIAS).append(".").append("space_id").append(")");
        }
        GlobalSearchCriteriaTranslator.buildProjectAndSpacesJoin(sqlBuilder, tableMapper);
        GlobalSearchCriteriaTranslator.buildEntityTypesJoin(sqlBuilder, tableMapper);
        if (tableMapper == TableMapper.SAMPLE) {
            sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.SAMPLE.getEntitiesTable()).append(" ").append(CONTAINER_TABLE_ALIAS).append(" ").append("ON").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("samp_id_part_of").append(" ").append("=").append(" ").append(CONTAINER_TABLE_ALIAS).append(".").append("id").append("\n");
        }
    }

    private static void buildEntityTypesJoin(StringBuilder sqlBuilder, TableMapper tableMapper) {
        sqlBuilder.append("LEFT JOIN").append(" ").append(tableMapper.getEntityTypesTable()).append(" ").append(ENTITY_TYPES_TABLE_ALIAS).append(" ").append("ON").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append(tableMapper.getEntitiesTableEntityTypeIdField()).append(" ").append("=").append(" ").append(ENTITY_TYPES_TABLE_ALIAS).append(".").append("id").append("\n");
    }

    private static void buildProjectAndSpacesJoin(StringBuilder sqlBuilder, TableMapper tableMapper) {
        boolean hasSpaces = GlobalSearchCriteriaTranslator.hasSpaces(tableMapper);
        if (GlobalSearchCriteriaTranslator.hasProjects(tableMapper)) {
            sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.PROJECT.getEntitiesTable()).append(" ").append(PROJECT_TABLE_ALIAS).append(" ").append("ON").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("proj_id").append(" ").append("=").append(" ").append(PROJECT_TABLE_ALIAS).append(".").append("id").append("\n");
            if (!hasSpaces) {
                sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.SPACE.getEntitiesTable()).append(" ").append(SPACE_TABLE_ALIAS).append(" ").append("ON").append(" ").append(PROJECT_TABLE_ALIAS).append(".").append("space_id").append(" ").append("=").append(" ").append(SPACE_TABLE_ALIAS).append(".").append("id").append("\n");
            }
        }
        if (hasSpaces) {
            sqlBuilder.append("LEFT JOIN").append(" ").append(TableMapper.SPACE.getEntitiesTable()).append(" ").append(SPACE_TABLE_ALIAS).append(" ").append("ON").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("space_id").append(" ").append("=").append(" ").append(SPACE_TABLE_ALIAS).append(".").append("id").append("\n");
        }
    }

    private static boolean hasProjects(TableMapper tableMapper) {
        String entitiesTable = tableMapper.getEntitiesTable();
        return TableMapper.SAMPLE.getEntitiesTable().equals(entitiesTable) || TableMapper.EXPERIMENT.getEntitiesTable().equals(entitiesTable);
    }

    private static boolean hasSpaces(TableMapper tableMapper) {
        String entitiesTable = tableMapper.getEntitiesTable();
        return TableMapper.SAMPLE.getEntitiesTable().equals(entitiesTable) || TableMapper.PROJECT.getEntitiesTable().equals(entitiesTable);
    }

    private static boolean hasExperiments(TableMapper tableMapper) {
        String entitiesTable = tableMapper.getEntitiesTable();
        return TableMapper.SAMPLE.getEntitiesTable().equals(entitiesTable) || TableMapper.DATA_SET.getEntitiesTable().equals(entitiesTable);
    }

    private static void buildDetailsWhere(StringBuilder sqlBuilder, TranslationContext translationContext, GlobalSearchTextCriteria criterion, Collection<Long> resultIds, TableMapper tableMapper, boolean forAttributes) {
        List<Object> args = translationContext.getArgs();
        sqlBuilder.append("WHERE").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("id").append(" ").append("IN").append(" ").append("(SELECT UNNEST(?))");
        args.add(resultIds.toArray(new Long[0]));
        AbstractStringValue fieldValue = (AbstractStringValue)criterion.getFieldValue();
        if (fieldValue instanceof StringMatchesValue || fieldValue instanceof StringStartsWithValue) {
            sqlBuilder.append(" ").append("AND").append(" ").append("(");
            if (forAttributes) {
                GlobalSearchCriteriaTranslator.buildAttributesMatchCondition(sqlBuilder, criterion, args);
            } else {
                GlobalSearchCriteriaTranslator.buildTsVectorMatch(sqlBuilder, fieldValue, tableMapper, args);
            }
            sqlBuilder.append(")");
        } else if (!forAttributes && (fieldValue instanceof StringContainsExactlyValue || fieldValue instanceof StringContainsValue)) {
            sqlBuilder.append(" ").append("AND").append(" ").append("(");
            boolean withWildcards = translationContext.getCriteria().stream().anyMatch(searchCriterion -> searchCriterion instanceof GlobalSearchWildCardsCriteria);
            GlobalSearchCriteriaTranslator.buildPropertiesMatchCondition(sqlBuilder, criterion, tableMapper, withWildcards, args);
            sqlBuilder.append(")");
        }
        sqlBuilder.append("\n");
    }

    private static String getPermId(TableMapper tableMapper) {
        return AttributesMapper.getColumnName("perm id", tableMapper.getEntitiesTable(), null);
    }

    private static void buildTsVectorMatch(StringBuilder sqlBuilder, AbstractStringValue stringValue, TableMapper tableMapper, List<Object> args) {
        sqlBuilder.append(PROPERTIES_TABLE_ALIAS).append(".").append("tsvector_document").append(" ").append("@@").append(" ");
        GlobalSearchCriteriaTranslator.buildTsQueryPart(sqlBuilder, stringValue, args);
        sqlBuilder.append(" ").append("OR").append(" ");
        String tsQuerySuffix = StringStartsWithValue.class.isAssignableFrom(stringValue.getClass()) ? PREFIX_MATCH_SUFFIX : "";
        sqlBuilder.append(MATERIALS_TABLE_ALIAS).append(".").append("tsvector_document").append(" ").append("@@").append(" ").append("(").append('?').append(tsQuerySuffix).append(")").append("::").append("tsquery");
        args.add(GlobalSearchCriteriaTranslator.toTsQueryText(stringValue));
        if (tableMapper == TableMapper.SAMPLE || tableMapper == TableMapper.EXPERIMENT || tableMapper == TableMapper.DATA_SET) {
            sqlBuilder.append(" ").append("OR").append(" ");
            sqlBuilder.append(SAMPLES_TABLE_ALIAS).append(".").append("tsvector_document").append(" ").append("@@").append("(").append(" ").append('?').append(tsQuerySuffix).append(")").append("::").append("tsquery");
            args.add(GlobalSearchCriteriaTranslator.toTsQueryText(stringValue));
        }
    }

    private static void buildTsQueryPart(StringBuilder sqlBuilder, AbstractStringValue stringValue, List<Object> args) {
        String tsQuerySuffix = StringStartsWithValue.class.isAssignableFrom(stringValue.getClass()) ? PREFIX_MATCH_SUFFIX : "";
        sqlBuilder.append("to_tsquery").append("(").append("'").append(REG_CONFIG).append("'").append(",").append(" ").append("(").append('?').append(tsQuerySuffix).append(")").append(")");
        args.add(GlobalSearchCriteriaTranslator.toTsQueryText(stringValue));
    }

    private static void buildCastingTsQueryPart(StringBuilder sqlBuilder, AbstractStringValue stringValue, List<Object> args) {
        String tsQuerySuffix = StringStartsWithValue.class.isAssignableFrom(stringValue.getClass()) ? PREFIX_MATCH_SUFFIX : "";
        sqlBuilder.append("(").append('?').append(tsQuerySuffix).append(")").append("::").append("tsquery");
        args.add(GlobalSearchCriteriaTranslator.toTsQueryText(stringValue));
    }

    public static String toTsQueryText(AbstractStringValue stringValue) {
        return GlobalSearchCriteriaTranslator.toTsQueryText((String)stringValue.getValue(), stringValue.getClass());
    }

    private static String toTsQueryText(String value, Class<? extends AbstractStringValue> stringValueClass) {
        String fullValue = value.toLowerCase().replaceAll("'", "''");
        String splitValues = StringContainsValue.class.isAssignableFrom(stringValueClass) || StringMatchesValue.class.isAssignableFrom(stringValueClass) ? " | " + value.toLowerCase().replaceAll("['&|:!()<>]", " ").trim().replaceAll("\\s+", " | ") : "";
        return '\'' + fullValue + '\'' + splitValues;
    }

    static {
        ALIAS_BY_FIELD_NAME.put("SCORE", RANK_ALIAS);
        ALIAS_BY_FIELD_NAME.put("OBJECT_KIND", OBJECT_KIND_ORDINAL_ALIAS);
        ALIAS_BY_FIELD_NAME.put("OBJECT_PERM_ID", "perm_id");
        ALIAS_BY_FIELD_NAME.put("OBJECT_IDENTIFIER", IDENTIFIER_ALIAS);
    }
}

