/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortParameter;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.Sorting;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringMatchesValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringStartsWithValue;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.AttributesMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.GlobalSearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SelectQuery;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.TranslatorUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class OrderTranslator {
    private static final String IDENTIFIER = "IDENTIFIER";
    private static final String UNIQUE_PREFIX = OrderTranslator.class.getName() + ":";
    private static final String QUERY_ALIAS = "q";
    private static final String VALUE_ALIAS = "value";

    public static SelectQuery translateToOrderQuery(TranslationContext translationContext) {
        SortOptions<?> sortOptions = translationContext.getSortOptions();
        if (sortOptions == null) {
            throw new IllegalArgumentException("Null sort options provided.");
        }
        if (sortOptions.getSortings().isEmpty()) {
            throw new IllegalArgumentException("No sortings in sort options provided.");
        }
        StringBuilder queryBuilder = new StringBuilder("SELECT ");
        OrderTranslator.appendSelect(queryBuilder, translationContext);
        OrderTranslator.appendFrom(queryBuilder, translationContext);
        OrderTranslator.appendWhere(queryBuilder, translationContext);
        OrderTranslator.appendOrderBy(queryBuilder, translationContext);
        return new SelectQuery(queryBuilder.toString(), translationContext.getArgs());
    }

    private static void appendSelect(StringBuilder queryBuilder, TranslationContext translationContext) {
        List sortings = translationContext.getSortOptions().getSortings();
        OrderTranslator.appendIdsCoalesce(queryBuilder, sortings.size());
        queryBuilder.append(" ").append("AS").append(" ").append("id").append("\n");
    }

    private static void appendFrom(StringBuilder queryBuilder, TranslationContext translationContext) {
        List sortings = translationContext.getSortOptions().getSortings();
        queryBuilder.append("FROM").append("\n").append("(");
        OrderTranslator.appendOrderSubquery(queryBuilder, translationContext, (Sorting)sortings.get(0));
        queryBuilder.append("\n").append(")").append(" ").append(QUERY_ALIAS).append(1).append("\n");
        for (int i = 2; i <= sortings.size(); ++i) {
            queryBuilder.append("FULL OUTER JOIN").append("\n").append("(");
            OrderTranslator.appendOrderSubquery(queryBuilder, translationContext, (Sorting)sortings.get(i - 1));
            queryBuilder.append("\n").append(")").append(" ").append(QUERY_ALIAS).append(i).append(" ").append("ON").append(" ");
            OrderTranslator.appendIdsCoalesce(queryBuilder, i - 1);
            queryBuilder.append(" ").append("=").append(" ").append(QUERY_ALIAS).append(i).append(".").append("id");
            queryBuilder.append("\n");
        }
    }

    private static void appendWhere(StringBuilder queryBuilder, TranslationContext translationContext) {
        List sortings = translationContext.getSortOptions().getSortings();
        queryBuilder.append("WHERE").append(" ");
        OrderTranslator.appendIdsCoalesce(queryBuilder, sortings.size());
        queryBuilder.append(" ").append("IN").append(" ").append("(SELECT UNNEST(?))");
        translationContext.getArgs().add(translationContext.getIds().toArray(new Long[0]));
        queryBuilder.append("\n");
    }

    private static void appendOrderBy(StringBuilder queryBuilder, TranslationContext translationContext) {
        List sortings = translationContext.getSortOptions().getSortings();
        queryBuilder.append("ORDER BY").append(" ");
        OrderTranslator.appendSorting(queryBuilder, translationContext, 1);
        for (int i = 2; i <= sortings.size(); ++i) {
            queryBuilder.append(",").append(" ");
            OrderTranslator.appendSorting(queryBuilder, translationContext, i);
        }
    }

    private static void appendSorting(StringBuilder queryBuilder, TranslationContext translationContext, int i) {
        List sortings = translationContext.getSortOptions().getSortings();
        Sorting sorting = (Sorting)sortings.get(i - 1);
        String field = sorting.getField();
        if (TranslatorUtils.isPropertyScoreSortingFieldName(field) || TranslatorUtils.isAnyPropertyScoreSortingFieldName(field)) {
            queryBuilder.append("rank").append(" ").append(sorting.getOrder());
        } else {
            queryBuilder.append(QUERY_ALIAS).append(i).append(".").append(VALUE_ALIAS);
            queryBuilder.append(" ").append(sorting.getOrder()).append(" ").append("NULLS LAST");
        }
    }

    private static void appendRankCalculation(StringBuilder sqlBuilder, TranslationContext translationContext, Sorting sorting) {
        Map parameters = sorting.getParameters();
        String matchValue = (String)parameters.get(SortParameter.MATCH_VALUE);
        String prefixMatchValue = (String)parameters.get(SortParameter.PREFIX_MATCH_VALUE);
        StringMatchesValue stringValue = matchValue != null ? new StringMatchesValue(matchValue) : new StringStartsWithValue(prefixMatchValue);
        Map<String, JoinInformation> joinInformationMap = OrderTranslator.getJoinInformationMap(sorting, translationContext.getAliases());
        TableMapper tableMapper = translationContext.getTableMapper();
        JoinInformation samplesTableJoinInformation = joinInformationMap.get("samp_prop_id");
        GlobalSearchCriteriaTranslator.appendRankCalculation(sqlBuilder, tableMapper, false, (AbstractStringValue)stringValue, translationContext.getArgs(), SearchCriteriaTranslator.MAIN_TABLE_ALIAS, joinInformationMap.get(tableMapper.getValuesTable()).getSubTableAlias(), joinInformationMap.get("materials").getSubTableAlias(), samplesTableJoinInformation != null ? samplesTableJoinInformation.getSubTableAlias() : null);
    }

    private static void appendIdsCoalesce(StringBuilder query, int count) {
        query.append("COALESCE(q1.id");
        for (int i = 2; i <= count; ++i) {
            query.append(",").append(" ").append(QUERY_ALIAS).append(i).append(".").append("id");
        }
        query.append(")");
    }

    private static void appendOrderSubquery(StringBuilder sqlBuilder, TranslationContext translationContext, Sorting sorting) {
        boolean anyPropertySortingFieldName = TranslatorUtils.isAnyPropertyScoreSortingFieldName(sorting.getField());
        String from = OrderTranslator.buildSubqueryFrom(translationContext, sorting);
        String select = OrderTranslator.buildSubquerySelect(translationContext, sorting);
        String where = OrderTranslator.buildSubqueryWhere(translationContext, sorting);
        sqlBuilder.append(select).append("\n").append(from).append("\n");
        if (anyPropertySortingFieldName) {
            String groupBy = "GROUP BY " + SearchCriteriaTranslator.MAIN_TABLE_ALIAS + "." + "id";
            sqlBuilder.append(groupBy).append("\n");
        }
        sqlBuilder.append(where);
    }

    private static String buildSubquerySelect(TranslationContext translationContext, Sorting sorting) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT " + SearchCriteriaTranslator.MAIN_TABLE_ALIAS + "." + "id");
        TableMapper tableMapper = translationContext.getTableMapper();
        Map<Object, Map<String, JoinInformation>> aliases = translationContext.getAliases();
        String sortingCriterionFieldName = sorting.getField();
        boolean propertyScoreSortingFieldName = TranslatorUtils.isPropertyScoreSortingFieldName(sortingCriterionFieldName);
        boolean propertySortingFieldName = TranslatorUtils.isPropertySortingFieldName(sortingCriterionFieldName);
        boolean anyPropertySortingFieldName = TranslatorUtils.isAnyPropertyScoreSortingFieldName(sortingCriterionFieldName);
        if (!anyPropertySortingFieldName) {
            if (propertyScoreSortingFieldName || propertySortingFieldName) {
                Map<String, JoinInformation> joinInformationMap = OrderTranslator.getJoinInformationMap(sorting, aliases);
                sqlBuilder.append(",").append(" ");
                String sortingCriteriaFieldName = sorting.getField();
                String propertyName = OrderTranslator.trimFieldName(sortingCriteriaFieldName);
                String casting = translationContext.getDataTypeByPropertyName().get(propertyName);
                if (casting != null) {
                    sqlBuilder.append(joinInformationMap.get(tableMapper.getValuesTable()).getSubTableAlias()).append(".").append(VALUE_ALIAS).append("::").append(casting.toLowerCase());
                } else {
                    TranslatorUtils.appendPropertyValueCoalesce(sqlBuilder, tableMapper, joinInformationMap);
                }
            } else {
                sqlBuilder.append(",").append(" ");
                OrderTranslator.appendSortingColumn(translationContext, sqlBuilder, sorting);
            }
            sqlBuilder.append(" ").append("AS").append(" ").append(VALUE_ALIAS);
        }
        if (sorting.getParameters() != null) {
            sqlBuilder.append(",").append(" ");
            if (anyPropertySortingFieldName) {
                sqlBuilder.append("SUM").append("(");
            }
            OrderTranslator.appendRankCalculation(sqlBuilder, translationContext, sorting);
            if (anyPropertySortingFieldName) {
                sqlBuilder.append(")");
            }
            sqlBuilder.append(" ").append("AS").append(" ").append("rank");
        }
        return sqlBuilder.toString();
    }

    private static String trimFieldName(String sortingCriterionFieldName) {
        if (TranslatorUtils.isAnyPropertyScoreSortingFieldName(sortingCriterionFieldName)) {
            return sortingCriterionFieldName;
        }
        boolean propertyScoreSortingFieldName = TranslatorUtils.isPropertyScoreSortingFieldName(sortingCriterionFieldName);
        return sortingCriterionFieldName.substring(propertyScoreSortingFieldName ? "PROP_SCORE".length() : "PROPERTY".length());
    }

    private static String buildSubqueryFrom(TranslationContext translationContext, Sorting sorting) {
        String aliasesMapKey;
        Map<String, JoinInformation> joinInformationMap;
        TableMapper tableMapper = translationContext.getTableMapper();
        StringBuilder sqlBuilder = new StringBuilder("FROM " + tableMapper.getEntitiesTable() + " " + SearchCriteriaTranslator.MAIN_TABLE_ALIAS);
        AtomicInteger indexCounter = new AtomicInteger(1);
        String sortingCriterionFieldName = sorting.getField();
        Map<Object, Map<String, JoinInformation>> aliases = translationContext.getAliases();
        boolean propertyScoreSortingFieldName = TranslatorUtils.isPropertyScoreSortingFieldName(sortingCriterionFieldName);
        boolean propertySortingFieldName = TranslatorUtils.isPropertySortingFieldName(sortingCriterionFieldName);
        boolean anyPropertyScoreSortingFieldName = TranslatorUtils.isAnyPropertyScoreSortingFieldName(sortingCriterionFieldName);
        if (propertyScoreSortingFieldName || propertySortingFieldName) {
            joinInformationMap = TranslatorUtils.getPropertyJoinInformationMap(tableMapper, () -> OrderTranslator.getOrderingAlias(indexCounter));
            aliasesMapKey = OrderTranslator.trimFieldName(sortingCriterionFieldName).toLowerCase();
        } else if (anyPropertyScoreSortingFieldName) {
            joinInformationMap = TranslatorUtils.getPropertyJoinInformationMap(tableMapper, () -> OrderTranslator.getOrderingAlias(indexCounter));
            aliasesMapKey = "ANY_PR_SCORE";
        } else if (OrderTranslator.isTypeSearchCriterion(sortingCriterionFieldName) || OrderTranslator.isSortingByMaterialPermId(translationContext, sortingCriterionFieldName)) {
            joinInformationMap = TranslatorUtils.getTypeJoinInformationMap(tableMapper, () -> OrderTranslator.getOrderingAlias(indexCounter));
            aliasesMapKey = "TYPE";
        } else if (OrderTranslator.isSortingByIdentifierCriterion(sortingCriterionFieldName) && tableMapper != TableMapper.SAMPLE) {
            joinInformationMap = TranslatorUtils.getIdentifierJoinInformationMap(tableMapper, () -> OrderTranslator.getOrderingAlias(indexCounter), UNIQUE_PREFIX);
            aliasesMapKey = UNIQUE_PREFIX;
        } else {
            joinInformationMap = null;
            aliasesMapKey = null;
        }
        if (joinInformationMap != null) {
            joinInformationMap.values().forEach(joinInformation -> TranslatorUtils.appendJoin(sqlBuilder, joinInformation));
            aliases.put(aliasesMapKey, joinInformationMap);
        }
        return sqlBuilder.toString();
    }

    private static String buildSubqueryWhere(TranslationContext translationContext, Sorting sorting) {
        TableMapper tableMapper = translationContext.getTableMapper();
        StringBuilder sqlBuilder = new StringBuilder("WHERE ");
        String sortingCriterionFieldName = sorting.getField();
        boolean propertyScoreSortingFieldName = TranslatorUtils.isPropertyScoreSortingFieldName(sortingCriterionFieldName);
        boolean propertySortingFieldName = TranslatorUtils.isPropertySortingFieldName(sortingCriterionFieldName);
        if (propertyScoreSortingFieldName || propertySortingFieldName) {
            String fullPropertyName = OrderTranslator.trimFieldName(sorting.getField());
            sqlBuilder.append(OrderTranslator.getJoinInformationMap(sorting, translationContext.getAliases()).get(tableMapper.getAttributeTypesTable()).getSubTableAlias()).append(".").append("code").append(" ").append("=").append(" ").append('?');
            translationContext.getArgs().add(TranslatorUtils.normalisePropertyName(fullPropertyName));
            return sqlBuilder.toString();
        }
        return "";
    }

    private static Map<String, JoinInformation> getJoinInformationMap(Sorting sorting, Map<Object, Map<String, JoinInformation>> aliases) {
        String field = sorting.getField();
        String trimmedField = field.equals("ANY_PR_SCORE") ? "ANY_PR_SCORE" : OrderTranslator.trimFieldName(field).toLowerCase();
        return aliases.get(trimmedField);
    }

    private static void appendSortingColumn(TranslationContext translationContext, StringBuilder sqlBuilder, Sorting sorting) {
        String sortingCriteriaFieldName = sorting.getField();
        Map<String, JoinInformation> aliases = translationContext.getAliases().get(UNIQUE_PREFIX);
        TableMapper tableMapper = translationContext.getTableMapper();
        if (TranslatorUtils.isPropertySortingFieldName(sortingCriteriaFieldName)) {
            String propertyName = sortingCriteriaFieldName.substring("PROPERTY".length());
            String propertyNameLowerCase = propertyName.toLowerCase();
            String valuesTableAlias = translationContext.getAliases().get(propertyNameLowerCase).get(tableMapper.getEntityTypesAttributeTypesTable()).getMainTableAlias();
            sqlBuilder.append(valuesTableAlias).append(".").append(VALUE_ALIAS);
            String casting = translationContext.getDataTypeByPropertyName().get(propertyName);
            if (casting != null) {
                sqlBuilder.append("::").append(casting.toLowerCase());
            }
        } else if (OrderTranslator.isTypeSearchCriterion(sortingCriteriaFieldName)) {
            String typesTableAlias = translationContext.getAliases().get("TYPE").get(tableMapper.getEntityTypesTable()).getSubTableAlias();
            sqlBuilder.append(typesTableAlias).append(".").append("code");
        } else if (OrderTranslator.isSortingByIdentifierCriterion(sortingCriteriaFieldName)) {
            if (tableMapper != TableMapper.SAMPLE) {
                JoinInformation entitiesTableAlias = aliases.get(tableMapper.getEntitiesTable());
                JoinInformation spacesTableAlias = aliases.get(UNIQUE_PREFIX + "spaces");
                JoinInformation projectsTableAlias = aliases.get(UNIQUE_PREFIX + "projects");
                TranslatorUtils.buildFullIdentifierConcatenationString(sqlBuilder, spacesTableAlias != null ? spacesTableAlias.getSubTableAlias() : null, projectsTableAlias != null ? projectsTableAlias.getSubTableAlias() : null, entitiesTableAlias != null ? entitiesTableAlias.getSubTableAlias() : null, false);
            } else {
                sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("sample_identifier");
            }
        } else if (OrderTranslator.isSortingByMaterialPermId(translationContext, sortingCriteriaFieldName)) {
            String materialTypeTableAlias = translationContext.getAliases().get("TYPE").get(tableMapper.getEntityTypesTable()).getSubTableAlias();
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("code");
            sqlBuilder.append(",").append(" ").append(materialTypeTableAlias).append(".").append("code");
        } else if (OrderTranslator.isSortingBySpaceModificationDate(translationContext, sortingCriteriaFieldName)) {
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("registration_timestamp".toLowerCase());
        } else {
            String lowerCaseSortingCriteriaFieldName = sortingCriteriaFieldName.toLowerCase();
            String fieldName = AttributesMapper.getColumnName(lowerCaseSortingCriteriaFieldName, tableMapper.getEntitiesTable(), lowerCaseSortingCriteriaFieldName);
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append(fieldName);
        }
    }

    private static boolean isSortingBySpaceModificationDate(TranslationContext translationContext, String sortingCriteriaFieldName) {
        return "MODIFICATION_DATE".equals(sortingCriteriaFieldName) && translationContext.getTableMapper() == TableMapper.SPACE;
    }

    private static boolean isSortingByMaterialPermId(TranslationContext translationContext, String sortingCriteriaFieldName) {
        return "PERM_ID".equals(sortingCriteriaFieldName) && translationContext.getTableMapper() == TableMapper.MATERIAL;
    }

    private static String getOrderingAlias(AtomicInteger num) {
        return "o" + num.getAndIncrement();
    }

    private static boolean isSortingByIdentifierCriterion(String sortingCriteriaFieldName) {
        return sortingCriteriaFieldName.equals(IDENTIFIER);
    }

    private static boolean isTypeSearchCriterion(String sortingCriteriaFieldName) {
        return sortingCriteriaFieldName.equals("TYPE");
    }
}

