/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractCompositeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractObjectSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AnyPropertySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AnyStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.LongDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NormalDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ShortDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.search.EntityTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.search.ExperimentTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.search.MaterialTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleContainerSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.search.TagSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.CriteriaMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.ILocalSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.ISearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SQLLexemes;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SelectQuery;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.TranslatorUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class SearchCriteriaTranslator {
    public static final DateFormat DATE_HOURS_MINUTES_SECONDS_FORMAT = new SimpleDateFormat(new LongDateFormat().getFormat());
    public static final DateFormat DATE_HOURS_MINUTES_FORMAT = new SimpleDateFormat(new NormalDateFormat().getFormat());
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat(new ShortDateFormat().getFormat());
    public static final String MAIN_TABLE_ALIAS = TranslatorUtils.getAlias(new AtomicInteger(0));

    private SearchCriteriaTranslator() {
        throw new UnsupportedOperationException();
    }

    public static SelectQuery translate(TranslationContext translationContext) {
        if (translationContext.getCriteria() == null) {
            throw new IllegalArgumentException("Null criteria provided.");
        }
        String from = SearchCriteriaTranslator.buildFrom(translationContext);
        String where = SearchCriteriaTranslator.buildWhere(translationContext);
        String select = SearchCriteriaTranslator.buildSelect(translationContext);
        String mainQuery = select + "\n" + from + "\n" + where;
        return new SelectQuery(translationContext.getParentCriterion().isNegated() ? select + "\n" + from + "\n" + "WHERE" + " " + MAIN_TABLE_ALIAS + "." + translationContext.getIdColumnName() + " " + "NOT" + " " + "IN" + " " + "(" + "\n" + mainQuery + "\n" + ")" : mainQuery, translationContext.getArgs());
    }

    private static String buildSelect(TranslationContext translationContext) {
        return "SELECT " + (translationContext.getParentCriterion().isNegated() ? "" : "DISTINCT") + " " + MAIN_TABLE_ALIAS + "." + translationContext.getIdColumnName();
    }

    private static String buildFrom(TranslationContext translationContext) {
        StringBuilder sqlBuilder = new StringBuilder();
        TableMapper tableMapper = translationContext.getTableMapper();
        String entitiesTableName = tableMapper.getEntitiesTable();
        sqlBuilder.append("FROM").append(" ").append(entitiesTableName).append(" ").append(MAIN_TABLE_ALIAS);
        AtomicInteger indexCounter = new AtomicInteger(1);
        translationContext.getCriteria().forEach(criterion -> {
            if (!CriteriaMapper.getCriteriaToManagerMap().containsKey(criterion.getClass()) && !(criterion instanceof EntityTypeSearchCriteria)) {
                IConditionTranslator<? extends ISearchCriteria> conditionTranslator = CriteriaMapper.getCriteriaToConditionTranslatorMap().get(criterion.getClass());
                if (conditionTranslator != null) {
                    Map<String, JoinInformation> joinInformationMap = conditionTranslator.getJoinInformationMap((ISearchCriteria)criterion, tableMapper, () -> TranslatorUtils.getAlias(indexCounter));
                    if (joinInformationMap != null) {
                        joinInformationMap.values().forEach(joinInformation -> TranslatorUtils.appendJoin(sqlBuilder, joinInformation));
                        translationContext.getAliases().put(criterion, joinInformationMap);
                    }
                } else {
                    throw new IllegalArgumentException("Unsupported criterion type: " + criterion.getClass().getSimpleName());
                }
            }
        });
        return sqlBuilder.toString();
    }

    private static String buildWhere(TranslationContext translationContext) {
        Collection<ISearchCriteria> criteria = translationContext.getCriteria();
        if (SearchCriteriaTranslator.isSearchAllCriteria(criteria)) {
            return "WHERE " + SQLLexemes.TRUE;
        }
        if (SearchCriteriaTranslator.isSearchAnyPropertyCriteria(criteria)) {
            StringBuilder resultSqlBuilder = new StringBuilder("WHERE ");
            TranslatorUtils.appendPropertyValueCoalesce(resultSqlBuilder, translationContext.getTableMapper(), translationContext.getAliases().get(translationContext.getCriteria().iterator().next()));
            resultSqlBuilder.append(" ").append("IS NOT NULL");
            return resultSqlBuilder.toString();
        }
        String logicalOperator = translationContext.getOperator().toString();
        String separator = " " + logicalOperator + " ";
        StringBuilder resultSqlBuilder = criteria.stream().collect(StringBuilder::new, (sqlBuilder, criterion) -> {
            sqlBuilder.append(separator).append("(");
            SearchCriteriaTranslator.appendCriterionCondition(translationContext, translationContext.getAuthorisationInformation(), sqlBuilder, criterion);
            sqlBuilder.append(")");
        }, StringBuilder::append);
        String condition = resultSqlBuilder.substring(separator.length());
        return "WHERE " + condition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void appendCriterionCondition(TranslationContext translationContext, AuthorisationInformation authorisationInformation, StringBuilder sqlBuilder, ISearchCriteria criterion) {
        TableMapper tableMapper = translationContext.getTableMapper();
        ISearchManager subqueryManager = criterion instanceof EntityTypeSearchCriteria ? (ISearchManager)CriteriaMapper.getEntityKindToManagerMap().get(tableMapper.getEntityKind()) : CriteriaMapper.getCriteriaToManagerMap().get(criterion.getClass());
        AbstractCompositeSearchCriteria parentCriterion = translationContext.getParentCriterion();
        if (tableMapper == null || SearchCriteriaTranslator.isCriterionConsistentWithEntityKind(criterion, tableMapper.getEntityKind())) {
            if (subqueryManager != null) {
                String column = parentCriterion.getClass() == criterion.getClass() ? "id" : (criterion instanceof EntityTypeSearchCriteria ? tableMapper.getEntityTypesAttributeTypesTableEntityTypeIdField() : CriteriaMapper.getCriteriaToInColumnMap().get(criterion.getClass()));
                if (tableMapper != null) {
                    criterion = SearchCriteriaTranslator.convertCriterionIfNeeded(criterion, tableMapper.getEntityKind());
                }
                if (tableMapper == null || column == null) throw new NullPointerException("tableMapper = " + (Object)((Object)tableMapper) + ", column = " + column + ", criterion.getClass() = " + criterion.getClass());
                if (!(subqueryManager instanceof ILocalSearchManager)) {
                    throw new IllegalArgumentException("Only local search subqueries are supported.");
                }
                ILocalSearchManager localSearchManager = (ILocalSearchManager)subqueryManager;
                Set<Long> ids = localSearchManager.searchForIDs(translationContext.getUserId(), authorisationInformation, criterion, parentCriterion, CriteriaMapper.getParentChildCriteriaToChildSelectIdMap().getOrDefault(Arrays.asList(parentCriterion.getClass(), criterion.getClass()), "id"));
                SearchCriteriaTranslator.appendInStatement(sqlBuilder, criterion, column, tableMapper);
                translationContext.getArgs().add(ids.toArray(new Long[0]));
                return;
            } else {
                IConditionTranslator<? extends ISearchCriteria> conditionTranslator = CriteriaMapper.getCriteriaToConditionTranslatorMap().get(criterion.getClass());
                if (conditionTranslator == null) throw new IllegalArgumentException("Unsupported criterion type: " + criterion.getClass().getSimpleName());
                conditionTranslator.translate((ISearchCriteria)criterion, tableMapper, translationContext.getArgs(), sqlBuilder, translationContext.getAliases().get(criterion), translationContext.getDataTypeByPropertyCode());
            }
            return;
        } else {
            sqlBuilder.append(SQLLexemes.FALSE);
        }
    }

    private static ISearchCriteria convertCriterionIfNeeded(ISearchCriteria criterion, EntityKind entityKind) {
        if (criterion instanceof EntityTypeSearchCriteria && entityKind != null) {
            EntityTypeSearchCriteria entityTypeSearchCriterion = (EntityTypeSearchCriteria)criterion;
            switch (entityKind) {
                case MATERIAL: {
                    MaterialTypeSearchCriteria newCriterion = new MaterialTypeSearchCriteria();
                    switch (entityTypeSearchCriterion.getOperator()) {
                        case AND: {
                            newCriterion.withAndOperator();
                            break;
                        }
                        case OR: {
                            newCriterion.withOrOperator();
                        }
                    }
                    newCriterion.setCriteria(entityTypeSearchCriterion.getCriteria());
                    return newCriterion;
                }
                case EXPERIMENT: {
                    ExperimentTypeSearchCriteria newCriterion = new ExperimentTypeSearchCriteria();
                    switch (entityTypeSearchCriterion.getOperator()) {
                        case AND: {
                            newCriterion.withAndOperator();
                            break;
                        }
                        case OR: {
                            newCriterion.withOrOperator();
                        }
                    }
                    newCriterion.setCriteria(entityTypeSearchCriterion.getCriteria());
                    return newCriterion;
                }
                case SAMPLE: {
                    SampleTypeSearchCriteria newCriterion = new SampleTypeSearchCriteria();
                    switch (entityTypeSearchCriterion.getOperator()) {
                        case AND: {
                            newCriterion.withAndOperator();
                            break;
                        }
                        case OR: {
                            newCriterion.withOrOperator();
                        }
                    }
                    newCriterion.setCriteria(entityTypeSearchCriterion.getCriteria());
                    return newCriterion;
                }
                case DATA_SET: {
                    DataSetTypeSearchCriteria newCriterion = new DataSetTypeSearchCriteria();
                    switch (entityTypeSearchCriterion.getOperator()) {
                        case AND: {
                            newCriterion.withAndOperator();
                            break;
                        }
                        case OR: {
                            newCriterion.withOrOperator();
                        }
                    }
                    newCriterion.setCriteria(entityTypeSearchCriterion.getCriteria());
                    return newCriterion;
                }
            }
            throw new IllegalArgumentException("Unknown entity kind: " + entityKind);
        }
        return criterion;
    }

    private static boolean isCriterionConsistentWithEntityKind(ISearchCriteria criterion, EntityKind entityKind) {
        if (criterion instanceof IdSearchCriteria && entityKind != null) {
            IdSearchCriteria idSearchCriterion = (IdSearchCriteria)criterion;
            if (idSearchCriterion.getId() instanceof EntityTypePermId) {
                EntityTypePermId objectPermId = (EntityTypePermId)idSearchCriterion.getId();
                return objectPermId.getEntityKind() == null || objectPermId.getEntityKind() == entityKind;
            }
            return true;
        }
        return true;
    }

    private static void appendInStatement(StringBuilder sqlBuilder, ISearchCriteria criterion, String column, TableMapper tableMapper) {
        sqlBuilder.append(MAIN_TABLE_ALIAS).append(".").append(column).append(" ").append("IN").append(" ").append("(");
        if (!(criterion instanceof TagSearchCriteria)) {
            sqlBuilder.append("SELECT").append(" ").append("UNNEST").append("(").append('?').append(")");
        } else {
            String e = "e";
            String mpa = "mpa";
            String mp = "mp";
            sqlBuilder.append("SELECT").append(" ").append("e").append(".").append(column).append("\n").append("FROM").append(" ").append(tableMapper.getEntitiesTable()).append(" ").append("e").append("\n").append("LEFT JOIN").append(" ").append("metaproject_assignments_all").append(" ").append("mpa").append(" ").append("ON").append(" ").append("e").append(".").append("id").append(" ").append("=").append(" ").append("mpa").append(".").append(tableMapper.getMetaprojectAssignmentsEntityIdField()).append("\n").append("LEFT JOIN").append(" ").append("metaprojects").append(" ").append("mp").append(" ").append("ON").append(" ").append("mpa").append(".").append("mepr_id").append(" ").append("=").append(" ").append("mp").append(".").append("id").append("\n").append("WHERE").append(" ").append("mp").append(".").append("id").append(" ").append("IN").append(" ").append("(");
            sqlBuilder.append("SELECT").append(" ").append("UNNEST").append("(").append('?').append(")");
            sqlBuilder.append(")");
        }
        sqlBuilder.append(")");
    }

    private static boolean isSearchAllCriteria(Collection<ISearchCriteria> criteria) {
        switch (criteria.size()) {
            case 0: {
                return true;
            }
            case 1: {
                ISearchCriteria criterion = criteria.iterator().next();
                return criterion instanceof AbstractObjectSearchCriteria && !(criterion instanceof SampleContainerSearchCriteria) && ((AbstractCompositeSearchCriteria)criterion).getCriteria().isEmpty();
            }
        }
        return false;
    }

    private static boolean isSearchAnyPropertyCriteria(Collection<ISearchCriteria> criteria) {
        return criteria.stream().allMatch(criterion -> criterion instanceof AnyPropertySearchCriteria && ((AnyPropertySearchCriteria)criterion).getFieldValue() instanceof AnyStringValue);
    }
}

