/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AnyFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchFieldType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringContainsExactlyValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringContainsValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringEndsWithValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringMatchesValue;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.PSQLTypes;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SQLLexemes;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.AnyPropertySearchConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.CodeSearchConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IAliasFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IdentifierSearchConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.TranslatorUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.util.SimplePropertyValidator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class AnyFieldSearchConditionTranslator
implements IConditionTranslator<AnyFieldSearchCriteria> {
    public static final Map<Class<? extends IDateFormat>, String> TRUNCATION_INTERVAL_BY_DATE_FORMAT = new HashMap<Class<? extends IDateFormat>, String>(3);
    private static final String OR_SEPARATOR = " OR ";

    @Override
    public Map<String, JoinInformation> getJoinInformationMap(AnyFieldSearchCriteria criterion, TableMapper tableMapper, IAliasFactory aliasFactory) {
        return TranslatorUtils.getFieldJoinInformationMap(tableMapper, aliasFactory);
    }

    @Override
    public void translate(AnyFieldSearchCriteria criterion, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, Map<String, String> dataTypeByPropertyCode) {
        if (criterion.getFieldType() != SearchFieldType.ANY_FIELD) {
            throw new IllegalArgumentException("Field type " + criterion.getFieldType() + " is not supported");
        }
        AnyFieldSearchConditionTranslator.translateAnyField((AbstractFieldSearchCriteria<AbstractStringValue>)criterion, criterion.isUseWildcards(), tableMapper, args, sqlBuilder, aliases);
    }

    public static void translateAnyField(AbstractFieldSearchCriteria<AbstractStringValue> criterion, boolean useWildcards, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases) {
        AbstractStringValue value = (AbstractStringValue)criterion.getFieldValue();
        String stringValue = TranslatorUtils.stripQuotationMarks((String)value.getValue());
        Set<PSQLTypes> compatiblePSQLTypesForValue = AnyFieldSearchConditionTranslator.findCompatibleSqlTypesForValue(stringValue);
        Class<?> valueClass = value.getClass();
        boolean equalsToComparison = valueClass == StringEqualToValue.class;
        int separatorLength = OR_SEPARATOR.length();
        sqlBuilder.append("(");
        AnyPropertySearchConditionTranslator.doTranslate(criterion, useWildcards, tableMapper, args, sqlBuilder, aliases);
        sqlBuilder.append(OR_SEPARATOR);
        if (valueClass != StringMatchesValue.class) {
            StringBuilder resultSqlBuilder;
            IdentifierSearchConditionTranslator.doTranslate(criterion, useWildcards, tableMapper, args, sqlBuilder, aliases, "");
            sqlBuilder.append(OR_SEPARATOR);
            AnyFieldSearchConditionTranslator.translateEntityTypeMatch(value, args, sqlBuilder, aliases, useWildcards);
            sqlBuilder.append(OR_SEPARATOR);
            if (tableMapper.hasRegistrator()) {
                AnyFieldSearchConditionTranslator.translateUserMatch(value, args, sqlBuilder, aliases, "registrator", useWildcards);
                sqlBuilder.append(OR_SEPARATOR);
            }
            if (tableMapper.hasModifier()) {
                AnyFieldSearchConditionTranslator.translateUserMatch(value, args, sqlBuilder, aliases, "modifier", useWildcards);
                sqlBuilder.append(OR_SEPARATOR);
            }
            if ((resultSqlBuilder = tableMapper.getFieldToSQLTypeMap().entrySet().stream().collect(StringBuilder::new, (stringBuilder, fieldToSQLTypesEntry) -> AnyFieldSearchConditionTranslator.translateField(tableMapper, args, SearchCriteriaTranslator.MAIN_TABLE_ALIAS, value, useWildcards, stringValue, compatiblePSQLTypesForValue, valueClass, equalsToComparison, stringBuilder, fieldToSQLTypesEntry), StringBuilder::append)).length() > separatorLength) {
                sqlBuilder.append(resultSqlBuilder.substring(separatorLength));
            }
            if (args.isEmpty() || resultSqlBuilder.length() <= separatorLength) {
                sqlBuilder.append(SQLLexemes.FALSE);
            }
        } else {
            TranslatorUtils.appendTsVectorMatch(sqlBuilder, (AbstractStringValue)criterion.getFieldValue(), SearchCriteriaTranslator.MAIN_TABLE_ALIAS, args);
        }
        sqlBuilder.append(")").append("\n");
    }

    private static void translateField(TableMapper tableMapper, List<Object> args, String alias, AbstractStringValue value, boolean useWildcards, String stringValue, Set<PSQLTypes> compatiblePSQLTypesForValue, Class<? extends AbstractStringValue> valueClass, boolean equalsToComparison, StringBuilder stringBuilder, Map.Entry<String, PSQLTypes> fieldToSQLTypesEntry) {
        String fieldName = fieldToSQLTypesEntry.getKey();
        PSQLTypes fieldSQLType = fieldToSQLTypesEntry.getValue();
        boolean includeColumn = compatiblePSQLTypesForValue.contains((Object)fieldSQLType);
        if ("code".equals(fieldName)) {
            if (tableMapper != TableMapper.SAMPLE || valueClass != StringContainsValue.class && valueClass != StringContainsExactlyValue.class && valueClass != StringEndsWithValue.class) {
                stringBuilder.append(OR_SEPARATOR);
                CodeSearchConditionTranslator.translateSearchByCodeCondition(stringBuilder, tableMapper, value.getClass(), stringValue, useWildcards, args);
            }
        } else if (equalsToComparison || fieldSQLType == PSQLTypes.TIMESTAMP_WITH_TZ) {
            if (includeColumn) {
                if (fieldSQLType == PSQLTypes.TIMESTAMP_WITH_TZ) {
                    Optional<Object[]> dateFormatWithResultOptional = DateFieldSearchCriteria.DATE_FORMATS.stream().map(dateFormat -> {
                        Object[] objectArray;
                        Date formattedValue = DateFieldSearchCriteria.formatValue((String)stringValue, (IDateFormat)dateFormat);
                        if (formattedValue == null) {
                            objectArray = null;
                        } else {
                            Object[] objectArray2 = new Object[2];
                            objectArray2[0] = TRUNCATION_INTERVAL_BY_DATE_FORMAT.get(dateFormat.getClass());
                            objectArray = objectArray2;
                            objectArray2[1] = formattedValue;
                        }
                        return objectArray;
                    }).filter(Objects::nonNull).findFirst();
                    dateFormatWithResultOptional.ifPresent(dateFormatWithResult -> {
                        stringBuilder.append(OR_SEPARATOR).append("date_trunc").append("(");
                        stringBuilder.append("'").append(dateFormatWithResult[0]).append("'").append(",").append(" ").append(alias).append(".").append(fieldName);
                        stringBuilder.append(")").append(" ").append("=").append(" ").append('?');
                        args.add(dateFormatWithResult[1]);
                    });
                } else {
                    stringBuilder.append(OR_SEPARATOR).append(alias).append(".").append(fieldName);
                    stringBuilder.append(" ").append("=").append(" ").append('?').append("::").append(fieldSQLType.toString());
                    args.add(stringValue);
                }
            }
        } else {
            stringBuilder.append(OR_SEPARATOR);
            TranslatorUtils.translateStringComparison(alias, fieldName, value, useWildcards, PSQLTypes.VARCHAR, stringBuilder, args);
        }
    }

    private static void translateUserMatch(AbstractStringValue value, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, String personJoinInformationKey, boolean useWildcards) {
        sqlBuilder.append(aliases.get(personJoinInformationKey).getSubTableAlias()).append(".").append("user_id").append(" ");
        TranslatorUtils.appendStringComparatorOp(value.getClass(), TranslatorUtils.stripQuotationMarks((String)value.getValue()), useWildcards, sqlBuilder, args);
    }

    private static void translateEntityTypeMatch(AbstractStringValue value, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, boolean useWildcards) {
        sqlBuilder.append(aliases.get("entity_type").getSubTableAlias()).append(".").append("code").append(" ");
        TranslatorUtils.appendStringComparatorOp(value.getClass(), TranslatorUtils.stripQuotationMarks((String)value.getValue()), useWildcards, sqlBuilder, args);
    }

    private static Set<PSQLTypes> findCompatibleSqlTypesForValue(String value) {
        SimplePropertyValidator validator = new SimplePropertyValidator();
        try {
            validator.validatePropertyValue(DataTypeCode.DATE, value);
            return EnumSet.of(PSQLTypes.DATE, PSQLTypes.TIMESTAMP_WITH_TZ);
        }
        catch (UserFailureException e1) {
            try {
                validator.validatePropertyValue(DataTypeCode.TIMESTAMP, value);
                return EnumSet.of(PSQLTypes.TIMESTAMP_WITH_TZ);
            }
            catch (UserFailureException e2) {
                try {
                    validator.validatePropertyValue(DataTypeCode.BOOLEAN, value);
                    return EnumSet.of(PSQLTypes.BOOLEAN);
                }
                catch (UserFailureException e3) {
                    try {
                        validator.validatePropertyValue(DataTypeCode.INTEGER, value);
                        return EnumSet.of(PSQLTypes.INT8, PSQLTypes.INT4, PSQLTypes.INT2, PSQLTypes.FLOAT4, PSQLTypes.FLOAT8);
                    }
                    catch (UserFailureException e4) {
                        try {
                            validator.validatePropertyValue(DataTypeCode.REAL, value);
                            return EnumSet.of(PSQLTypes.FLOAT4, PSQLTypes.FLOAT8);
                        }
                        catch (UserFailureException e5) {
                            validator.validatePropertyValue(DataTypeCode.VARCHAR, value);
                            return EnumSet.of(PSQLTypes.VARCHAR);
                        }
                    }
                }
            }
        }
    }

    static {
        TRUNCATION_INTERVAL_BY_DATE_FORMAT.put(DateFieldSearchCriteria.SHORT_DATE_FORMAT.getClass(), "day");
        TRUNCATION_INTERVAL_BY_DATE_FORMAT.put(DateFieldSearchCriteria.NORMAL_DATE_FORMAT.getClass(), "minute");
        TRUNCATION_INTERVAL_BY_DATE_FORMAT.put(DateFieldSearchCriteria.LONG_DATE_FORMAT.getClass(), "second");
    }
}

