/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AnyPropertySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AnyStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchFieldType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringMatchesValue;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SQLLexemes;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IAliasFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.TranslatorUtils;
import java.util.List;
import java.util.Map;

public class AnyPropertySearchConditionTranslator
implements IConditionTranslator<AnyPropertySearchCriteria> {
    @Override
    public Map<String, JoinInformation> getJoinInformationMap(AnyPropertySearchCriteria criterion, TableMapper tableMapper, IAliasFactory aliasFactory) {
        if (criterion.getFieldType() == SearchFieldType.ANY_PROPERTY) {
            return TranslatorUtils.getPropertyJoinInformationMap(tableMapper, aliasFactory);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void translate(AnyPropertySearchCriteria criterion, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, Map<String, String> dataTypeByPropertyCode) {
        switch (criterion.getFieldType()) {
            case ANY_PROPERTY: {
                AnyPropertySearchConditionTranslator.doTranslate((AbstractFieldSearchCriteria<AbstractStringValue>)criterion, criterion.isUseWildcards(), tableMapper, args, sqlBuilder, aliases);
                break;
            }
            case ANY_FIELD: 
            case PROPERTY: 
            case ATTRIBUTE: {
                throw new IllegalArgumentException("Field type " + criterion.getFieldType() + " is not supported");
            }
        }
    }

    static void doTranslate(AbstractFieldSearchCriteria<AbstractStringValue> criterion, boolean useWildcards, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases) {
        AbstractStringValue value = (AbstractStringValue)criterion.getFieldValue();
        JoinInformation joinInformation = aliases.get(tableMapper.getAttributeTypesTable());
        String entityTypesSubTableAlias = joinInformation.getSubTableAlias();
        if (value.getClass() != AnyStringValue.class) {
            if (value.getClass() != StringMatchesValue.class) {
                sqlBuilder.append(entityTypesSubTableAlias).append(".").append(joinInformation.getSubTableIdField()).append(" ").append("IS NOT NULL").append(" ").append("AND").append(" ").append("(");
                sqlBuilder.append(aliases.get(tableMapper.getValuesTable()).getSubTableAlias()).append(".").append("value").append(" ");
                String finalValue = TranslatorUtils.stripQuotationMarks((String)value.getValue());
                TranslatorUtils.appendStringComparatorOp(value.getClass(), finalValue, useWildcards, sqlBuilder, args);
                sqlBuilder.append(" ").append("OR").append(" ").append(aliases.get("controlled_vocabulary_terms").getSubTableAlias()).append(".").append("code").append(" ");
                TranslatorUtils.appendStringComparatorOp(value.getClass(), finalValue, useWildcards, sqlBuilder, args);
                if (tableMapper == TableMapper.SAMPLE || tableMapper == TableMapper.EXPERIMENT || tableMapper == TableMapper.DATA_SET) {
                    AnyPropertySearchConditionTranslator.appendSamplePropertyComparison(sqlBuilder, value, useWildcards, aliases, "code", args);
                    AnyPropertySearchConditionTranslator.appendSamplePropertyComparison(sqlBuilder, value, useWildcards, aliases, "perm_id", args);
                    AnyPropertySearchConditionTranslator.appendSamplePropertyComparison(sqlBuilder, value, useWildcards, aliases, "sample_identifier", args);
                }
                sqlBuilder.append(")");
            } else {
                TranslatorUtils.appendTsVectorMatch(sqlBuilder, (AbstractStringValue)criterion.getFieldValue(), aliases.get(tableMapper.getValuesTable()).getSubTableAlias(), args);
            }
        } else {
            sqlBuilder.append(SQLLexemes.TRUE);
        }
    }

    private static void appendSamplePropertyComparison(StringBuilder sqlBuilder, AbstractStringValue value, boolean useWildcards, Map<String, JoinInformation> aliases, String columnName, List<Object> args) {
        String finalValue = (String)value.getValue();
        sqlBuilder.append(" ").append("OR").append(" ").append(aliases.get("samp_prop_id").getSubTableAlias()).append(".").append(columnName);
        TranslatorUtils.appendStringComparatorOp(value.getClass(), finalValue, useWildcards, sqlBuilder, args);
    }
}

