/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.BooleanFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.DataType;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.PSQLTypes;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.AttributesMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IAliasFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.TranslatorUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import java.util.List;
import java.util.Map;

public class BooleanFieldSearchConditionTranslator
implements IConditionTranslator<BooleanFieldSearchCriteria> {
    @Override
    public Map<String, JoinInformation> getJoinInformationMap(BooleanFieldSearchCriteria criterion, TableMapper tableMapper, IAliasFactory aliasFactory) {
        switch (criterion.getFieldType()) {
            case ATTRIBUTE: {
                return null;
            }
            case PROPERTY: 
            case ANY_PROPERTY: {
                return TranslatorUtils.getPropertyJoinInformationMap(tableMapper, aliasFactory);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void translate(BooleanFieldSearchCriteria criterion, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, Map<String, String> dataTypeByPropertyCode) {
        switch (criterion.getFieldType()) {
            case ATTRIBUTE: {
                String criterionFieldName = criterion.getFieldName();
                String columnName = AttributesMapper.getColumnName(criterionFieldName, tableMapper.getValuesTable(), criterionFieldName);
                Boolean value = (Boolean)criterion.getFieldValue();
                sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append(columnName).append(" ").append("=").append(" ").append('?');
                args.add(value);
                break;
            }
            case PROPERTY: {
                String casting = dataTypeByPropertyCode.get(criterion.getFieldName());
                if (!DataTypeCode.BOOLEAN.toString().equals(casting)) {
                    throw new UserFailureException(String.format("The data type of property %s has to be %s instead of %s.", criterion.getFieldName(), DataTypeCode.BOOLEAN, casting));
                }
                BooleanFieldSearchConditionTranslator.translateBooleanProperty(tableMapper, args, sqlBuilder, aliases, (Boolean)criterion.getFieldValue(), criterion.getFieldName());
                break;
            }
            case ANY_PROPERTY: {
                BooleanFieldSearchConditionTranslator.translateBooleanProperty(tableMapper, args, sqlBuilder, aliases, (Boolean)criterion.getFieldValue(), null);
                break;
            }
            case ANY_FIELD: {
                throw new IllegalArgumentException();
            }
        }
    }

    static void translateBooleanProperty(TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, Boolean value, String fullPropertyName) {
        JoinInformation joinInformation = aliases.get(tableMapper.getAttributeTypesTable());
        String entityTypesSubTableAlias = joinInformation.getSubTableAlias();
        sqlBuilder.append(entityTypesSubTableAlias).append(".").append(joinInformation.getSubTableIdField()).append(" ").append("IS NOT NULL").append(" ").append("AND").append(" ").append("(");
        if (value != null) {
            sqlBuilder.append("CASE").append(" ").append("WHEN").append(" ");
        }
        sqlBuilder.append(aliases.get("data_types").getSubTableAlias()).append(".").append("code").append(" ").append("=").append(" ").append("'").append(DataType.BOOLEAN).append("'");
        if (fullPropertyName != null) {
            sqlBuilder.append(" ").append("AND").append(" ");
            TranslatorUtils.appendInternalExternalConstraint(sqlBuilder, args, entityTypesSubTableAlias, TranslatorUtils.isPropertyInternal(fullPropertyName));
            sqlBuilder.append(" ").append("AND");
            sqlBuilder.append(" ").append(entityTypesSubTableAlias).append(".").append("code").append(" ").append("=").append(" ").append('?');
            args.add(TranslatorUtils.normalisePropertyName(fullPropertyName));
        }
        if (value != null) {
            sqlBuilder.append(" ").append("THEN").append(" ");
            sqlBuilder.append(aliases.get(tableMapper.getValuesTable()).getSubTableAlias()).append(".").append("value").append("::").append((Object)PSQLTypes.BOOLEAN).append(" ").append("=").append(" ").append('?').append(" ").append("END");
            args.add(value);
        }
        sqlBuilder.append(")");
    }
}

