/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IAliasFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.TranslatorUtils;
import java.util.List;
import java.util.Map;

public class CodeSearchConditionTranslator
implements IConditionTranslator<StringFieldSearchCriteria> {
    @Override
    public Map<String, JoinInformation> getJoinInformationMap(StringFieldSearchCriteria criterion, TableMapper tableMapper, IAliasFactory aliasFactory) {
        return null;
    }

    @Override
    public void translate(StringFieldSearchCriteria criterion, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, Map<String, String> dataTypeByPropertyCode) {
        switch (criterion.getFieldType()) {
            case ATTRIBUTE: {
                AbstractStringValue value = (AbstractStringValue)criterion.getFieldValue();
                boolean useWildcards = criterion.isUseWildcards();
                if (value != null && value.getValue() != null) {
                    String stringValue = (String)value.getValue();
                    CodeSearchConditionTranslator.translateSearchByCodeCondition(sqlBuilder, tableMapper, value.getClass(), stringValue, useWildcards, args);
                    break;
                }
                sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("code").append(" ").append("IS NOT NULL");
                break;
            }
            case PROPERTY: 
            case ANY_PROPERTY: 
            case ANY_FIELD: {
                throw new IllegalArgumentException();
            }
        }
    }

    static void translateSearchByCodeCondition(StringBuilder sqlBuilder, TableMapper tableMapper, Class<?> valueClass, String stringValue, boolean useWildcards, List<Object> args) {
        if (tableMapper == TableMapper.SAMPLE) {
            CodeSearchConditionTranslator.buildCodeQueryForSamples(sqlBuilder, () -> TranslatorUtils.appendStringComparatorOp(valueClass, stringValue, useWildcards, sqlBuilder, args));
        } else {
            String column = tableMapper == TableMapper.TAG ? "name" : "code";
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append(column).append(" ");
            TranslatorUtils.appendStringComparatorOp(valueClass, stringValue.toUpperCase(), useWildcards, sqlBuilder, args);
        }
    }

    public static void buildCodeQueryForSamples(StringBuilder sqlBuilder, Runnable comparisonBuilder) {
        sqlBuilder.append("CASE").append("\n").append(" ").append(" ").append("WHEN").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("samp_id_part_of").append(" ").append("IS NULL").append(" ").append("THEN").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("code");
        comparisonBuilder.run();
        sqlBuilder.append("\n").append(" ").append(" ").append("ELSE").append(" ").append("substr").append("(").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("sample_identifier").append(",").append(" ").append("length").append("(").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("sample_identifier").append(")").append(" ").append("-").append(" ").append("strpos").append("(").append("reverse").append("(").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("sample_identifier").append(")").append(",").append(" ").append("'").append('/').append("'").append(")").append(" ").append("+").append(" ").append(2).append(")");
        comparisonBuilder.run();
        sqlBuilder.append("\n").append("END");
    }
}

