/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodesSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CollectionFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdsSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.search.UserIdsSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.AttributesMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.CodeSearchConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IAliasFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinInformation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CollectionFieldSearchConditionTranslator
implements IConditionTranslator<CollectionFieldSearchCriteria<?>> {
    private static final Map<Class, Object[]> ARRAY_CASTING = new HashMap<Class, Object[]>();

    @Override
    public Map<String, JoinInformation> getJoinInformationMap(CollectionFieldSearchCriteria<?> criterion, TableMapper tableMapper, IAliasFactory aliasFactory) {
        return null;
    }

    @Override
    public void translate(CollectionFieldSearchCriteria<?> criterion, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, Map<String, String> dataTypeByPropertyCode) {
        if (!ARRAY_CASTING.containsKey(criterion.getClass())) {
            throw new RuntimeException("Unsupported " + CollectionFieldSearchCriteria.class.getSimpleName() + ", this is a core error, contact the development team.");
        }
        if (criterion.getClass() == IdsSearchCriteria.class && criterion.getFieldValue() != null && ((Collection)criterion.getFieldValue()).size() > 1) {
            Class<?> identifierClass = ((Collection)criterion.getFieldValue()).iterator().next().getClass();
            for (Object identifier : (Collection)criterion.getFieldValue()) {
                if (identifier.getClass() == identifierClass) continue;
                throw new IllegalArgumentException("Unsupported " + CollectionFieldSearchCriteria.class.getSimpleName() + ": " + IdsSearchCriteria.class + ", identifiers provided should be of the same type.");
            }
        }
        switch (criterion.getFieldType()) {
            case ATTRIBUTE: {
                String fieldName = AttributesMapper.getColumnName(criterion.getFieldName(), tableMapper.getEntitiesTable(), criterion.getFieldName());
                Collection initialFieldValue = (Collection)criterion.getFieldValue();
                if (initialFieldValue != null) {
                    Collection fieldValue = !initialFieldValue.isEmpty() && initialFieldValue.stream().anyMatch(o -> o instanceof EntityTypePermId) ? (Collection)initialFieldValue.stream().map(o -> ((EntityTypePermId)o).getPermId()).collect(Collectors.toList()) : initialFieldValue;
                    if (tableMapper == TableMapper.SAMPLE) {
                        CodeSearchConditionTranslator.buildCodeQueryForSamples(sqlBuilder, () -> {
                            sqlBuilder.append(" ").append("IN").append(" ").append("(SELECT UNNEST(?))");
                            args.add(fieldValue.toArray(ARRAY_CASTING.get(criterion.getClass())));
                        });
                        break;
                    }
                    sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append((Object)fieldName).append(" ").append("IN").append(" ").append("(").append("SELECT").append(" ").append("UNNEST").append("(").append('?').append(")").append(")");
                    args.add(fieldValue.toArray(ARRAY_CASTING.get(criterion.getClass())));
                    break;
                }
                sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append((Object)fieldName).append(" ").append("IS NOT NULL");
                break;
            }
            case PROPERTY: 
            case ANY_PROPERTY: 
            case ANY_FIELD: {
                throw new IllegalArgumentException("Field type " + criterion.getFieldType() + " is not supported");
            }
        }
    }

    static {
        ARRAY_CASTING.put(CodesSearchCriteria.class, new String[0]);
        ARRAY_CASTING.put(UserIdsSearchCriteria.class, new String[0]);
        ARRAY_CASTING.put(IdsSearchCriteria.class, new String[0]);
    }
}

