/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractDateObjectValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractDateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IDate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ITimeZone;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ModificationDateSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.RegistrationDateSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.TimeZone;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.DataType;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.PSQLTypes;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.AttributesMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SQLLexemes;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IAliasFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.TranslatorUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.util.List;
import java.util.Map;

public class DateFieldSearchConditionTranslator
implements IConditionTranslator<DateFieldSearchCriteria> {
    @Override
    public Map<String, JoinInformation> getJoinInformationMap(DateFieldSearchCriteria criterion, TableMapper tableMapper, IAliasFactory aliasFactory) {
        switch (criterion.getFieldType()) {
            case ATTRIBUTE: {
                return null;
            }
            case ANY_PROPERTY: 
            case PROPERTY: {
                return TranslatorUtils.getPropertyJoinInformationMap(tableMapper, aliasFactory);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void translate(DateFieldSearchCriteria criterion, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, Map<String, String> dataTypeByPropertyCode) {
        switch (criterion.getFieldType()) {
            case ATTRIBUTE: {
                IDate value = (IDate)criterion.getFieldValue();
                ITimeZone timeZone = criterion.getTimeZone();
                boolean bareDateValue = value instanceof AbstractDateValue && TranslatorUtils.isDateWithoutTime((String)((AbstractDateValue)value).getValue());
                String fieldName = criterion.getFieldName();
                if (bareDateValue) {
                    sqlBuilder.append("(");
                }
                sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".");
                if (criterion instanceof RegistrationDateSearchCriteria) {
                    sqlBuilder.append("registration_timestamp");
                } else if (criterion instanceof ModificationDateSearchCriteria) {
                    sqlBuilder.append("modification_timestamp");
                } else {
                    String columnName = AttributesMapper.getColumnName(fieldName, tableMapper.getEntitiesTable(), fieldName);
                    sqlBuilder.append(columnName);
                }
                sqlBuilder.append(" ");
                TranslatorUtils.appendTimeZoneConversion(value, sqlBuilder, timeZone);
                if (bareDateValue) {
                    sqlBuilder.append(")").append("::").append((Object)PSQLTypes.DATE);
                }
                sqlBuilder.append(" ");
                TranslatorUtils.appendDateComparatorOp(value, sqlBuilder, args, bareDateValue);
                break;
            }
            case PROPERTY: {
                DateFieldSearchConditionTranslator.translateDateProperty(criterion, tableMapper, args, sqlBuilder, aliases, dataTypeByPropertyCode, false);
                break;
            }
            case ANY_PROPERTY: {
                DateFieldSearchConditionTranslator.translateDateProperty(criterion, tableMapper, args, sqlBuilder, aliases, dataTypeByPropertyCode, true);
                break;
            }
            case ANY_FIELD: {
                throw new IllegalArgumentException("Field type " + criterion.getFieldType() + " is not supported");
            }
        }
    }

    private static void translateDateProperty(DateFieldSearchCriteria criterion, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, Map<String, String> dataTypeByPropertyCode, boolean isAnyProperty) {
        String fullPropertyName = isAnyProperty ? null : criterion.getFieldName();
        IDate value = (IDate)criterion.getFieldValue();
        ITimeZone timeZone = criterion.getTimeZone();
        boolean bareDateValue = value instanceof AbstractDateValue && TranslatorUtils.isDateWithoutTime((String)((AbstractDateValue)value).getValue());
        JoinInformation joinInformation = aliases.get(tableMapper.getAttributeTypesTable());
        String entityTypesSubTableAlias = joinInformation.getSubTableAlias();
        sqlBuilder.append(entityTypesSubTableAlias).append(".").append(joinInformation.getSubTableIdField()).append(" ").append("IS NOT NULL").append(" ").append("AND").append(" ").append("(");
        sqlBuilder.append("CASE");
        String casting = dataTypeByPropertyCode.get(fullPropertyName);
        if (fullPropertyName == null) {
            if (value != null) {
                if (value instanceof AbstractDateObjectValue) {
                    DateFieldSearchConditionTranslator.appendWhenForDateOrTimestampProperties(sqlBuilder, args, tableMapper, value, aliases, timeZone, null, entityTypesSubTableAlias, true, DataType.DATE.toString());
                    DateFieldSearchConditionTranslator.appendWhenForDateOrTimestampProperties(sqlBuilder, args, tableMapper, value, aliases, timeZone, null, entityTypesSubTableAlias, false, DataType.TIMESTAMP.toString());
                } else if (bareDateValue) {
                    DateFieldSearchConditionTranslator.appendWhenForDateOrTimestampProperties(sqlBuilder, args, tableMapper, value, aliases, timeZone, null, entityTypesSubTableAlias, true, DataType.DATE.toString(), DataType.TIMESTAMP.toString());
                } else {
                    DateFieldSearchConditionTranslator.appendWhenForDateOrTimestampProperties(sqlBuilder, args, tableMapper, value, aliases, timeZone, null, entityTypesSubTableAlias, false, DataType.TIMESTAMP.toString());
                }
            } else {
                DateFieldSearchConditionTranslator.appendWhenForDateOrTimestampProperties(sqlBuilder, args, tableMapper, value, aliases, timeZone, null, entityTypesSubTableAlias, false, DataType.TIMESTAMP.toString(), DataType.DATE.toString());
            }
        } else if (DataType.DATE.toString().equals(casting)) {
            if (timeZone instanceof TimeZone) {
                throw new UserFailureException(String.format("Search criteria with time zone doesn't make sense for property %s of data type %s.", fullPropertyName, DataType.DATE));
            }
            DateFieldSearchConditionTranslator.appendWhenForDateOrTimestampProperties(sqlBuilder, args, tableMapper, value, aliases, null, fullPropertyName, entityTypesSubTableAlias, true, DataType.DATE.toString());
        } else if (DataType.TIMESTAMP.toString().equals(casting)) {
            DateFieldSearchConditionTranslator.appendWhenForDateOrTimestampProperties(sqlBuilder, args, tableMapper, value, aliases, timeZone, fullPropertyName, entityTypesSubTableAlias, bareDateValue, DataType.TIMESTAMP.toString());
        } else {
            throw new UserFailureException(String.format("Property %s is neither of data type %s nor %s.", fullPropertyName, DataType.DATE, DataType.TIMESTAMP));
        }
        sqlBuilder.append(" ").append("ELSE").append(" ").append(false).append(" ").append("END").append(")");
    }

    static void appendWhenForDateOrTimestampProperties(StringBuilder sqlBuilder, List<Object> args, TableMapper tableMapper, IDate value, Map<String, JoinInformation> aliases, ITimeZone timeZone, String fullPropertyName, String entityTypesSubTableAlias, boolean castToDate, String ... dataTypeStrings) {
        sqlBuilder.append(" ").append("WHEN").append(" ");
        if (fullPropertyName != null) {
            TranslatorUtils.appendInternalExternalConstraint(sqlBuilder, args, entityTypesSubTableAlias, TranslatorUtils.isPropertyInternal(fullPropertyName));
            sqlBuilder.append(" ").append("AND").append(" ");
            sqlBuilder.append(aliases.get(tableMapper.getAttributeTypesTable()).getSubTableAlias()).append(".").append("code").append(" ").append("=").append(" ").append('?');
            sqlBuilder.append(" ").append("AND");
            args.add(TranslatorUtils.normalisePropertyName(fullPropertyName));
        }
        sqlBuilder.append(" ").append(aliases.get("data_types").getSubTableAlias()).append(".").append("code").append(" ").append("IN").append(" ").append("(SELECT UNNEST(?))");
        args.add(dataTypeStrings);
        sqlBuilder.append(" ").append("THEN").append(" ");
        if (castToDate) {
            sqlBuilder.append("(");
        }
        if (value != null) {
            sqlBuilder.append(aliases.get(tableMapper.getValuesTable()).getSubTableAlias()).append(".").append("value").append("::").append((Object)PSQLTypes.TIMESTAMP_WITH_TZ).append(" ");
            TranslatorUtils.appendTimeZoneConversion(value, sqlBuilder, timeZone);
            if (castToDate) {
                sqlBuilder.append(")").append("::").append((Object)PSQLTypes.DATE).append(" ");
            }
            TranslatorUtils.appendDateComparatorOp(value, sqlBuilder, args, castToDate);
        } else {
            sqlBuilder.append(SQLLexemes.TRUE);
        }
    }
}

