/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.ObjectIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.id.MaterialPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.id.SemanticAnnotationPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.TagCode;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.TagPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.FullSampleIdentifier;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.SampleIdentifierParts;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IAliasFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.TranslatorUtils;
import java.util.List;
import java.util.Map;

public class IdSearchConditionTranslator
implements IConditionTranslator<IdSearchCriteria<?>> {
    @Override
    public Map<String, JoinInformation> getJoinInformationMap(IdSearchCriteria<?> criterion, TableMapper tableMapper, IAliasFactory aliasFactory) {
        if (criterion.getId().getClass() == MaterialPermId.class) {
            return TranslatorUtils.getTypeJoinInformationMap(tableMapper, aliasFactory);
        }
        return null;
    }

    @Override
    public void translate(IdSearchCriteria<?> criterion, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, Map<String, String> dataTypeByPropertyCode) {
        IObjectId entityId = criterion.getId();
        if (entityId instanceof ObjectIdentifier || entityId.getClass() == TagPermId.class) {
            FullSampleIdentifier fullObjectIdentifier = new FullSampleIdentifier(entityId.getClass() == TagPermId.class ? ((TagPermId)entityId).getPermId() : ((ObjectIdentifier)entityId).getIdentifier(), null);
            String objectCode = fullObjectIdentifier.getSampleCode();
            SampleIdentifierParts identifierParts = fullObjectIdentifier.getParts();
            String originalSpaceCode = identifierParts.getSpaceCodeOrNull();
            String spaceCode = originalSpaceCode == null || entityId.getClass() != TagPermId.class ? originalSpaceCode : originalSpaceCode.toLowerCase();
            String projectCode = identifierParts.getProjectCodeOrNull();
            String containerCode = identifierParts.getContainerCodeOrNull();
            String codeColumnName = "code";
            if (spaceCode != null || projectCode != null || containerCode != null) {
                sqlBuilder.append("(");
                if (spaceCode != null) {
                    if (entityId.getClass() == SampleIdentifier.class) {
                        IdSearchConditionTranslator.buildSelectByIdConditionWithSubquery(sqlBuilder, "space_id", "spaces", "code");
                    } else if (entityId.getClass() == ExperimentIdentifier.class) {
                        IdSearchConditionTranslator.buildSelectByIdConditionWithSubqueryExperiments(sqlBuilder);
                    } else if (entityId.getClass() == ProjectIdentifier.class) {
                        IdSearchConditionTranslator.buildSelectByIdConditionWithSubqueryProjects(sqlBuilder);
                    } else if (entityId.getClass() == TagPermId.class) {
                        IdSearchConditionTranslator.buildSelectByIdConditionWithSubquery(sqlBuilder, "owner", "persons", "user_id");
                        codeColumnName = "name";
                    } else {
                        throw new RuntimeException("Unsupported identifier: " + entityId.getClass());
                    }
                    sqlBuilder.append(" ").append("AND").append(" ");
                    args.add(spaceCode);
                }
                if (projectCode != null) {
                    IdSearchConditionTranslator.buildSelectByIdConditionWithSubquery(sqlBuilder, "proj_id", "IN", "projects", "code");
                    sqlBuilder.append(" ").append("AND").append(" ");
                    args.add(projectCode);
                }
                if (containerCode != null) {
                    IdSearchConditionTranslator.buildSelectByIdConditionWithSubquery(sqlBuilder, "samp_id_part_of", TableMapper.SAMPLE.getEntitiesTable(), "code");
                    sqlBuilder.append(" ").append("AND").append(" ");
                    args.add(containerCode);
                }
                sqlBuilder.setLength(sqlBuilder.length() - "AND".length() - " ".length() * 2);
                sqlBuilder.append(")").append(" ").append("AND").append(" ");
            }
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append(codeColumnName).append(" ").append("=").append(" ").append('?');
            args.add(objectCode);
        } else if (entityId.getClass() == SamplePermId.class) {
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("perm_id").append("=").append('?');
            args.add(((SamplePermId)entityId).getPermId());
        } else if (entityId.getClass() == ExperimentPermId.class) {
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("perm_id").append("=").append('?');
            args.add(((ExperimentPermId)entityId).getPermId());
        } else if (entityId.getClass() == DataSetPermId.class) {
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("code").append("=").append('?');
            args.add(((DataSetPermId)entityId).getPermId());
        } else if (entityId.getClass() == ProjectPermId.class) {
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("perm_id").append("=").append('?');
            args.add(((ProjectPermId)entityId).getPermId());
        } else if (entityId.getClass() == SpacePermId.class) {
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("code").append("=").append('?');
            args.add(((SpacePermId)entityId).getPermId());
        } else if (entityId.getClass() == EntityTypePermId.class) {
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("code").append("=").append('?');
            args.add(((EntityTypePermId)entityId).getPermId());
        } else if (entityId.getClass() == TagCode.class) {
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("name").append("=").append('?');
            args.add(((TagCode)entityId).getCode());
        } else if (entityId.getClass() == SemanticAnnotationPermId.class) {
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("perm_id").append("=").append('?');
            args.add(((SemanticAnnotationPermId)entityId).getPermId());
        } else if (entityId.getClass() == MaterialPermId.class) {
            String materialTypeTableAlias = aliases.get(tableMapper.getEntityTypesTable()).getSubTableAlias();
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("code").append("=").append('?').append(" ").append("AND").append(" ").append(materialTypeTableAlias).append(".").append("code").append("=").append('?');
            MaterialPermId materialPermId = (MaterialPermId)entityId;
            args.add(materialPermId.getCode());
            args.add(materialPermId.getTypeCode());
        } else if (entityId.getClass() == PropertyTypePermId.class) {
            sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("code").append("=").append('?');
            args.add(((PropertyTypePermId)entityId).getPermId());
        } else {
            throw new IllegalArgumentException("Unknown id: class " + entityId.getClass().getSimpleName());
        }
    }

    private static void buildSelectByIdConditionWithSubqueryProjects(StringBuilder sqlBuilder) {
        sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("space_id").append(" ").append("IN").append(" ").append("(").append("SELECT").append(" ").append("id").append(" ").append("FROM").append(" ").append("spaces").append(" ").append("WHERE").append(" ").append("code").append(" ").append("=").append(" ").append('?').append(")");
    }

    private static void buildSelectByIdConditionWithSubqueryExperiments(StringBuilder sqlBuilder) {
        String p = "p";
        String s = "s";
        sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("proj_id").append(" ").append("IN").append(" ").append("(").append("SELECT").append(" ").append("p").append(".").append("id").append(" ").append("FROM").append(" ").append("projects").append(" ").append("p").append(" ").append("LEFT JOIN").append(" ").append("spaces").append(" ").append("s").append(" ").append("ON").append(" ").append("s").append(".").append("id").append(" ").append("=").append(" ").append("p").append(".").append("space_id").append(" ").append("WHERE").append(" ").append("s").append(".").append("code").append(" ").append("=").append(" ").append('?').append(")");
    }

    private static void buildSelectByIdConditionWithSubquery(StringBuilder sqlBuilder, String columnName, String subqueryTable, String subqueryTableColumn) {
        IdSearchConditionTranslator.buildSelectByIdConditionWithSubquery(sqlBuilder, columnName, "=", subqueryTable, subqueryTableColumn);
    }

    private static void buildSelectByIdConditionWithSubquery(StringBuilder sqlBuilder, String columnName, String equalOrIn, String subqueryTable, String subqueryTableColumn) {
        sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append(columnName).append(" ").append(equalOrIn).append(" ").append("(").append("SELECT").append(" ").append("id").append(" ").append("FROM").append(" ").append(subqueryTable).append(" ").append("WHERE").append(" ").append(subqueryTableColumn).append(" ").append("=").append(" ").append('?').append(")");
    }
}

