/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdentifierSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IAliasFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.TranslatorUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class IdentifierSearchConditionTranslator
implements IConditionTranslator<IdentifierSearchCriteria> {
    private static final String UNIQUE_PREFIX = IdentifierSearchConditionTranslator.class.getName() + ":";

    @Override
    public Map<String, JoinInformation> getJoinInformationMap(IdentifierSearchCriteria criterion, TableMapper tableMapper, IAliasFactory aliasFactory) {
        LinkedHashMap<String, JoinInformation> result = new LinkedHashMap<String, JoinInformation>();
        TranslatorUtils.appendIdentifierJoinInformationMap(result, tableMapper, aliasFactory, UNIQUE_PREFIX);
        return result;
    }

    @Override
    public void translate(IdentifierSearchCriteria criterion, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, Map<String, String> dataTypeByPropertyCode) {
        IdentifierSearchConditionTranslator.doTranslate((AbstractFieldSearchCriteria<AbstractStringValue>)criterion, criterion.isUseWildcards(), tableMapper, args, sqlBuilder, aliases, UNIQUE_PREFIX);
    }

    static void doTranslate(AbstractFieldSearchCriteria<AbstractStringValue> criterion, boolean useWildcards, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, String prefix) {
        String samplesTableAlias;
        AbstractStringValue fieldValue = (AbstractStringValue)criterion.getFieldValue();
        String entitiesTable = tableMapper.getEntitiesTable();
        String samplesTableName = TableMapper.SAMPLE.getEntitiesTable();
        String projectsTableName = TableMapper.PROJECT.getEntitiesTable();
        String experimentsTableName = TableMapper.EXPERIMENT.getEntitiesTable();
        boolean hasSpaces = entitiesTable.equals(samplesTableName) || entitiesTable.equals(experimentsTableName) || entitiesTable.equals(projectsTableName);
        boolean hasProjects = entitiesTable.equals(samplesTableName) || entitiesTable.equals(experimentsTableName);
        String spacesTableAlias = hasSpaces ? aliases.get(prefix + "spaces").getSubTableAlias() : null;
        String projectsTableAlias = hasProjects ? aliases.get(prefix + "projects").getSubTableAlias() : null;
        String string = samplesTableAlias = entitiesTable.equals(samplesTableName) ? aliases.get(prefix + entitiesTable).getSubTableAlias() : null;
        if (tableMapper != TableMapper.SAMPLE) {
            TranslatorUtils.buildFullIdentifierConcatenationString(sqlBuilder, spacesTableAlias, projectsTableAlias, samplesTableAlias, true);
        } else {
            sqlBuilder.append("LOWER").append("(").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("sample_identifier").append(")");
        }
        TranslatorUtils.appendStringComparatorOp(fieldValue.getClass(), ((String)fieldValue.getValue()).toLowerCase(), useWildcards, sqlBuilder, args);
    }
}

