/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NameSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IAliasFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinType;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.TranslatorUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NameSearchConditionTranslator
implements IConditionTranslator<NameSearchCriteria> {
    @Override
    public Map<String, JoinInformation> getJoinInformationMap(NameSearchCriteria criterion, TableMapper tableMapper, IAliasFactory aliasFactory) {
        LinkedHashMap<String, JoinInformation> result = new LinkedHashMap<String, JoinInformation>();
        JoinInformation joinInformation = new JoinInformation();
        joinInformation.setJoinType(JoinType.LEFT);
        joinInformation.setMainTable(tableMapper.getEntitiesTable());
        joinInformation.setMainTableAlias(SearchCriteriaTranslator.MAIN_TABLE_ALIAS);
        joinInformation.setMainTableIdField("owner");
        joinInformation.setSubTable("persons");
        joinInformation.setSubTableAlias(aliasFactory.createAlias());
        joinInformation.setSubTableIdField("id");
        result.put("persons", joinInformation);
        return result;
    }

    @Override
    public void translate(NameSearchCriteria criterion, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, Map<String, String> dataTypeByPropertyCode) {
        switch (criterion.getFieldType()) {
            case ATTRIBUTE: {
                AbstractStringValue value = (AbstractStringValue)criterion.getFieldValue();
                if (value != null && value.getValue() != null) {
                    String stringValue = (String)value.getValue();
                    sqlBuilder.append("CONCAT").append("(").append("'").append('/').append("'").append(",").append(" ").append("UPPER").append("(").append(aliases.get("persons").getSubTableAlias()).append(".").append("user_id").append(")").append(",").append(" ").append("'").append('/').append("'").append(",").append(" ").append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("name").append(")");
                    TranslatorUtils.appendStringComparatorOp(value.getClass(), stringValue.toUpperCase(), criterion.isUseWildcards(), sqlBuilder, args);
                    break;
                }
                sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("name").append(" ").append("IS NOT NULL");
                break;
            }
            case PROPERTY: 
            case ANY_PROPERTY: 
            case ANY_FIELD: {
                throw new IllegalArgumentException();
            }
        }
    }
}

