/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractNumberValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.PSQLTypes;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.AttributesMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IAliasFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.TranslatorUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NumberFieldSearchConditionTranslator
implements IConditionTranslator<NumberFieldSearchCriteria> {
    private static final String INTEGER_DATA_TYPE_CODE = DataTypeCode.INTEGER.toString();
    private static final String REAL_DATA_TYPE_CODE = DataTypeCode.REAL.toString();
    private static final Set<String> VALID_DATA_TYPES = new HashSet<String>(Arrays.asList(INTEGER_DATA_TYPE_CODE, REAL_DATA_TYPE_CODE));

    @Override
    public Map<String, JoinInformation> getJoinInformationMap(NumberFieldSearchCriteria criterion, TableMapper tableMapper, IAliasFactory aliasFactory) {
        switch (criterion.getFieldType()) {
            case ATTRIBUTE: {
                return null;
            }
            case PROPERTY: 
            case ANY_PROPERTY: {
                return TranslatorUtils.getPropertyJoinInformationMap(tableMapper, aliasFactory);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void translate(NumberFieldSearchCriteria criterion, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, Map<String, String> dataTypeByPropertyCode) {
        switch (criterion.getFieldType()) {
            case ATTRIBUTE: {
                String criterionFieldName = criterion.getFieldName();
                String columnName = AttributesMapper.getColumnName(criterionFieldName, tableMapper.getValuesTable(), criterion.getFieldName());
                AbstractNumberValue value = (AbstractNumberValue)criterion.getFieldValue();
                sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append(columnName).append(" ");
                TranslatorUtils.appendNumberComparatorOp(value, sqlBuilder);
                sqlBuilder.append("\n");
                args.add(value.getValue());
                break;
            }
            case PROPERTY: {
                AbstractNumberValue value = (AbstractNumberValue)criterion.getFieldValue();
                String casting = dataTypeByPropertyCode.get(criterion.getFieldName());
                if (!VALID_DATA_TYPES.contains(casting)) {
                    throw new UserFailureException("The data type of property " + criterion.getFieldName() + " has to be one of " + VALID_DATA_TYPES + " instead of " + casting + ".");
                }
                NumberFieldSearchConditionTranslator.translateNumberProperty(tableMapper, args, sqlBuilder, aliases, value, criterion.getFieldName());
                break;
            }
            case ANY_PROPERTY: {
                AbstractNumberValue value = (AbstractNumberValue)criterion.getFieldValue();
                NumberFieldSearchConditionTranslator.translateNumberProperty(tableMapper, args, sqlBuilder, aliases, value, null);
                break;
            }
            case ANY_FIELD: {
                throw new IllegalArgumentException();
            }
        }
    }

    static void translateNumberProperty(TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, AbstractNumberValue value, String fullPropertyName) {
        JoinInformation attributeTypesJoinInformation = aliases.get(tableMapper.getAttributeTypesTable());
        String entityTypesSubTableAlias = attributeTypesJoinInformation.getSubTableAlias();
        sqlBuilder.append(entityTypesSubTableAlias).append(".").append(attributeTypesJoinInformation.getSubTableIdField()).append(" ").append("IS NOT NULL").append(" ").append("AND").append(" ").append("(");
        if (value != null) {
            sqlBuilder.append("CASE").append(" ").append("WHEN").append(" ");
        }
        if (fullPropertyName != null) {
            TranslatorUtils.appendInternalExternalConstraint(sqlBuilder, args, entityTypesSubTableAlias, TranslatorUtils.isPropertyInternal(fullPropertyName));
            sqlBuilder.append(" ").append("AND").append(" ").append(attributeTypesJoinInformation.getSubTableAlias()).append(".").append("code").append(" ").append("=").append(" ").append('?');
            args.add(TranslatorUtils.normalisePropertyName(fullPropertyName));
            sqlBuilder.append(" ").append("AND");
        }
        sqlBuilder.append(" ").append("(");
        sqlBuilder.append(aliases.get("data_types").getSubTableAlias()).append(".").append("code").append(" ").append("=").append(" ").append('?');
        args.add(DataTypeCode.INTEGER.toString());
        sqlBuilder.append(" ").append("OR").append(" ");
        sqlBuilder.append(aliases.get("data_types").getSubTableAlias()).append(".").append("code").append(" ").append("=").append(" ").append('?');
        args.add(DataTypeCode.REAL.toString());
        sqlBuilder.append(")");
        if (value != null) {
            sqlBuilder.append(" ").append("THEN").append(" ");
            sqlBuilder.append(aliases.get(tableMapper.getValuesTable()).getSubTableAlias()).append(".").append("value").append("::").append(PSQLTypes.NUMERIC.toString()).append(" ");
            TranslatorUtils.appendNumberComparatorOp(value, sqlBuilder);
            args.add(value.getValue());
            sqlBuilder.append(" ").append("ELSE").append(" ").append(false).append(" ").append("END");
        }
        sqlBuilder.append(")");
    }
}

