/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractNumberValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AnyStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateEarlierThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateEarlierThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateLaterThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateLaterThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IDate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberGreaterThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberGreaterThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberLessThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberLessThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringContainsExactlyValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringContainsValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringEndsWithValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringGreaterThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringGreaterThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringLessThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringLessThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringMatchesValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringStartsWithValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.DataType;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.PSQLTypes;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.AttributesMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SQLLexemes;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.BooleanFieldSearchConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.DateFieldSearchConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IAliasFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.NumberFieldSearchConditionTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.TranslatorUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StringFieldSearchConditionTranslator
implements IConditionTranslator<StringFieldSearchCriteria> {
    private static final Map<Class<? extends AbstractStringValue>, String> OPERATOR_NAME_BY_CLASS = new HashMap<Class<? extends AbstractStringValue>, String>();

    @Override
    public Map<String, JoinInformation> getJoinInformationMap(StringFieldSearchCriteria criterion, TableMapper tableMapper, IAliasFactory aliasFactory) {
        switch (criterion.getFieldType()) {
            case ATTRIBUTE: {
                return null;
            }
            case PROPERTY: 
            case ANY_PROPERTY: {
                return TranslatorUtils.getPropertyJoinInformationMap(tableMapper, aliasFactory);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void translate(StringFieldSearchCriteria criterion, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, Map<String, String> dataTypeByPropertyCode) {
        switch (criterion.getFieldType()) {
            case ATTRIBUTE: {
                String criterionFieldName = criterion.getFieldName();
                String columnName = AttributesMapper.getColumnName(criterionFieldName, tableMapper.getEntitiesTable(), criterionFieldName);
                AbstractStringValue value = (AbstractStringValue)criterion.getFieldValue();
                StringFieldSearchConditionTranslator.normalizeValue(value, columnName);
                TranslatorUtils.translateStringComparison(SearchCriteriaTranslator.MAIN_TABLE_ALIAS, columnName, value, criterion.isUseWildcards(), PSQLTypes.VARCHAR, sqlBuilder, args);
                break;
            }
            case PROPERTY: {
                AbstractStringValue value = (AbstractStringValue)criterion.getFieldValue();
                StringFieldSearchConditionTranslator.translateStringProperty(criterion, tableMapper, args, sqlBuilder, aliases, dataTypeByPropertyCode, value, criterion.getFieldName());
                break;
            }
            case ANY_PROPERTY: {
                AbstractStringValue value = (AbstractStringValue)criterion.getFieldValue();
                StringFieldSearchConditionTranslator.translateStringProperty(criterion, tableMapper, args, sqlBuilder, aliases, dataTypeByPropertyCode, value, null);
                break;
            }
            case ANY_FIELD: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static void translateStringProperty(StringFieldSearchCriteria criterion, TableMapper tableMapper, List<Object> args, StringBuilder sqlBuilder, Map<String, JoinInformation> aliases, Map<String, String> dataTypeByPropertyCode, AbstractStringValue value, String fullPropertyName) {
        String casting;
        JoinInformation joinInformation = aliases.get(tableMapper.getAttributeTypesTable());
        String entityTypesSubTableAlias = joinInformation.getSubTableAlias();
        sqlBuilder.append(entityTypesSubTableAlias).append(".").append(joinInformation.getSubTableIdField()).append(" ").append("IS NOT NULL");
        if (fullPropertyName == null) {
            sqlBuilder.append(" ").append("AND").append(" ");
            sqlBuilder.append(aliases.get("data_types").getSubTableAlias()).append(".").append("code").append(" ").append("IN").append(" ").append("(").append("'").append(DataTypeCode.VARCHAR).append("'").append(",").append(" ").append("'").append(DataTypeCode.MULTILINE_VARCHAR).append("'").append(",").append(" ").append("'").append(DataTypeCode.HYPERLINK).append("'").append(",").append(" ").append("'").append(DataTypeCode.XML).append("'").append(")");
        }
        sqlBuilder.append(" ").append("AND").append(" ").append("(");
        if (!(value instanceof AnyStringValue)) {
            casting = dataTypeByPropertyCode.get(fullPropertyName);
            if (casting != null) {
                StringFieldSearchConditionTranslator.verifyCriterionValidity(criterion, value, casting);
                if (casting.equals(DataTypeCode.BOOLEAN.toString())) {
                    BooleanFieldSearchConditionTranslator.translateBooleanProperty(tableMapper, args, sqlBuilder, aliases, StringFieldSearchConditionTranslator.convertStringValueToBooleanValue(value), fullPropertyName);
                    sqlBuilder.append(")");
                    return;
                }
                if (casting.equals(DataTypeCode.INTEGER.toString()) || casting.equals(DataTypeCode.REAL.toString())) {
                    NumberFieldSearchConditionTranslator.translateNumberProperty(tableMapper, args, sqlBuilder, aliases, StringFieldSearchConditionTranslator.convertStringValueToNumberValue(value), fullPropertyName);
                    sqlBuilder.append(")");
                    return;
                }
                if (casting.equals(DataTypeCode.TIMESTAMP.toString()) || casting.equals(DataTypeCode.DATE.toString())) {
                    DataType dataType = casting.equals(DataTypeCode.TIMESTAMP.toString()) ? DataType.TIMESTAMP : DataType.DATE;
                    boolean bareDateValue = TranslatorUtils.isDateWithoutTime((String)value.getValue());
                    sqlBuilder.append("CASE");
                    DateFieldSearchConditionTranslator.appendWhenForDateOrTimestampProperties(sqlBuilder, args, tableMapper, StringFieldSearchConditionTranslator.convertStringValueToDateValue(value), aliases, null, fullPropertyName, entityTypesSubTableAlias, bareDateValue, dataType.toString());
                    sqlBuilder.append(" ").append("END");
                    sqlBuilder.append(")");
                    return;
                }
            }
            sqlBuilder.append("CASE").append(" ").append("WHEN").append(" ");
            TranslatorUtils.appendInternalExternalConstraint(sqlBuilder, args, entityTypesSubTableAlias, TranslatorUtils.isPropertyInternal(criterion.getFieldName()));
            if (fullPropertyName != null) {
                sqlBuilder.append(" ").append("AND").append(" ");
            }
        } else {
            casting = null;
        }
        if (fullPropertyName != null) {
            sqlBuilder.append(entityTypesSubTableAlias).append(".").append("code").append(" ").append("=").append(" ").append('?');
            args.add(TranslatorUtils.normalisePropertyName(fullPropertyName));
        } else if (value instanceof AnyStringValue) {
            TranslatorUtils.appendPropertyValueCoalesce(sqlBuilder, tableMapper, aliases);
            sqlBuilder.append(" ").append("IS NOT NULL");
        }
        boolean useWildcards = criterion.isUseWildcards();
        if (!(value instanceof AnyStringValue)) {
            sqlBuilder.append(" ").append("THEN").append("\n");
            if (value.getClass() != StringMatchesValue.class) {
                sqlBuilder.append("CASE");
                if (fullPropertyName != null) {
                    sqlBuilder.append("\n").append("WHEN").append(" ").append(aliases.get("data_types").getSubTableAlias()).append(".").append("code").append(" ").append("=").append(" ").append("'").append(DataTypeCode.CONTROLLEDVOCABULARY).append("'").append(" ").append("THEN").append(" ");
                    TranslatorUtils.translateStringComparison(aliases.get("controlled_vocabulary_terms").getSubTableAlias(), "code", value, useWildcards, null, sqlBuilder, args);
                }
                String materialsTableAlias = aliases.get("materials").getSubTableAlias();
                sqlBuilder.append("\n").append("WHEN").append(" ").append(materialsTableAlias).append(".").append("code").append(" ").append("IS NOT NULL").append(" ").append("THEN").append(" ");
                TranslatorUtils.translateStringComparison(materialsTableAlias, "code", value, useWildcards, null, sqlBuilder, args);
                JoinInformation samplesPropertyTable = aliases.get("samp_prop_id");
                if (samplesPropertyTable != null) {
                    sqlBuilder.append("\n").append("WHEN").append(" ").append(samplesPropertyTable.getSubTableAlias()).append(".").append("code").append(" ").append("IS NOT NULL").append(" ").append("THEN").append(" ");
                    TranslatorUtils.translateStringComparison(samplesPropertyTable.getSubTableAlias(), "code", value, useWildcards, null, sqlBuilder, args);
                    sqlBuilder.append(" ").append("OR").append(" ");
                    TranslatorUtils.translateStringComparison(samplesPropertyTable.getSubTableAlias(), "perm_id", value, useWildcards, null, sqlBuilder, args);
                    sqlBuilder.append(" ").append("OR").append(" ");
                    TranslatorUtils.translateStringComparison(samplesPropertyTable.getSubTableAlias(), "sample_identifier", value, useWildcards, null, sqlBuilder, args);
                }
                sqlBuilder.append("\n").append("ELSE").append(" ");
                if (casting != null) {
                    boolean equalsToComparison;
                    boolean bl = equalsToComparison = value.getClass() == StringEqualToValue.class;
                    if (equalsToComparison) {
                        sqlBuilder.append("LOWER").append("(");
                    }
                    sqlBuilder.append(aliases.get(tableMapper.getValuesTable()).getSubTableAlias()).append(".").append("value");
                    if (equalsToComparison) {
                        sqlBuilder.append(")");
                    }
                    String strippedValue = TranslatorUtils.stripQuotationMarks((String)value.getValue()).toLowerCase();
                    TranslatorUtils.appendStringComparatorOp(value.getClass(), strippedValue, useWildcards, sqlBuilder, args);
                } else {
                    TranslatorUtils.translateStringComparison(aliases.get(tableMapper.getValuesTable()).getSubTableAlias(), "value", value, useWildcards, null, sqlBuilder, args);
                }
                sqlBuilder.append("\n").append("END");
            } else {
                TranslatorUtils.appendTsVectorMatch(sqlBuilder, (AbstractStringValue)criterion.getFieldValue(), aliases.get(tableMapper.getValuesTable()).getSubTableAlias(), args);
            }
            sqlBuilder.append("\n").append("ELSE").append(" ").append(SQLLexemes.FALSE).append("\n").append("END");
        }
        sqlBuilder.append(")");
    }

    private static void verifyCriterionValidity(StringFieldSearchCriteria criterion, AbstractStringValue value, String casting) {
        AbstractStringValue fieldValue = (AbstractStringValue)criterion.getFieldValue();
        if ((fieldValue instanceof StringStartsWithValue || fieldValue instanceof StringEndsWithValue || fieldValue instanceof StringContainsValue || fieldValue instanceof StringContainsExactlyValue) && (casting.equals(DataTypeCode.INTEGER.toString()) || casting.equals(DataTypeCode.REAL.toString()) || casting.equals(DataTypeCode.TIMESTAMP.toString()) || casting.equals(DataTypeCode.DATE.toString()) || casting.equals(DataTypeCode.BOOLEAN.toString()))) {
            throw new UserFailureException(String.format("Operator %s undefined for datatype %s.", OPERATOR_NAME_BY_CLASS.get(value.getClass()), casting));
        }
        if ((fieldValue instanceof StringLessThanValue || fieldValue instanceof StringLessThanOrEqualToValue || fieldValue instanceof StringGreaterThanOrEqualToValue || fieldValue instanceof StringGreaterThanValue) && casting.equals(DataTypeCode.BOOLEAN.toString())) {
            throw new UserFailureException(String.format("Operator %s undefined for datatype %s.", OPERATOR_NAME_BY_CLASS.get(value.getClass()), casting));
        }
    }

    private static IDate convertStringValueToDateValue(AbstractStringValue stringValue) {
        String value = (String)stringValue.getValue();
        try {
            TranslatorUtils.parseDate(value);
        }
        catch (IllegalArgumentException e) {
            throw new UserFailureException(String.format("String does not represent a date: [%s]", value));
        }
        if (stringValue instanceof StringEqualToValue) {
            return new DateEqualToValue(value);
        }
        if (stringValue instanceof StringLessThanOrEqualToValue) {
            return new DateEarlierThanOrEqualToValue(value);
        }
        if (stringValue instanceof StringGreaterThanOrEqualToValue) {
            return new DateLaterThanOrEqualToValue(value);
        }
        if (stringValue instanceof StringLessThanValue) {
            return new DateEarlierThanValue(value);
        }
        if (stringValue instanceof StringGreaterThanValue) {
            return new DateLaterThanValue(value);
        }
        throw new IllegalArgumentException(String.format("Cannot convert string value of class %s to date value", stringValue.getClass()));
    }

    private static boolean convertStringValueToBooleanValue(AbstractStringValue stringValue) {
        String value = (String)stringValue.getValue();
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        throw new UserFailureException(String.format("String does not represent a boolean: [%s]", value));
    }

    private static AbstractNumberValue convertStringValueToNumberValue(AbstractStringValue stringValue) {
        Number numberValue;
        String value = (String)stringValue.getValue();
        try {
            numberValue = Long.parseLong(value);
        }
        catch (NumberFormatException e1) {
            try {
                numberValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e2) {
                throw new UserFailureException(String.format("String does not represent a number: [%s]", value));
            }
        }
        if (stringValue instanceof StringEqualToValue) {
            return new NumberEqualToValue(numberValue);
        }
        if (stringValue instanceof StringLessThanOrEqualToValue) {
            return new NumberLessThanOrEqualToValue(numberValue);
        }
        if (stringValue instanceof StringGreaterThanOrEqualToValue) {
            return new NumberGreaterThanOrEqualToValue(numberValue);
        }
        if (stringValue instanceof StringLessThanValue) {
            return new NumberLessThanValue(numberValue);
        }
        if (stringValue instanceof StringGreaterThanValue) {
            return new NumberGreaterThanValue(numberValue);
        }
        throw new IllegalArgumentException(String.format("Cannot convert string value of class %s to number value", stringValue.getClass()));
    }

    private static void normalizeValue(AbstractStringValue value, String columnName) {
        if (columnName.equals("code") && ((String)value.getValue()).startsWith("/")) {
            value.setValue((Object)((String)value.getValue()).substring(1));
        }
    }

    static {
        OPERATOR_NAME_BY_CLASS.put(StringContainsExactlyValue.class, "ContainsExactly");
        OPERATOR_NAME_BY_CLASS.put(StringContainsValue.class, "Contains");
        OPERATOR_NAME_BY_CLASS.put(StringEndsWithValue.class, "EndsWith");
        OPERATOR_NAME_BY_CLASS.put(StringEqualToValue.class, "EqualTo");
        OPERATOR_NAME_BY_CLASS.put(StringGreaterThanOrEqualToValue.class, "GreaterThanOrEqualTo");
        OPERATOR_NAME_BY_CLASS.put(StringGreaterThanValue.class, "GreaterThan");
        OPERATOR_NAME_BY_CLASS.put(StringLessThanOrEqualToValue.class, "LessThanOrEqualTo");
        OPERATOR_NAME_BY_CLASS.put(StringLessThanValue.class, "LessThan");
        OPERATOR_NAME_BY_CLASS.put(StringStartsWithValue.class, "StartsWith");
    }
}

