/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils;

import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.SampleIdentifierParts;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class FullEntityIdentifier {
    private SampleIdentifierParts entityIdentifierParts;
    private String entityCode;

    public FullEntityIdentifier(String entityIdentifier, String homeSpaceCodeOrNull) {
        String plainEntityCode;
        List<String> splitCode;
        String code;
        String[] parts = this.extractParts(entityIdentifier.startsWith("/") ? entityIdentifier : "/" + entityIdentifier);
        String spaceCode = null;
        String projectCode = null;
        String containerCode = null;
        if (parts.length == 2) {
            code = parts[1];
        } else if (parts.length == 3) {
            spaceCode = parts[1];
            code = parts[2];
        } else {
            spaceCode = parts[1];
            projectCode = parts[2];
            code = parts[3];
        }
        if (spaceCode != null && spaceCode.isEmpty() && homeSpaceCodeOrNull != null) {
            spaceCode = homeSpaceCodeOrNull;
        }
        if ((splitCode = this.splitCode(code, entityIdentifier)).size() == 2) {
            containerCode = splitCode.get(0);
            plainEntityCode = splitCode.get(1);
        } else {
            plainEntityCode = splitCode.get(0);
        }
        this.verifyCodePattern(spaceCode, "Space code");
        this.verifyCodePattern(projectCode, "Project code");
        this.verifyCodePattern(containerCode, "Container entity code");
        this.verifyCodePattern(plainEntityCode, containerCode == null ? "Entity code" : "Entity subcode");
        this.entityCode = CodeConverter.tryToDatabase(plainEntityCode);
        this.entityIdentifierParts = new SampleIdentifierParts(CodeConverter.tryToDatabase(spaceCode), CodeConverter.tryToDatabase(projectCode), CodeConverter.tryToDatabase(containerCode));
    }

    private List<String> splitCode(String code, String entityIdentifier) {
        String delim = ":";
        StringTokenizer tokenizer = new StringTokenizer(code, delim, true);
        int numberOfDelims = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (delim.equals(token)) {
                ++numberOfDelims;
                continue;
            }
            tokens.add(token);
        }
        if (numberOfDelims > 1) {
            throw new IllegalArgumentException("Entity code can not contain more than one '" + delim + "': " + entityIdentifier);
        }
        if (numberOfDelims != tokens.size() - 1) {
            throw new IllegalArgumentException("Entity code starts or ends with '" + delim + "': " + entityIdentifier);
        }
        return tokens;
    }

    private String[] extractParts(String entityIdentifier) {
        if (StringUtils.isBlank((CharSequence)entityIdentifier)) {
            throw new IllegalArgumentException("Unspecified entity identifier.");
        }
        String[] parts = entityIdentifier.split("/");
        if (parts.length == 0) {
            throw new IllegalArgumentException("Entity identifier don't contain any codes: " + entityIdentifier);
        }
        if (parts.length > 4) {
            throw new IllegalArgumentException("Entity identifier can not contain more than three '/': " + entityIdentifier);
        }
        return parts;
    }

    private void verifyCodePattern(String code, String partName) {
        if (code == null) {
            return;
        }
        if (code.length() == 0) {
            throw new IllegalArgumentException(partName + " can not be an empty string.");
        }
    }

    public SampleIdentifierParts getParts() {
        return this.entityIdentifierParts;
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String projectCode = this.entityIdentifierParts.getProjectCodeOrNull();
        String spaceCode = this.entityIdentifierParts.getSpaceCodeOrNull();
        String containerCode = this.entityIdentifierParts.getContainerCodeOrNull();
        if (projectCode != null) {
            sb.append('/').append(projectCode);
        }
        if (spaceCode != null) {
            sb.append('/').append(spaceCode);
        }
        if (projectCode != null || spaceCode != null) {
            sb.append('/');
        }
        if (containerCode != null) {
            sb.append(containerCode).append(':');
        }
        sb.append(this.entityCode);
        return sb.toString();
    }
}

