/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractDateObjectValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractDateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractNumberValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AnyStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateEarlierThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateEarlierThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateLaterThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateLaterThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectEarlierThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectEarlierThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectLaterThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectLaterThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IDate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ITimeZone;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.LongDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NormalDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberGreaterThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberGreaterThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberLessThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberLessThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ShortDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringContainsExactlyValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringContainsValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringEndsWithValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringGreaterThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringGreaterThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringLessThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringLessThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringStartsWithValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.TimeZone;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.PSQLTypes;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.mapper.TableMapper;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.GlobalSearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.SearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.IAliasFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.translator.condition.utils.JoinType;
import java.text.ParseException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class TranslatorUtils {
    public static final String REGISTRATOR_JOIN_INFORMATION_KEY = "registrator";
    public static final String MODIFIER_JOIN_INFORMATION_KEY = "modifier";
    public static final String ENTITY_TYPE_JOIN_INFORMATION_KEY = "entity_type";
    public static final DateTimeFormatter DATE_WITHOUT_TIME_FORMATTER = DateTimeFormatter.ofPattern(new ShortDateFormat().getFormat());
    public static final DateTimeFormatter DATE_WITH_SHORT_TIME_FORMATTER = DateTimeFormatter.ofPattern(new NormalDateFormat().getFormat());
    public static final DateTimeFormatter DATE_WITHOUT_TIMEZONE_FORMATTER = DateTimeFormatter.ofPattern(new LongDateFormat().getFormat());
    private static final String INTERNAL_PROPERTY_PREFIX = "$";

    private TranslatorUtils() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static void translateStringComparison(String tableAlias, String columnName, AbstractStringValue value, boolean useWildcards, PSQLTypes casting, StringBuilder sqlBuilder, List<Object> args) {
        sqlBuilder.append("LOWER").append("(").append(tableAlias).append(".").append(columnName).append(")");
        if (casting != null) {
            sqlBuilder.append("::").append((Object)casting);
        }
        String strippedValue = TranslatorUtils.stripQuotationMarks((String)value.getValue()).toLowerCase();
        TranslatorUtils.appendStringComparatorOp(value.getClass(), strippedValue, useWildcards, sqlBuilder, args);
    }

    public static void appendStringComparatorOp(AbstractStringValue value, boolean useWildcards, StringBuilder sqlBuilder, List<Object> args) {
        TranslatorUtils.appendStringComparatorOp(value.getClass(), (String)value.getValue(), useWildcards, sqlBuilder, args);
    }

    public static void appendStringComparatorOp(Class<?> valueClass, String finalValue, boolean useWildcards, StringBuilder sqlBuilder, List<Object> args) {
        sqlBuilder.append(" ");
        if (valueClass == StringEqualToValue.class) {
            if (useWildcards && TranslatorUtils.containsWildcards(finalValue)) {
                sqlBuilder.append("ILIKE").append(" ").append('?');
                args.add(TranslatorUtils.toPSQLWildcards(finalValue));
            } else {
                sqlBuilder.append("=").append(" ").append('?');
                args.add(finalValue);
            }
        } else if (valueClass == StringLessThanValue.class) {
            sqlBuilder.append("<").append(" ").append('?');
            args.add(finalValue);
        } else if (valueClass == StringLessThanOrEqualToValue.class) {
            sqlBuilder.append("<=").append(" ").append('?');
            args.add(finalValue);
        } else if (valueClass == StringGreaterThanValue.class) {
            sqlBuilder.append(">").append(" ").append('?');
            args.add(finalValue);
        } else if (valueClass == StringGreaterThanOrEqualToValue.class) {
            sqlBuilder.append(">=").append(" ").append('?');
            args.add(finalValue);
        } else if (valueClass == StringStartsWithValue.class) {
            sqlBuilder.append("ILIKE").append(" ").append('?');
            args.add((useWildcards ? TranslatorUtils.toPSQLWildcards(finalValue) : TranslatorUtils.escapePSQLWildcards(finalValue)) + '%');
        } else if (valueClass == StringEndsWithValue.class) {
            sqlBuilder.append("ILIKE").append(" ").append('?');
            args.add('%' + (useWildcards ? TranslatorUtils.toPSQLWildcards(finalValue) : TranslatorUtils.escapePSQLWildcards(finalValue)));
        } else if (valueClass == StringContainsValue.class || valueClass == StringContainsExactlyValue.class) {
            sqlBuilder.append("ILIKE").append(" ").append('?');
            args.add('%' + (useWildcards ? TranslatorUtils.toPSQLWildcards(finalValue) : TranslatorUtils.escapePSQLWildcards(finalValue)) + '%');
        } else if (valueClass == AnyStringValue.class) {
            sqlBuilder.append("IS NOT NULL");
        } else {
            throw new IllegalArgumentException("Unsupported AbstractStringValue type: " + valueClass.getSimpleName());
        }
    }

    private static boolean containsWildcards(String str) {
        return str.matches(".*[*?].*");
    }

    private static String toPSQLWildcards(String str) {
        StringBuilder sb = new StringBuilder();
        char[] chars = str.toCharArray();
        block6: for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (i > 0 && chars[i - 1] == '\\') {
                sb.append(ch);
                continue;
            }
            switch (ch) {
                case '%': 
                case '_': {
                    sb.append('\\').append(ch);
                    continue block6;
                }
                case '\\': {
                    continue block6;
                }
                case '*': {
                    sb.append('%');
                    continue block6;
                }
                case '?': {
                    sb.append('_');
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static String escapePSQLWildcards(String str) {
        char[] chars;
        StringBuilder sb = new StringBuilder();
        block4: for (char ch : chars = str.toCharArray()) {
            switch (ch) {
                case '%': 
                case '_': {
                    sb.append('\\').append(ch);
                    continue block4;
                }
                case '\\': {
                    continue block4;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static void appendNumberComparatorOp(AbstractNumberValue value, StringBuilder sqlBuilder) {
        if (value.getClass() == NumberEqualToValue.class) {
            sqlBuilder.append("=");
        } else if (value.getClass() == NumberLessThanValue.class) {
            sqlBuilder.append("<");
        } else if (value.getClass() == NumberLessThanOrEqualToValue.class) {
            sqlBuilder.append("<=");
        } else if (value.getClass() == NumberGreaterThanValue.class) {
            sqlBuilder.append(">");
        } else if (value.getClass() == NumberGreaterThanOrEqualToValue.class) {
            sqlBuilder.append(">=");
        } else {
            throw new IllegalArgumentException("Unsupported AbstractNumberValue type: " + value.getClass().getSimpleName());
        }
        sqlBuilder.append(" ").append('?');
    }

    public static Map<String, JoinInformation> getPropertyJoinInformationMap(TableMapper tableMapper, IAliasFactory aliasFactory) {
        LinkedHashMap<String, JoinInformation> result = new LinkedHashMap<String, JoinInformation>();
        String valuesTableAlias = aliasFactory.createAlias();
        String entityTypesAttributeTypesTableAlias = aliasFactory.createAlias();
        String attributeTypesTableAlias = aliasFactory.createAlias();
        JoinInformation joinInformation1 = new JoinInformation();
        joinInformation1.setJoinType(JoinType.LEFT);
        joinInformation1.setMainTable(tableMapper.getEntitiesTable());
        joinInformation1.setMainTableAlias(SearchCriteriaTranslator.MAIN_TABLE_ALIAS);
        joinInformation1.setMainTableIdField("id");
        joinInformation1.setSubTable(tableMapper.getValuesTable());
        joinInformation1.setSubTableAlias(valuesTableAlias);
        joinInformation1.setSubTableIdField(tableMapper.getValuesTableEntityIdField());
        result.put(tableMapper.getValuesTable(), joinInformation1);
        JoinInformation joinInformation2 = new JoinInformation();
        joinInformation2.setJoinType(JoinType.LEFT);
        joinInformation2.setMainTable(tableMapper.getValuesTable());
        joinInformation2.setMainTableAlias(valuesTableAlias);
        joinInformation2.setMainTableIdField(tableMapper.getValuesTableEntityTypeAttributeTypeIdField());
        joinInformation2.setSubTable(tableMapper.getEntityTypesAttributeTypesTable());
        joinInformation2.setSubTableAlias(entityTypesAttributeTypesTableAlias);
        joinInformation2.setSubTableIdField("id");
        result.put(tableMapper.getEntityTypesAttributeTypesTable(), joinInformation2);
        JoinInformation joinInformation3 = new JoinInformation();
        joinInformation3.setJoinType(JoinType.LEFT);
        joinInformation3.setMainTable(tableMapper.getEntityTypesAttributeTypesTable());
        joinInformation3.setMainTableAlias(entityTypesAttributeTypesTableAlias);
        joinInformation3.setMainTableIdField(tableMapper.getEntityTypesAttributeTypesTableAttributeTypeIdField());
        joinInformation3.setSubTable(tableMapper.getAttributeTypesTable());
        joinInformation3.setSubTableAlias(attributeTypesTableAlias);
        joinInformation3.setSubTableIdField("id");
        result.put(tableMapper.getAttributeTypesTable(), joinInformation3);
        JoinInformation joinInformation4 = new JoinInformation();
        joinInformation4.setJoinType(JoinType.LEFT);
        joinInformation4.setMainTable(tableMapper.getAttributeTypesTable());
        joinInformation4.setMainTableAlias(attributeTypesTableAlias);
        joinInformation4.setMainTableIdField(tableMapper.getAttributeTypesTableDataTypeIdField());
        joinInformation4.setSubTable("data_types");
        joinInformation4.setSubTableAlias(aliasFactory.createAlias());
        joinInformation4.setSubTableIdField("id");
        result.put("data_types", joinInformation4);
        JoinInformation joinInformation5 = new JoinInformation();
        joinInformation5.setJoinType(JoinType.LEFT);
        joinInformation5.setMainTable(tableMapper.getValuesTable());
        joinInformation5.setMainTableAlias(valuesTableAlias);
        joinInformation5.setMainTableIdField("cvte_id");
        joinInformation5.setSubTable("controlled_vocabulary_terms");
        joinInformation5.setSubTableAlias(aliasFactory.createAlias());
        joinInformation5.setSubTableIdField("id");
        result.put("controlled_vocabulary_terms", joinInformation5);
        JoinInformation joinInformation6 = new JoinInformation();
        joinInformation6.setJoinType(JoinType.LEFT);
        joinInformation6.setMainTable(tableMapper.getValuesTable());
        joinInformation6.setMainTableAlias(valuesTableAlias);
        joinInformation6.setMainTableIdField("mate_prop_id");
        joinInformation6.setSubTable(TableMapper.MATERIAL.getEntitiesTable());
        joinInformation6.setSubTableAlias(aliasFactory.createAlias());
        joinInformation6.setSubTableIdField("id");
        result.put(TableMapper.MATERIAL.getEntitiesTable(), joinInformation6);
        if (tableMapper == TableMapper.SAMPLE || tableMapper == TableMapper.EXPERIMENT || tableMapper == TableMapper.DATA_SET) {
            String samplePropertyAlias = aliasFactory.createAlias();
            JoinInformation joinInformation7 = new JoinInformation();
            joinInformation7.setJoinType(JoinType.LEFT);
            joinInformation7.setMainTable(TableMapper.SAMPLE.getValuesTable());
            joinInformation7.setMainTableAlias(valuesTableAlias);
            joinInformation7.setMainTableIdField("samp_prop_id");
            joinInformation7.setSubTable(TableMapper.SAMPLE.getEntitiesTable());
            joinInformation7.setSubTableAlias(samplePropertyAlias);
            joinInformation7.setSubTableIdField("id");
            result.put("samp_prop_id", joinInformation7);
        }
        return result;
    }

    public static Map<String, JoinInformation> getTypeJoinInformationMap(TableMapper tableMapper, IAliasFactory aliasFactory) {
        LinkedHashMap<String, JoinInformation> result = new LinkedHashMap<String, JoinInformation>();
        JoinInformation joinInformation = new JoinInformation();
        joinInformation.setJoinType(JoinType.LEFT);
        joinInformation.setMainTable(tableMapper.getEntitiesTable());
        joinInformation.setMainTableAlias(SearchCriteriaTranslator.MAIN_TABLE_ALIAS);
        joinInformation.setMainTableIdField(tableMapper.getEntitiesTableEntityTypeIdField());
        joinInformation.setSubTable(tableMapper.getEntityTypesTable());
        joinInformation.setSubTableAlias(aliasFactory.createAlias());
        joinInformation.setSubTableIdField("id");
        result.put(tableMapper.getEntityTypesTable(), joinInformation);
        return result;
    }

    public static Map<String, JoinInformation> getRelationshipsJoinInformationMap(TableMapper tableMapper, IAliasFactory aliasFactory) {
        LinkedHashMap<String, JoinInformation> result = new LinkedHashMap<String, JoinInformation>();
        String relationshipsTableAlias = aliasFactory.createAlias();
        JoinInformation joinInformation1 = new JoinInformation();
        joinInformation1.setJoinType(JoinType.LEFT);
        joinInformation1.setMainTable(tableMapper.getEntitiesTable());
        joinInformation1.setMainTableAlias(SearchCriteriaTranslator.MAIN_TABLE_ALIAS);
        joinInformation1.setMainTableIdField("id");
        joinInformation1.setSubTable(tableMapper.getRelationshipsTable());
        joinInformation1.setSubTableAlias(relationshipsTableAlias);
        joinInformation1.setSubTableIdField(tableMapper.getRelationshipsTableParentIdField());
        result.put(tableMapper.getRelationshipsTable(), joinInformation1);
        JoinInformation joinInformation2 = new JoinInformation();
        joinInformation2.setJoinType(JoinType.LEFT);
        joinInformation2.setMainTable(tableMapper.getRelationshipsTable());
        joinInformation2.setMainTableAlias(relationshipsTableAlias);
        joinInformation2.setMainTableIdField(tableMapper.getRelationshipsTableChildIdField());
        joinInformation2.setSubTable(tableMapper.getEntitiesTable());
        joinInformation2.setSubTableAlias(aliasFactory.createAlias());
        joinInformation2.setSubTableIdField("id");
        result.put(tableMapper.getEntitiesTable(), joinInformation2);
        JoinInformation joinInformation3 = new JoinInformation();
        joinInformation3.setJoinType(JoinType.LEFT);
        joinInformation3.setMainTable(tableMapper.getRelationshipsTable());
        joinInformation3.setMainTableAlias(relationshipsTableAlias);
        joinInformation3.setMainTableIdField("relationship_id");
        joinInformation3.setSubTable("relationship_types");
        joinInformation3.setSubTableAlias(aliasFactory.createAlias());
        joinInformation3.setSubTableIdField("id");
        result.put("relationship_types", joinInformation3);
        return result;
    }

    public static void appendCastedTimestamp(StringBuilder sqlBuilder, String columnName, IDate fieldValue) {
        sqlBuilder.append(columnName);
        if (fieldValue instanceof AbstractDateValue) {
            String dateString = (String)((AbstractDateValue)fieldValue).getValue();
            try {
                DATE_WITHOUT_TIMEZONE_FORMATTER.parse(dateString);
            }
            catch (DateTimeParseException e1) {
                try {
                    DATE_WITH_SHORT_TIME_FORMATTER.parse(dateString);
                }
                catch (DateTimeParseException e2) {
                    try {
                        DATE_WITHOUT_TIME_FORMATTER.parse(dateString);
                        sqlBuilder.append("::").append((Object)PSQLTypes.DATE);
                    }
                    catch (DateTimeParseException e3) {
                        throw new IllegalArgumentException("Illegal date [dateString='" + dateString + "']", e3);
                    }
                }
            }
        }
    }

    public static void appendTimeZoneConversion(IDate fieldValue, StringBuilder sqlBuilder, ITimeZone timeZone) {
        if (fieldValue instanceof AbstractDateValue && timeZone instanceof TimeZone) {
            TimeZone timeZoneImpl = (TimeZone)timeZone;
            ZoneId zoneId = ZoneId.ofOffset("UTC", ZoneOffset.ofHours(-timeZoneImpl.getHourOffset()));
            sqlBuilder.append(" ").append("AT TIME ZONE").append(" ").append("'").append(zoneId.getId()).append("'");
        }
    }

    public static void addDateValueToArgs(IDate fieldValue, List<Object> args) {
        if (fieldValue instanceof AbstractDateValue) {
            args.add(TranslatorUtils.parseDate((String)((AbstractDateValue)fieldValue).getValue()));
        } else {
            args.add(((AbstractDateObjectValue)fieldValue).getValue());
        }
    }

    public static Date parseDate(String dateString) {
        try {
            return SearchCriteriaTranslator.DATE_HOURS_MINUTES_SECONDS_FORMAT.parse(dateString);
        }
        catch (ParseException e1) {
            try {
                return SearchCriteriaTranslator.DATE_HOURS_MINUTES_FORMAT.parse(dateString);
            }
            catch (ParseException e2) {
                try {
                    return SearchCriteriaTranslator.DATE_FORMAT.parse(dateString);
                }
                catch (ParseException e3) {
                    throw new IllegalArgumentException("Illegal date [dateString='" + dateString + "']", e3);
                }
            }
        }
    }

    public static boolean isDateWithoutTime(String dateString) {
        try {
            DATE_WITHOUT_TIME_FORMATTER.parse(dateString);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    public static void appendDateComparatorOp(IDate fieldValue, StringBuilder sqlBuilder, List<Object> args, boolean castToDate) {
        if (fieldValue instanceof DateEqualToValue || fieldValue instanceof DateObjectEqualToValue) {
            sqlBuilder.append("=");
        } else if (fieldValue instanceof DateEarlierThanOrEqualToValue || fieldValue instanceof DateObjectEarlierThanOrEqualToValue) {
            sqlBuilder.append("<=");
        } else if (fieldValue instanceof DateLaterThanOrEqualToValue || fieldValue instanceof DateObjectLaterThanOrEqualToValue) {
            sqlBuilder.append(">=");
        } else if (fieldValue instanceof DateEarlierThanValue || fieldValue instanceof DateObjectEarlierThanValue) {
            sqlBuilder.append("<");
        } else if (fieldValue instanceof DateLaterThanValue || fieldValue instanceof DateObjectLaterThanValue) {
            sqlBuilder.append(">");
        } else {
            throw new IllegalArgumentException("Unsupported field value: " + fieldValue.getClass().getSimpleName());
        }
        sqlBuilder.append(" ");
        if (castToDate) {
            sqlBuilder.append("(");
        }
        sqlBuilder.append('?').append("::").append(PSQLTypes.TIMESTAMP_WITHOUT_TZ.toString());
        if (castToDate) {
            sqlBuilder.append(")").append("::").append((Object)PSQLTypes.DATE);
        }
        TranslatorUtils.addDateValueToArgs(fieldValue, args);
    }

    public static boolean isPropertyInternal(String propertyName) {
        return propertyName.startsWith(INTERNAL_PROPERTY_PREFIX);
    }

    public static String normalisePropertyName(String propertyName) {
        return TranslatorUtils.isPropertyInternal(propertyName) ? propertyName.substring(INTERNAL_PROPERTY_PREFIX.length()) : propertyName;
    }

    public static void appendInternalExternalConstraint(StringBuilder sqlBuilder, List<Object> args, String entityTypesSubTableAlias, boolean internalProperty) {
        sqlBuilder.append(entityTypesSubTableAlias).append(".").append("is_managed_internally").append(" ").append("=").append(" ").append('?');
        args.add(internalProperty);
    }

    public static void appendJoin(StringBuilder sqlBuilder, JoinInformation joinInformation) {
        if (joinInformation.getSubTable() != null) {
            sqlBuilder.append("\n").append((Object)joinInformation.getJoinType()).append(" ").append("JOIN").append(" ").append(joinInformation.getSubTable()).append(" ").append(joinInformation.getSubTableAlias()).append(" ").append("ON").append(" ").append(joinInformation.getMainTableAlias()).append(".").append(joinInformation.getMainTableIdField()).append(" ").append("=").append(" ").append(joinInformation.getSubTableAlias()).append(".").append(joinInformation.getSubTableIdField());
        }
    }

    public static void appendIfNotFirst(StringBuilder sb, String value, AtomicBoolean first) {
        if (first.get()) {
            first.set(false);
        } else {
            sb.append(value);
        }
    }

    public static boolean isPropertySortingFieldName(String sortingCriteriaFieldName) {
        return sortingCriteriaFieldName.startsWith("PROPERTY");
    }

    public static boolean isPropertyScoreSortingFieldName(String sortingCriteriaFieldName) {
        return sortingCriteriaFieldName.startsWith("PROP_SCORE");
    }

    public static boolean isAnyPropertyScoreSortingFieldName(String sortingCriteriaFieldName) {
        return sortingCriteriaFieldName.startsWith("ANY_PR_SCORE");
    }

    public static Object convertStringToType(String value, Class<?> klass) {
        if (Boolean.class == klass) {
            return Boolean.parseBoolean(value);
        }
        if (Byte.class == klass) {
            float decimalValue = Float.parseFloat(value);
            return (byte)decimalValue;
        }
        if (Short.class == klass) {
            float decimalValue = Float.parseFloat(value);
            return (short)decimalValue;
        }
        if (Integer.class == klass) {
            float decimalValue = Float.parseFloat(value);
            return (int)decimalValue;
        }
        if (Long.class == klass) {
            double decimalValue = Double.parseDouble(value);
            return (long)decimalValue;
        }
        if (Float.class == klass) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class == klass) {
            return Double.parseDouble(value);
        }
        if (Date.class == klass) {
            return TranslatorUtils.parseDate(value);
        }
        return value;
    }

    public static String stripQuotationMarks(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static void buildTypeCodeIdentifierConcatenationString(StringBuilder sqlBuilder, String entityTypesTableAlias) {
        sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("code").append(" ").append("||").append(" ").append("'").append(" (").append("'").append(" ").append("||").append(" ").append(entityTypesTableAlias).append(".").append("code").append(" ").append("||").append(" ").append("'").append(")").append("'");
    }

    public static void buildFullIdentifierConcatenationString(StringBuilder sqlBuilder, String spacesTableAlias, String projectsTableAlias, String samplesTableAlias, boolean useLowerCase) {
        String slash = "/";
        String colon = ":";
        sqlBuilder.append("'").append("/").append("'").append(" ").append("||");
        if (spacesTableAlias != null) {
            TranslatorUtils.appendCoalesce(sqlBuilder, spacesTableAlias, "/", useLowerCase);
        }
        if (projectsTableAlias != null) {
            TranslatorUtils.appendCoalesce(sqlBuilder, projectsTableAlias, "/", useLowerCase);
        }
        if (samplesTableAlias != null) {
            TranslatorUtils.appendCoalesce(sqlBuilder, samplesTableAlias, ":", useLowerCase);
        }
        if (useLowerCase) {
            sqlBuilder.append(" ").append("LOWER").append("(");
        }
        sqlBuilder.append(SearchCriteriaTranslator.MAIN_TABLE_ALIAS).append(".").append("code");
        if (useLowerCase) {
            sqlBuilder.append(")");
        }
    }

    private static void appendCoalesce(StringBuilder sqlBuilder, String alias, String separator, boolean useLowerCase) {
        sqlBuilder.append(" ").append("COALESCE").append("(");
        if (useLowerCase) {
            sqlBuilder.append("LOWER").append("(");
        }
        sqlBuilder.append(alias).append(".").append("code");
        if (useLowerCase) {
            sqlBuilder.append(")");
        }
        sqlBuilder.append(" ").append("||").append(" ").append("'").append(separator).append("'").append(",").append(" ").append("'").append("'").append(")").append(" ").append("||");
    }

    public static Map<String, JoinInformation> getIdentifierJoinInformationMap(TableMapper tableMapper, IAliasFactory aliasFactory, String prefix) {
        LinkedHashMap<String, JoinInformation> result = new LinkedHashMap<String, JoinInformation>();
        TranslatorUtils.appendIdentifierJoinInformationMap(result, tableMapper, aliasFactory, prefix);
        return result;
    }

    public static void appendIdentifierJoinInformationMap(Map<String, JoinInformation> result, TableMapper tableMapper, IAliasFactory aliasFactory, String prefix) {
        String entitiesTable = tableMapper.getEntitiesTable();
        String samplesTableName = TableMapper.SAMPLE.getEntitiesTable();
        String projectsTableName = TableMapper.PROJECT.getEntitiesTable();
        String experimentsTableName = TableMapper.EXPERIMENT.getEntitiesTable();
        if (entitiesTable.equals(samplesTableName) || entitiesTable.equals(projectsTableName)) {
            JoinInformation spacesJoinInformation = TranslatorUtils.createSpacesJoinInformation(aliasFactory, entitiesTable, SearchCriteriaTranslator.MAIN_TABLE_ALIAS);
            result.put(prefix + "spaces", spacesJoinInformation);
        }
        if (entitiesTable.equals(samplesTableName) || entitiesTable.equals(experimentsTableName)) {
            String projectsTableAlias = aliasFactory.createAlias();
            JoinInformation projectsJoinInformation = new JoinInformation();
            projectsJoinInformation.setJoinType(JoinType.LEFT);
            projectsJoinInformation.setMainTable(entitiesTable);
            projectsJoinInformation.setMainTableAlias(SearchCriteriaTranslator.MAIN_TABLE_ALIAS);
            projectsJoinInformation.setMainTableIdField("proj_id");
            projectsJoinInformation.setSubTable("projects");
            projectsJoinInformation.setSubTableAlias(projectsTableAlias);
            projectsJoinInformation.setSubTableIdField("id");
            result.put(prefix + "projects", projectsJoinInformation);
            if (entitiesTable.equals(experimentsTableName)) {
                JoinInformation experimentsSpacesJoinInformation = TranslatorUtils.createSpacesJoinInformation(aliasFactory, entitiesTable, projectsTableAlias);
                result.put(prefix + "spaces", experimentsSpacesJoinInformation);
            }
        }
        if (entitiesTable.equals(samplesTableName)) {
            JoinInformation containerSampleJoinInformation = new JoinInformation();
            containerSampleJoinInformation.setJoinType(JoinType.LEFT);
            containerSampleJoinInformation.setMainTable(entitiesTable);
            containerSampleJoinInformation.setMainTableAlias(SearchCriteriaTranslator.MAIN_TABLE_ALIAS);
            containerSampleJoinInformation.setMainTableIdField("samp_id_part_of");
            containerSampleJoinInformation.setSubTable(entitiesTable);
            containerSampleJoinInformation.setSubTableAlias(aliasFactory.createAlias());
            containerSampleJoinInformation.setSubTableIdField("id");
            result.put(prefix + entitiesTable, containerSampleJoinInformation);
        }
    }

    private static JoinInformation createSpacesJoinInformation(IAliasFactory aliasFactory, String entitiesTable, String mainTableAlias) {
        JoinInformation spacesJoinInformation = new JoinInformation();
        spacesJoinInformation.setJoinType(JoinType.LEFT);
        spacesJoinInformation.setMainTable(entitiesTable);
        spacesJoinInformation.setMainTableAlias(mainTableAlias);
        spacesJoinInformation.setMainTableIdField("space_id");
        spacesJoinInformation.setSubTable("spaces");
        spacesJoinInformation.setSubTableAlias(aliasFactory.createAlias());
        spacesJoinInformation.setSubTableIdField("id");
        return spacesJoinInformation;
    }

    public static void appendTsVectorMatch(StringBuilder sqlBuilder, AbstractStringValue stringValue, String alias, List<Object> args) {
        if ("".equals(stringValue.getValue())) {
            sqlBuilder.append(true);
        } else {
            String tsQueryValue = GlobalSearchCriteriaTranslator.toTsQueryText(stringValue);
            sqlBuilder.append(alias).append(".").append("tsvector_document").append(" ").append("@@").append(" ").append("(").append('?').append("::").append("tsquery").append(" ").append("||").append(" ").append("to_tsquery").append("(").append('?').append(")").append(")");
            args.add(tsQueryValue);
            args.add(tsQueryValue);
        }
    }

    public static Map<String, JoinInformation> getFieldJoinInformationMap(TableMapper tableMapper, IAliasFactory aliasFactory) {
        JoinInformation registratorJoinInformation;
        Map<String, JoinInformation> result = TranslatorUtils.getPropertyJoinInformationMap(tableMapper, aliasFactory);
        TranslatorUtils.appendIdentifierJoinInformationMap(result, tableMapper, aliasFactory, "");
        if (tableMapper.hasRegistrator()) {
            registratorJoinInformation = new JoinInformation();
            registratorJoinInformation.setJoinType(JoinType.LEFT);
            registratorJoinInformation.setMainTable(tableMapper.getEntitiesTable());
            registratorJoinInformation.setMainTableAlias(SearchCriteriaTranslator.MAIN_TABLE_ALIAS);
            registratorJoinInformation.setMainTableIdField("pers_id_registerer");
            registratorJoinInformation.setSubTable("persons");
            registratorJoinInformation.setSubTableAlias(aliasFactory.createAlias());
            registratorJoinInformation.setSubTableIdField("id");
            result.put(REGISTRATOR_JOIN_INFORMATION_KEY, registratorJoinInformation);
        }
        if (tableMapper.hasModifier()) {
            registratorJoinInformation = new JoinInformation();
            registratorJoinInformation.setJoinType(JoinType.LEFT);
            registratorJoinInformation.setMainTable(tableMapper.getEntitiesTable());
            registratorJoinInformation.setMainTableAlias(SearchCriteriaTranslator.MAIN_TABLE_ALIAS);
            registratorJoinInformation.setMainTableIdField("pers_id_modifier");
            registratorJoinInformation.setSubTable("persons");
            registratorJoinInformation.setSubTableAlias(aliasFactory.createAlias());
            registratorJoinInformation.setSubTableIdField("id");
            result.put(MODIFIER_JOIN_INFORMATION_KEY, registratorJoinInformation);
        }
        JoinInformation typeJoinInformation = new JoinInformation();
        typeJoinInformation.setJoinType(JoinType.LEFT);
        typeJoinInformation.setMainTable(tableMapper.getEntitiesTable());
        typeJoinInformation.setMainTableAlias(SearchCriteriaTranslator.MAIN_TABLE_ALIAS);
        typeJoinInformation.setMainTableIdField(tableMapper.getEntitiesTableEntityTypeIdField());
        typeJoinInformation.setSubTable(tableMapper.getEntityTypesTable());
        typeJoinInformation.setSubTableAlias(aliasFactory.createAlias());
        typeJoinInformation.setSubTableIdField("id");
        result.put(ENTITY_TYPE_JOIN_INFORMATION_KEY, typeJoinInformation);
        return result;
    }

    public static String getAlias(AtomicInteger num) {
        return "t" + num.getAndIncrement();
    }

    public static void appendPropertyValueCoalesce(StringBuilder sqlBuilder, TableMapper tableMapper, Map<String, JoinInformation> joinInformationMap) {
        sqlBuilder.append("COALESCE").append("(");
        sqlBuilder.append(joinInformationMap.get(tableMapper.getValuesTable()).getSubTableAlias()).append(".").append("value");
        sqlBuilder.append(",").append(" ");
        sqlBuilder.append(joinInformationMap.get("controlled_vocabulary_terms").getSubTableAlias()).append(".").append("code");
        sqlBuilder.append(",").append(" ");
        sqlBuilder.append(joinInformationMap.get("materials").getSubTableAlias()).append(".").append("code");
        if (tableMapper == TableMapper.SAMPLE || tableMapper == TableMapper.EXPERIMENT || tableMapper == TableMapper.DATA_SET) {
            sqlBuilder.append(",").append(" ");
            sqlBuilder.append(joinInformationMap.get("samp_prop_id").getSubTableAlias()).append(".").append("code");
        }
        sqlBuilder.append(")");
    }
}

