/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.task;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecution;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.OperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.IOperationExecutionStore;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.util.Collection;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class AbstractOperationExecutionMarkMaintenanceTask
implements IMaintenanceTask {
    private final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, this.getClass());
    private static final String TIME_LIMIT_PROPERTY = "time-limit";
    private static final long TIME_LIMIT_DEFAULT = 3600000L;
    private IOpenBisSessionManager sessionManager;
    private IOperationExecutionStore executionStore;
    private long timeLimit;
    private Session session;

    public void setUp(String pluginName, Properties properties) {
        this.sessionManager = (IOpenBisSessionManager)CommonServiceProvider.getApplicationContext().getBean(IOpenBisSessionManager.class);
        this.executionStore = (IOperationExecutionStore)CommonServiceProvider.getApplicationContext().getBean(IOperationExecutionStore.class);
        this.timeLimit = DateTimeUtils.getDurationInMillis((Properties)properties, (String)TIME_LIMIT_PROPERTY, (long)3600000L);
        this.operationLog.info((Object)("Task " + pluginName + " initialized."));
    }

    protected OperationContext getOperationContext() {
        if (this.session == null) {
            this.session = this.createSession();
        } else {
            try {
                CommonServiceProvider.getCommonServer().getAuthSession(this.session.getSessionToken());
            }
            catch (InvalidSessionException e) {
                this.session = this.createSession();
            }
        }
        return new OperationContext(this.session);
    }

    private Session createSession() {
        SessionContextDTO sessionDTO = CommonServiceProvider.getCommonServer().tryToAuthenticateAsSystem();
        return (Session)this.getSessionManager().getSession(sessionDTO.getSessionToken());
    }

    public final void execute() {
        this.getOperationLog().debug((Object)"execution started");
        this.doExecute();
        this.getOperationLog().debug((Object)"task executed");
    }

    protected abstract void doExecute();

    protected void markOperationExecutions(Collection<OperationExecution> executions, MarkAction action) {
        long startTime = System.currentTimeMillis();
        for (OperationExecution execution : executions) {
            if (System.currentTimeMillis() > startTime + this.getTimeLimit()) {
                this.getOperationLog().info((Object)("Reached time limit of " + DateTimeUtils.renderDuration((long)this.timeLimit) + "."));
                return;
            }
            action.mark(execution);
        }
    }

    protected Logger getOperationLog() {
        return this.operationLog;
    }

    protected IOpenBisSessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected IOperationExecutionStore getExecutionStore() {
        return this.executionStore;
    }

    protected long getTimeLimit() {
        return this.timeLimit;
    }

    protected static interface MarkAction {
        public void mark(OperationExecution var1);
    }
}

