/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.task;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationExecutionError;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecution;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionError;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionState;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.fetchoptions.OperationExecutionFetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.task.AbstractOperationExecutionMarkMaintenanceTask;
import java.util.Date;
import java.util.List;

public class OperationExecutionMarkFailedAfterServerRestartMaintenanceTask
extends AbstractOperationExecutionMarkMaintenanceTask {
    private Date serverStartDate = new Date();

    @Override
    protected void doExecute() {
        this.markFailed();
    }

    private void markFailed() {
        List<OperationExecution> executions = this.getExecutionStore().getExecutionsToBeFailedAfterServerRestart(this.getOperationContext(), this.serverStartDate, new OperationExecutionFetchOptions());
        if (!executions.isEmpty()) {
            this.getOperationLog().info((Object)("found " + executions.size() + " execution(s) to be marked " + OperationExecutionState.FAILED));
        }
        this.markOperationExecutions(executions, new AbstractOperationExecutionMarkMaintenanceTask.MarkAction(){

            @Override
            public void mark(OperationExecution execution) {
                OperationExecutionMarkFailedAfterServerRestartMaintenanceTask.this.getExecutionStore().executionFailed(OperationExecutionMarkFailedAfterServerRestartMaintenanceTask.this.getOperationContext(), execution.getPermId(), (IOperationExecutionError)new OperationExecutionError("Execution interrupted by a server restart"));
            }
        });
    }
}

