/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.task;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecution;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionAvailability;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.fetchoptions.OperationExecutionFetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.task.AbstractOperationExecutionMarkMaintenanceTask;
import java.util.Date;
import java.util.List;

public class OperationExecutionMarkTimeOutPendingMaintenanceTask
extends AbstractOperationExecutionMarkMaintenanceTask {
    @Override
    protected void doExecute() {
        this.markTimeoutPending();
    }

    private void markTimeoutPending() {
        List<OperationExecution> executions = this.getExecutionStore().getExecutionsToBeTimeOutPending(this.getOperationContext(), new OperationExecutionFetchOptions());
        if (!executions.isEmpty()) {
            this.getOperationLog().info((Object)("found " + executions.size() + " execution(s) to be marked " + OperationExecutionAvailability.TIME_OUT_PENDING));
        }
        this.markOperationExecutions(executions, new AbstractOperationExecutionMarkMaintenanceTask.MarkAction(){

            @Override
            public void mark(OperationExecution execution) {
                if (OperationExecutionMarkTimeOutPendingMaintenanceTask.this.shouldMarkTimeoutPending(execution.getFinishDate(), execution.getAvailability(), execution.getAvailabilityTime())) {
                    OperationExecutionMarkTimeOutPendingMaintenanceTask.this.getExecutionStore().executionAvailability(OperationExecutionMarkTimeOutPendingMaintenanceTask.this.getOperationContext(), execution.getPermId(), OperationExecutionAvailability.TIME_OUT_PENDING);
                }
                if (OperationExecutionMarkTimeOutPendingMaintenanceTask.this.shouldMarkTimeoutPending(execution.getFinishDate(), execution.getSummaryAvailability(), execution.getSummaryAvailabilityTime())) {
                    OperationExecutionMarkTimeOutPendingMaintenanceTask.this.getExecutionStore().executionSummaryAvailability(OperationExecutionMarkTimeOutPendingMaintenanceTask.this.getOperationContext(), execution.getPermId(), OperationExecutionAvailability.TIME_OUT_PENDING);
                }
                if (OperationExecutionMarkTimeOutPendingMaintenanceTask.this.shouldMarkTimeoutPending(execution.getFinishDate(), execution.getDetailsAvailability(), execution.getDetailsAvailabilityTime())) {
                    OperationExecutionMarkTimeOutPendingMaintenanceTask.this.getExecutionStore().executionDetailsAvailability(OperationExecutionMarkTimeOutPendingMaintenanceTask.this.getOperationContext(), execution.getPermId(), OperationExecutionAvailability.TIME_OUT_PENDING);
                }
            }
        });
    }

    private boolean shouldMarkTimeoutPending(Date finishDate, OperationExecutionAvailability availability, int availabilityTime) {
        return OperationExecutionAvailability.AVAILABLE.equals((Object)availability) && finishDate != null && System.currentTimeMillis() > finishDate.getTime() + (long)availabilityTime * 1000L;
    }
}

