/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.task;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecution;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionAvailability;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.fetchoptions.OperationExecutionFetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.task.AbstractOperationExecutionMarkMaintenanceTask;
import java.util.List;

public class OperationExecutionMarkTimedOutOrDeletedMaintenanceTask
extends AbstractOperationExecutionMarkMaintenanceTask {
    @Override
    protected void doExecute() {
        this.markTimedOut();
        this.markDeleted();
    }

    private void markTimedOut() {
        List<OperationExecution> executions = this.getExecutionStore().getExecutionsToBeTimedOut(this.getOperationContext(), new OperationExecutionFetchOptions());
        if (!executions.isEmpty()) {
            this.getOperationLog().info((Object)("found " + executions.size() + " execution(s) to be marked " + OperationExecutionAvailability.TIMED_OUT));
        }
        this.markOperationExecutions(executions, new AbstractOperationExecutionMarkMaintenanceTask.MarkAction(){

            @Override
            public void mark(OperationExecution execution) {
                if (OperationExecutionAvailability.TIME_OUT_PENDING.equals((Object)execution.getAvailability())) {
                    OperationExecutionMarkTimedOutOrDeletedMaintenanceTask.this.getExecutionStore().executionAvailability(OperationExecutionMarkTimedOutOrDeletedMaintenanceTask.this.getOperationContext(), execution.getPermId(), OperationExecutionAvailability.TIMED_OUT);
                } else {
                    if (OperationExecutionAvailability.TIME_OUT_PENDING.equals((Object)execution.getSummaryAvailability())) {
                        OperationExecutionMarkTimedOutOrDeletedMaintenanceTask.this.getExecutionStore().executionSummaryAvailability(OperationExecutionMarkTimedOutOrDeletedMaintenanceTask.this.getOperationContext(), execution.getPermId(), OperationExecutionAvailability.TIMED_OUT);
                    }
                    if (OperationExecutionAvailability.TIME_OUT_PENDING.equals((Object)execution.getDetailsAvailability())) {
                        OperationExecutionMarkTimedOutOrDeletedMaintenanceTask.this.getExecutionStore().executionDetailsAvailability(OperationExecutionMarkTimedOutOrDeletedMaintenanceTask.this.getOperationContext(), execution.getPermId(), OperationExecutionAvailability.TIMED_OUT);
                    }
                }
            }
        });
    }

    private void markDeleted() {
        List<OperationExecution> executions = this.getExecutionStore().getExecutionsToBeDeleted(this.getOperationContext(), new OperationExecutionFetchOptions());
        if (!executions.isEmpty()) {
            this.getOperationLog().info((Object)("found " + executions.size() + " execution(s) to be marked " + OperationExecutionAvailability.DELETED));
        }
        this.markOperationExecutions(executions, new AbstractOperationExecutionMarkMaintenanceTask.MarkAction(){

            @Override
            public void mark(OperationExecution execution) {
                if (OperationExecutionAvailability.DELETE_PENDING.equals((Object)execution.getAvailability())) {
                    OperationExecutionMarkTimedOutOrDeletedMaintenanceTask.this.getExecutionStore().executionAvailability(OperationExecutionMarkTimedOutOrDeletedMaintenanceTask.this.getOperationContext(), execution.getPermId(), OperationExecutionAvailability.DELETED);
                } else {
                    if (OperationExecutionAvailability.DELETE_PENDING.equals((Object)execution.getSummaryAvailability())) {
                        OperationExecutionMarkTimedOutOrDeletedMaintenanceTask.this.getExecutionStore().executionSummaryAvailability(OperationExecutionMarkTimedOutOrDeletedMaintenanceTask.this.getOperationContext(), execution.getPermId(), OperationExecutionAvailability.DELETED);
                    }
                    if (OperationExecutionAvailability.DELETE_PENDING.equals((Object)execution.getDetailsAvailability())) {
                        OperationExecutionMarkTimedOutOrDeletedMaintenanceTask.this.getExecutionStore().executionDetailsAvailability(OperationExecutionMarkTimedOutOrDeletedMaintenanceTask.this.getOperationContext(), execution.getPermId(), OperationExecutionAvailability.DELETED);
                    }
                }
            }
        });
    }
}

