/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationCache;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractCachingTranslator<I, O, F extends FetchOptions<?>>
extends AbstractTranslator<I, O, F> {
    private final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, this.getClass());
    private final String namespace = this.getClass().getName();

    @Override
    protected final O doTranslate(TranslationContext context, I object, F fetchOptions) {
        Map<I, O> translated = this.doTranslate(context, (Collection<I>)Collections.singleton(object), fetchOptions);
        if (translated.isEmpty()) {
            return null;
        }
        return translated.get(object);
    }

    @Override
    protected final Map<I, O> doTranslate(TranslationContext context, Collection<I> allInputs, F fetchOptions) {
        LinkedHashMap translated = new LinkedHashMap();
        LinkedHashMap updated = new LinkedHashMap();
        TranslationCache cache = context.getTranslationCache();
        Collection<I> inputs = this.doShouldTranslate(context, allInputs, fetchOptions);
        for (I input : inputs) {
            TranslationCache.CacheEntry cacheEntry = cache.getEntry(this.getObjectCacheKey(input, fetchOptions));
            if (cacheEntry.isTranslatedObjectSet()) {
                this.handleAlreadyTranslatedInput(context, input, translated, updated, fetchOptions);
                continue;
            }
            this.handleNewInput(context, input, translated, updated, fetchOptions);
        }
        if (!updated.isEmpty()) {
            Object relations = this.getObjectsRelations(context, updated.keySet(), fetchOptions);
            for (Map.Entry updatedEntry : updated.entrySet()) {
                this.updateObject(context, updatedEntry.getKey(), updatedEntry.getValue(), relations, fetchOptions);
            }
        }
        this.filterTranslated(context, translated);
        this.postTranslate(context, translated);
        return translated;
    }

    private final void handleAlreadyTranslatedInput(TranslationContext context, I input, Map<I, O> translated, Map<I, O> updated, F fetchOptions) {
        TranslationCache cache = context.getTranslationCache();
        TranslationCache.CacheEntry cacheEntry = cache.getEntry(this.getObjectCacheKey(input, fetchOptions));
        Object output = cacheEntry.getTranslatedObject();
        if (output == null) {
            if (this.operationLog.isDebugEnabled()) {
                this.operationLog.debug((Object)("Found that object was already rejected from translation: " + this.getObjectId(input)));
            }
        } else {
            if (this.operationLog.isDebugEnabled()) {
                this.operationLog.debug((Object)("Found in cache: " + output.getClass() + " with id: " + this.getObjectId(input)));
            }
            translated.put(input, output);
        }
    }

    private void handleNewInput(TranslationContext context, I input, Map<I, O> translated, Map<I, O> updated, F fetchOptions) {
        O output = this.createObject(context, input, fetchOptions);
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)("Created: " + output.getClass() + " with id: " + this.getObjectId(input)));
        }
        TranslationCache cache = context.getTranslationCache();
        TranslationCache.CacheEntry cacheEntry = cache.getEntry(this.getObjectCacheKey(input, fetchOptions));
        cacheEntry.setTranslatedObject(output);
        updated.put(input, output);
        translated.put(input, output);
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)("Updating created: " + output.getClass() + " with id: " + this.getObjectId(input)));
        }
    }

    protected Object getObjectId(I input) {
        if (input instanceof IIdHolder) {
            return HibernateUtils.getId((IIdHolder)input);
        }
        if (input instanceof Long) {
            return (Long)input;
        }
        String message = input != null ? "Unsupported input type: " + input.getClass() : "Null input is unsupported.";
        throw new IllegalArgumentException(message);
    }

    protected TranslationCache.CacheKey getObjectCacheKey(I input, F fetchOptions) {
        return new TranslationCache.CacheKey(this.namespace, this.getObjectId(input), (FetchOptions<?>)fetchOptions);
    }

    private final Collection<I> doShouldTranslate(TranslationContext context, Collection<I> inputs, F fetchOptions) {
        TranslationCache cache = context.getTranslationCache();
        LinkedHashSet<I> toCheck = new LinkedHashSet<I>();
        LinkedHashSet<Object> toTranslate = new LinkedHashSet<Object>();
        for (I input : inputs) {
            TranslationCache.CacheEntry cacheEntry = cache.getEntry(this.getObjectCacheKey(input, fetchOptions));
            if (cacheEntry.isShouldTranslateSet()) {
                boolean should = cacheEntry.getShouldTranslate();
                if (should) {
                    toTranslate.add(input);
                }
                if (!this.operationLog.isDebugEnabled()) continue;
                Object id = this.getObjectId(input);
                if (should) {
                    this.operationLog.debug((Object)("Found in cache that object with id: " + id + " should be translated"));
                    continue;
                }
                this.operationLog.debug((Object)("Found in cache that object with id: " + id + " should NOT be translated"));
                continue;
            }
            toCheck.add(input);
        }
        Set checked = this.shouldTranslate(context, (Collection<I>)toCheck, fetchOptions);
        toTranslate.addAll(checked);
        for (Object input : checked) {
            TranslationCache.CacheEntry cacheEntry = cache.getEntry(this.getObjectCacheKey(input, fetchOptions));
            cacheEntry.setShouldTranslate(true);
            if (!this.operationLog.isDebugEnabled()) continue;
            this.operationLog.debug((Object)("Should translate object with id: " + this.getObjectId(input)));
        }
        toCheck.removeAll(checked);
        for (Object input : toCheck) {
            TranslationCache.CacheEntry cacheEntry = cache.getEntry(this.getObjectCacheKey(input, fetchOptions));
            cacheEntry.setShouldTranslate(false);
            if (!this.operationLog.isDebugEnabled()) continue;
            this.operationLog.debug((Object)("Should NOT translate object with id: " + this.getObjectId(input)));
        }
        return toTranslate;
    }

    protected Set<I> shouldTranslate(TranslationContext context, Collection<I> inputs, F fetchOptions) {
        LinkedHashSet<I> result = new LinkedHashSet<I>();
        for (I input : inputs) {
            if (!this.shouldTranslate(context, input, fetchOptions)) continue;
            result.add(input);
        }
        return result;
    }

    protected boolean shouldTranslate(TranslationContext context, I input, F fetchOptions) {
        return true;
    }

    protected void filterTranslated(TranslationContext context, Map<I, O> translated) {
    }

    protected void postTranslate(TranslationContext context, Map<I, O> translated) {
    }

    protected abstract O createObject(TranslationContext var1, I var2, F var3);

    protected Object getObjectsRelations(TranslationContext context, Collection<I> inputs, F fetchOptions) {
        return new Object();
    }

    protected abstract void updateObject(TranslationContext var1, I var2, O var3, Object var4, F var5);
}

