/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator;

import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.ITranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractTranslator<I, O, F>
implements ITranslator<I, O, F> {
    @Override
    public O translate(TranslationContext context, I object, F fetchOptions) {
        if (object == null) {
            return null;
        }
        return this.doTranslate(context, object, fetchOptions);
    }

    @Override
    public final Map<I, O> translate(TranslationContext context, Collection<I> objects, F fetchOptions) {
        if (objects == null) {
            return null;
        }
        return this.doTranslate(context, (I)objects, fetchOptions);
    }

    protected Map<I, O> doTranslate(TranslationContext context, Collection<I> objects, F fetchOptions) {
        LinkedHashMap<I, O> translatedMap = new LinkedHashMap<I, O>();
        for (I object : objects) {
            O translated = this.doTranslate(context, object, fetchOptions);
            if (translated == null) continue;
            translatedMap.put(object, translated);
        }
        return translatedMap;
    }

    protected abstract O doTranslate(TranslationContext var1, I var2, F var3);
}

