/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class TranslationCache {
    private Map<CacheKey, CacheEntry> entries = new HashMap<CacheKey, CacheEntry>();

    public CacheEntry getEntry(CacheKey cacheKey) {
        CacheEntry cacheEntry = this.entries.get(cacheKey);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry();
            this.entries.put(cacheKey, cacheEntry);
        }
        return cacheEntry;
    }

    public static class CacheEntry {
        private boolean shouldTranslateSet;
        private Boolean shouldTranslate;
        private boolean translatedObjectSet;
        private Object translatedObject;

        private CacheEntry() {
        }

        public boolean isShouldTranslateSet() {
            return this.shouldTranslateSet;
        }

        public Boolean getShouldTranslate() {
            return this.shouldTranslate;
        }

        public void setShouldTranslate(boolean shouldTranslate) {
            this.shouldTranslate = shouldTranslate;
            this.shouldTranslateSet = true;
        }

        public boolean isTranslatedObjectSet() {
            return this.translatedObjectSet;
        }

        public Object getTranslatedObject() {
            return this.translatedObject;
        }

        public void setTranslatedObject(Object translatedObject) {
            this.translatedObject = translatedObject;
            this.translatedObjectSet = true;
        }
    }

    public static class CacheKey {
        private String translatorId;
        private Object objectId;
        private FetchOptions<?> fetchOptions;

        public CacheKey(String translatorId, Object objectId, FetchOptions<?> fetchOptions) {
            this.translatorId = translatorId;
            this.objectId = objectId;
            this.fetchOptions = fetchOptions;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.translatorId == null ? 0 : this.translatorId.hashCode());
            result = 31 * result + (this.objectId == null ? 0 : this.objectId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.translatorId == null ? other.translatorId != null : !this.translatorId.equals(other.translatorId)) {
                return false;
            }
            if (this.objectId == null ? other.objectId != null : !this.objectId.equals(other.objectId)) {
                return false;
            }
            return EqualsBuilder.reflectionEquals(this.fetchOptions, other.fetchOptions, (boolean)false, null, (boolean)true, (String[])new String[0]);
        }
    }
}

