/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.attachment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.Attachment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.fetchoptions.AttachmentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.fetchoptions.PersonFetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.attachment.AttachmentBaseRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.attachment.IAttachmentBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.attachment.IAttachmentContentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.attachment.IAttachmentRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.attachment.IAttachmentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.PermlinkUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachmentTranslator
extends AbstractCachingTranslator<Long, Attachment, AttachmentFetchOptions>
implements IAttachmentTranslator {
    private static Comparator<AttachmentBaseRecord> VERSION_COMPARATOR = new Comparator<AttachmentBaseRecord>(){

        @Override
        public int compare(AttachmentBaseRecord r1, AttachmentBaseRecord r2) {
            return r2.version - r1.version;
        }
    };
    @Autowired
    private IAttachmentBaseTranslator baseTranslator;
    @Autowired
    private IAttachmentRegistratorTranslator registratorTranslator;
    @Autowired
    private IAttachmentContentTranslator contentTranslator;

    @Override
    protected Attachment createObject(TranslationContext context, Long input, AttachmentFetchOptions fetchOptions) {
        Attachment result = new Attachment();
        result.setFetchOptions(new AttachmentFetchOptions());
        return result;
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> attachmentIds, AttachmentFetchOptions fetchOptions) {
        Map records = this.baseTranslator.translate(context, attachmentIds, null);
        List<List<AttachmentBaseRecord>> groupedRecords = this.groupAndSortByVersion(records.values());
        AttachmentsBuildingHelper buildingHelper = new AttachmentsBuildingHelper();
        for (List<AttachmentBaseRecord> recordsSortecByVersion : groupedRecords) {
            buildingHelper.handleAttachmentsOfDifferentVersions(recordsSortecByVersion, fetchOptions);
        }
        buildingHelper.translateRelatedObjects(context);
        return buildingHelper;
    }

    private List<List<AttachmentBaseRecord>> groupAndSortByVersion(Collection<ObjectHolder<AttachmentBaseRecord>> records) {
        HashMap<String, ArrayList<AttachmentBaseRecord>> mapByFileName = new HashMap<String, ArrayList<AttachmentBaseRecord>>();
        for (ObjectHolder<AttachmentBaseRecord> recordHolder : records) {
            AttachmentBaseRecord record = recordHolder.getObject();
            String key = this.createKey(record);
            ArrayList<AttachmentBaseRecord> list = (ArrayList<AttachmentBaseRecord>)mapByFileName.get(key);
            if (list == null) {
                list = new ArrayList<AttachmentBaseRecord>();
                mapByFileName.put(key, list);
            }
            list.add(record);
        }
        Collection lists = mapByFileName.values();
        for (List list : lists) {
            Collections.sort(list, VERSION_COMPARATOR);
        }
        return new ArrayList<List<AttachmentBaseRecord>>(lists);
    }

    private String createKey(AttachmentBaseRecord record) {
        StringBuilder builder = new StringBuilder();
        builder.append("p:").append(record.projectCode).append(record.spaceCode);
        builder.append("s:").append(record.samplePermId);
        builder.append("e:").append(record.experimentPermId);
        builder.append("f:").append(record.fileName);
        return builder.toString();
    }

    @Override
    protected void updateObject(TranslationContext context, Long attachmentId, Attachment result, Object objectRelations, AttachmentFetchOptions fetchOptions) {
        AttachmentsBuildingHelper buildingHelper = (AttachmentsBuildingHelper)objectRelations;
        AttachmentBaseRecord baseRecord = buildingHelper.getBaseRecord(attachmentId);
        if (baseRecord == null) {
            return;
        }
        result.setFileName(baseRecord.fileName);
        result.setTitle(baseRecord.title);
        result.setDescription(baseRecord.description);
        result.setRegistrationDate(baseRecord.registrationDate);
        result.setVersion(Integer.valueOf(baseRecord.version));
        String baseIndexURL = context.getSession().getBaseIndexURL();
        result.setPermlink(this.createPermlink(baseRecord, baseIndexURL, false));
        result.setLatestVersionPermlink(this.createPermlink(baseRecord, baseIndexURL, true));
        buildingHelper.addRegistratorAndContent(result, attachmentId);
    }

    private String createPermlink(AttachmentBaseRecord baseRecord, String baseIndexURL, boolean latestVersionPermlink) {
        Integer version;
        String fileName = baseRecord.fileName;
        Integer n = version = latestVersionPermlink ? null : Integer.valueOf(baseRecord.version);
        if (baseRecord.projectCode != null) {
            return PermlinkUtilities.createProjectAttachmentPermlinkURL(baseIndexURL, fileName, version, baseRecord.projectCode, baseRecord.spaceCode);
        }
        if (baseRecord.samplePermId != null) {
            return PermlinkUtilities.createAttachmentPermlinkURL(baseIndexURL, fileName, version, AttachmentHolderKind.SAMPLE, baseRecord.samplePermId);
        }
        return PermlinkUtilities.createAttachmentPermlinkURL(baseIndexURL, fileName, version, AttachmentHolderKind.EXPERIMENT, baseRecord.experimentPermId);
    }

    private final class AttachmentsBuildingHelper {
        private Map<Long, AttachmentBaseRecord> records = new HashMap<Long, AttachmentBaseRecord>();
        private Map<PersonFetchOptions, List<Long>> attachmentsWithRegistrator = new HashMap<PersonFetchOptions, List<Long>>();
        private Set<Long> attachmentsWithContent = new HashSet<Long>();
        private Map<Long, AttachmentFetchOptions> fetchOptionsByAttachmentId = new HashMap<Long, AttachmentFetchOptions>();
        private Map<Long, ObjectHolder<Person>> registratorsByAttachmentId = new HashMap<Long, ObjectHolder<Person>>();
        private Map<Long, ObjectHolder<byte[]>> contentsByAttachmentId;
        private Map<Long, Long> nextVersionIdByAttachmentId = new HashMap<Long, Long>();
        private Map<Long, Attachment> attachments = new HashMap<Long, Attachment>();

        private AttachmentsBuildingHelper() {
        }

        AttachmentBaseRecord getBaseRecord(Long attachmentId) {
            return this.records.get(attachmentId);
        }

        private <T> T getObject(Map<Long, ObjectHolder<T>> objectsById, Long attachmentId) {
            ObjectHolder<T> objectHolder = objectsById.get(attachmentId);
            return objectHolder == null ? null : (T)objectHolder.getObject();
        }

        void addRegistratorAndContent(Attachment attachment, Long attachmentId) {
            this.attachments.put(attachmentId, attachment);
            AttachmentFetchOptions fetchOptions = this.fetchOptionsByAttachmentId.get(attachmentId);
            attachment.setFetchOptions(fetchOptions);
            if (fetchOptions.hasRegistrator()) {
                attachment.setRegistrator((Person)this.getObject(this.registratorsByAttachmentId, attachmentId));
                attachment.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
            }
            if (fetchOptions.hasContent()) {
                attachment.setContent((byte[])this.getObject(this.contentsByAttachmentId, attachmentId));
                attachment.getFetchOptions().withContent();
            }
            Set<Map.Entry<Long, Long>> entrySet = this.nextVersionIdByAttachmentId.entrySet();
            for (Map.Entry<Long, Long> entry : entrySet) {
                Attachment version = this.attachments.get(entry.getValue());
                Attachment previousVersion = this.attachments.get(entry.getKey());
                if (version == null || previousVersion == null) continue;
                version.setPreviousVersion(previousVersion);
                version.getFetchOptions().withPreviousVersion();
            }
        }

        void handleAttachmentsOfDifferentVersions(List<AttachmentBaseRecord> recordsSortedByVersion, AttachmentFetchOptions fetchOptions) {
            AttachmentFetchOptions currentFetchOptions = fetchOptions;
            Long nextVersionId = null;
            for (AttachmentBaseRecord record : recordsSortedByVersion) {
                Long attachmentId = record.id;
                this.records.put(attachmentId, record);
                if (nextVersionId != null) {
                    this.nextVersionIdByAttachmentId.put(attachmentId, nextVersionId);
                }
                this.fetchOptionsByAttachmentId.put(attachmentId, currentFetchOptions);
                if (currentFetchOptions.hasRegistrator()) {
                    this.addRequestForRegistrator(attachmentId, currentFetchOptions.withRegistrator());
                }
                if (currentFetchOptions.hasContent()) {
                    this.attachmentsWithContent.add(attachmentId);
                }
                if (!currentFetchOptions.hasPreviousVersion()) break;
                currentFetchOptions = currentFetchOptions.withPreviousVersion();
                nextVersionId = attachmentId;
            }
        }

        void translateRelatedObjects(TranslationContext context) {
            Set<Map.Entry<PersonFetchOptions, List<Long>>> entrySet = this.attachmentsWithRegistrator.entrySet();
            for (Map.Entry<PersonFetchOptions, List<Long>> entry : entrySet) {
                PersonFetchOptions fetchOptions = entry.getKey();
                List<Long> attachmentIds = entry.getValue();
                this.registratorsByAttachmentId.putAll(AttachmentTranslator.this.registratorTranslator.translate(context, attachmentIds, fetchOptions));
            }
            this.contentsByAttachmentId = AttachmentTranslator.this.contentTranslator.translate(context, this.attachmentsWithContent, null);
        }

        private void addRequestForRegistrator(Long attachmentId, PersonFetchOptions fetchOptions) {
            List<Long> list = this.attachmentsWithRegistrator.get(fetchOptions);
            if (list == null) {
                list = new ArrayList<Long>();
                this.attachmentsWithRegistrator.put(fetchOptions, list);
            }
            list.add(attachmentId);
        }
    }
}

