/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.attachment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.Attachment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.fetchoptions.AttachmentFetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.attachment.AttachmentQuery;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.attachment.IAttachmentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectRelationRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectToManyRelationTranslator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.lemnik.eodsql.QueryTool;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class EntityAttachmentTranslator
extends ObjectToManyRelationTranslator<Attachment, AttachmentFetchOptions> {
    @Autowired
    private IAttachmentTranslator attachmentTranslator;

    protected abstract List<ObjectRelationRecord> loadRecords(LongOpenHashSet var1, AttachmentQuery var2);

    @Override
    protected Map<Long, Attachment> filterRelatedObjects(Map<Long, Attachment> relatedObjects) {
        HashSet<Attachment> derived = new HashSet<Attachment>();
        Collection<Attachment> values = relatedObjects.values();
        Iterator<Attachment> iterator = values.iterator();
        while (iterator.hasNext()) {
            Attachment attachment;
            for (Attachment current = attachment = iterator.next(); current != null && current.getFetchOptions().hasPreviousVersion(); current = current.getPreviousVersion()) {
                derived.add(current);
            }
        }
        HashMap<Long, Attachment> filteredRelatedObjects = new HashMap<Long, Attachment>();
        for (Map.Entry<Long, Attachment> entry : relatedObjects.entrySet()) {
            Long id = entry.getKey();
            Attachment relatedObject = entry.getValue();
            if (relatedObject.getFileName() == null || derived.contains(relatedObject)) continue;
            filteredRelatedObjects.put(id, relatedObject);
        }
        return filteredRelatedObjects;
    }

    @Override
    protected List<ObjectRelationRecord> loadRecords(LongOpenHashSet objectIds) {
        AttachmentQuery query = (AttachmentQuery)QueryTool.getManagedQuery(AttachmentQuery.class);
        return this.loadRecords(objectIds, query);
    }

    @Override
    protected Map<Long, Attachment> translateRelated(TranslationContext context, Collection<Long> relatedIds, AttachmentFetchOptions relatedFetchOptions) {
        return this.attachmentTranslator.translate(context, relatedIds, relatedFetchOptions);
    }

    @Override
    protected Collection<Attachment> createCollection() {
        return new ArrayList<Attachment>();
    }
}

