/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.authorizationgroup;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.AuthorizationGroup;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.fetchoptions.AuthorizationGroupFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.id.AuthorizationGroupPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.OperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.authorizationgroup.IAuthorizationGroupAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.authorizationgroup.IAuthorizationGroupTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.authorizationgroup.AuthorizationGroupBaseRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.authorizationgroup.IAuthorizationGroupBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.authorizationgroup.IAuthorizationGroupRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.authorizationgroup.IAuthorizationGroupRoleAssignmentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.authorizationgroup.IAuthorizationGroupUserTranslator;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthorizationGroupTranslator
extends AbstractCachingTranslator<Long, AuthorizationGroup, AuthorizationGroupFetchOptions>
implements IAuthorizationGroupTranslator {
    @Autowired
    private IAuthorizationGroupAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IAuthorizationGroupBaseTranslator baseTranslator;
    @Autowired
    private IAuthorizationGroupRegistratorTranslator registratorTranslator;
    @Autowired
    private IAuthorizationGroupUserTranslator userTranslator;
    @Autowired
    private IAuthorizationGroupRoleAssignmentTranslator roleAssignmentTranslator;

    @Override
    protected Set<Long> shouldTranslate(TranslationContext context, Collection<Long> inputs, AuthorizationGroupFetchOptions fetchOptions) {
        try {
            this.authorizationExecutor.canGet(new OperationContext(context.getSession()));
            return new HashSet<Long>(inputs);
        }
        catch (AuthorizationFailureException ex) {
            return new HashSet<Long>();
        }
    }

    @Override
    protected AuthorizationGroup createObject(TranslationContext context, Long input, AuthorizationGroupFetchOptions fetchOptions) {
        AuthorizationGroup authorizationGroup = new AuthorizationGroup();
        authorizationGroup.setFetchOptions(fetchOptions);
        return authorizationGroup;
    }

    protected TranslationResults getObjectsRelations(TranslationContext context, Collection<Long> ids, AuthorizationGroupFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IAuthorizationGroupBaseTranslator.class, this.baseTranslator.translate(context, ids, null));
        if (fetchOptions.hasRegistrator()) {
            relations.put(IAuthorizationGroupRegistratorTranslator.class, this.registratorTranslator.translate(context, ids, fetchOptions.withRegistrator()));
        }
        if (fetchOptions.hasUsers()) {
            relations.put(IAuthorizationGroupUserTranslator.class, this.userTranslator.translate(context, ids, fetchOptions.withUsers()));
        }
        if (fetchOptions.hasRoleAssignments()) {
            relations.put(IAuthorizationGroupRoleAssignmentTranslator.class, this.roleAssignmentTranslator.translate(context, ids, fetchOptions.withRoleAssignments()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long id, AuthorizationGroup group, Object objectRelations, AuthorizationGroupFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        AuthorizationGroupBaseRecord baseRecord = (AuthorizationGroupBaseRecord)relations.get(IAuthorizationGroupBaseTranslator.class, id);
        group.setPermId(new AuthorizationGroupPermId(baseRecord.code));
        group.setCode(baseRecord.code);
        group.setDescription(baseRecord.description);
        group.setRegistrationDate(baseRecord.registrationDate);
        group.setModificationDate(baseRecord.modificationDate);
        if (fetchOptions.hasRegistrator()) {
            group.setRegistrator((Person)relations.get(IAuthorizationGroupRegistratorTranslator.class, id));
            group.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
        }
        if (fetchOptions.hasUsers()) {
            group.setUsers((List)relations.get(IAuthorizationGroupUserTranslator.class, id));
            group.getFetchOptions().withUsersUsing(fetchOptions.withUsers());
        }
        if (fetchOptions.hasRoleAssignments()) {
            group.setRoleAssignments((List)relations.get(IAuthorizationGroupRoleAssignmentTranslator.class, id));
            group.getFetchOptions().withRoleAssignmentsUsing(fetchOptions.withRoleAssignments());
        }
    }
}

