/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common;

import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ProjectByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SimpleSpaceValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractAuthorizationValidator {
    @Autowired
    protected IDAOFactory daoFactory;

    protected boolean isValid(PersonPE person, final SpaceIdentifier spaceIdentifier, final ProjectIdentifier projectIdentifier) {
        AuthorizationDataProvider provider = new AuthorizationDataProvider(this.daoFactory);
        SimpleSpaceValidator spaceValidator = new SimpleSpaceValidator();
        spaceValidator.init(provider);
        ProjectByIdentiferValidator projectValidator = new ProjectByIdentiferValidator();
        projectValidator.init(provider);
        if (spaceIdentifier != null) {
            if (spaceValidator.isValid(person, new ICodeHolder(){

                public String getCode() {
                    return spaceIdentifier.getSpaceCode();
                }
            })) {
                return true;
            }
            if (projectIdentifier != null) {
                return projectValidator.isValid(person, new IIdentifierHolder(){

                    public String getIdentifier() {
                        return projectIdentifier.toString();
                    }
                });
            }
            return false;
        }
        return true;
    }
}

