/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.EmptyFetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.IObjectBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectBaseRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectHolder;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ObjectBaseTranslator<RECORD extends ObjectBaseRecord>
extends AbstractCachingTranslator<Long, ObjectHolder<RECORD>, EmptyFetchOptions>
implements IObjectBaseTranslator<RECORD> {
    @Override
    protected ObjectHolder<RECORD> createObject(TranslationContext context, Long input, EmptyFetchOptions fetchOptions) {
        return new ObjectHolder();
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> materialIds, EmptyFetchOptions fetchOptions) {
        List<RECORD> records = this.loadRecords(new LongOpenHashSet(materialIds));
        HashMap<Long, ObjectBaseRecord> recordMap = new HashMap<Long, ObjectBaseRecord>();
        for (ObjectBaseRecord record : records) {
            recordMap.put(record.id, record);
        }
        return recordMap;
    }

    @Override
    protected void updateObject(TranslationContext context, Long materialId, ObjectHolder<RECORD> result, Object relations, EmptyFetchOptions fetchOptions) {
        Map recordMap = (Map)relations;
        ObjectBaseRecord record = (ObjectBaseRecord)recordMap.get(materialId);
        result.setObject(record);
    }

    protected abstract List<RECORD> loadRecords(LongOpenHashSet var1);
}

