/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectHolder;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectRelationRecord;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class ObjectToManyRelationTranslator<RELATED_OBJECT, RELATED_FETCH_OPTIONS extends FetchOptions<?>>
extends AbstractCachingTranslator<Long, ObjectHolder<Collection<RELATED_OBJECT>>, RELATED_FETCH_OPTIONS> {
    @Override
    protected ObjectHolder<Collection<RELATED_OBJECT>> createObject(TranslationContext context, Long objectId, RELATED_FETCH_OPTIONS relatedFetchOptions) {
        return new ObjectHolder<Collection<RELATED_OBJECT>>();
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> objectIds, RELATED_FETCH_OPTIONS relatedFetchOptions) {
        List<ObjectRelationRecord> records = this.loadRecords(new LongOpenHashSet(objectIds));
        HashSet<Long> relatedIds = new HashSet<Long>();
        for (ObjectRelationRecord record : records) {
            if (record.relatedId == null) continue;
            relatedIds.add(record.relatedId);
        }
        Map<Long, RELATED_OBJECT> relatedIdToRelated = this.filterRelatedObjects(this.translateRelated(context, relatedIds, relatedFetchOptions));
        HashMap<Long, Collection<RELATED_OBJECT>> objectIdToRelatedMap = new HashMap<Long, Collection<RELATED_OBJECT>>();
        for (ObjectRelationRecord record : records) {
            RELATED_OBJECT relatedObject;
            Collection<RELATED_OBJECT> relatedCollection = (Collection<RELATED_OBJECT>)objectIdToRelatedMap.get(record.objectId);
            if (relatedCollection == null) {
                relatedCollection = this.createCollection();
                objectIdToRelatedMap.put(record.objectId, relatedCollection);
            }
            if ((relatedObject = relatedIdToRelated.get(record.relatedId)) == null) continue;
            relatedCollection.add(relatedObject);
            this.injectAnnotations(record.objectId, relatedObject, record.annotations, record.relatedAnnotations);
        }
        for (Long objectId : objectIds) {
            if (objectIdToRelatedMap.containsKey(objectId)) continue;
            objectIdToRelatedMap.put(objectId, this.createCollection());
        }
        return objectIdToRelatedMap;
    }

    protected Map<Long, RELATED_OBJECT> filterRelatedObjects(Map<Long, RELATED_OBJECT> relatedObjects) {
        return relatedObjects;
    }

    @Override
    protected void updateObject(TranslationContext context, Long objectId, ObjectHolder<Collection<RELATED_OBJECT>> result, Object relations, RELATED_FETCH_OPTIONS fetchOptions) {
        Map objectIdToRelatedMap = (Map)relations;
        Collection related = (Collection)objectIdToRelatedMap.get(objectId);
        result.setObject(related);
    }

    protected abstract List<ObjectRelationRecord> loadRecords(LongOpenHashSet var1);

    protected abstract Map<Long, RELATED_OBJECT> translateRelated(TranslationContext var1, Collection<Long> var2, RELATED_FETCH_OPTIONS var3);

    protected abstract Collection<RELATED_OBJECT> createCollection();

    protected void injectAnnotations(Long objectId, RELATED_OBJECT relatedObject, String annotations, String relatedAnnotations) {
    }
}

