/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectHolder;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectRelationRecord;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class ObjectToOneRelationTranslator<RELATED_OBJECT, RELATED_FETCH_OPTIONS extends FetchOptions<?>>
extends AbstractCachingTranslator<Long, ObjectHolder<RELATED_OBJECT>, RELATED_FETCH_OPTIONS> {
    @Override
    protected ObjectHolder<RELATED_OBJECT> createObject(TranslationContext context, Long objectId, RELATED_FETCH_OPTIONS relatedFetchOptions) {
        return new ObjectHolder();
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> objectIds, RELATED_FETCH_OPTIONS relatedFetchOptions) {
        List<ObjectRelationRecord> records = this.loadRecords(new LongOpenHashSet(objectIds));
        HashSet<Long> relatedIds = new HashSet<Long>();
        for (ObjectRelationRecord record : records) {
            if (record.relatedId == null) continue;
            relatedIds.add(record.relatedId);
        }
        Map<Long, RELATED_OBJECT> relatedIdToRelated = this.translateRelated(context, relatedIds, relatedFetchOptions);
        HashMap<Long, RELATED_OBJECT> objectIdToRelatedMap = new HashMap<Long, RELATED_OBJECT>();
        for (ObjectRelationRecord record : records) {
            objectIdToRelatedMap.put(record.objectId, relatedIdToRelated.get(record.relatedId));
        }
        return objectIdToRelatedMap;
    }

    @Override
    protected void updateObject(TranslationContext context, Long objectId, ObjectHolder<RELATED_OBJECT> result, Object relations, RELATED_FETCH_OPTIONS relatedFetchOptions) {
        Map objectIdToRelatedMap = (Map)relations;
        result.setObject(objectIdToRelatedMap.get(objectId));
    }

    protected abstract List<ObjectRelationRecord> loadRecords(LongOpenHashSet var1);

    protected abstract Map<Long, RELATED_OBJECT> translateRelated(TranslationContext var1, Collection<Long> var2, RELATED_FETCH_OPTIONS var3);
}

