/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.TableColumn;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.TableDoubleCell;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.TableLongCell;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.TableModel;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.TableStringCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DateTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DoubleTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IntegerTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class TableModelTranslator {
    public TableModel translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel tableModel) {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        ArrayList translatedRows = new ArrayList();
        if (tableModel != null && tableModel.getHeader() != null && tableModel.getRows() != null) {
            List<TableModelColumnHeader> headers = tableModel.getHeader();
            columns.ensureCapacity(headers.size());
            for (TableModelColumnHeader header : headers) {
                columns.add(new TableColumn(header.getTitle()));
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
            List<TableModelRow> rows = tableModel.getRows();
            translatedRows.ensureCapacity(rows.size());
            for (TableModelRow row : rows) {
                List<ISerializableComparable> values = row.getValues();
                if (values == null) continue;
                ArrayList<TableLongCell> cells = new ArrayList<TableLongCell>(values.size());
                for (ISerializableComparable value : values) {
                    TableLongCell cell = null;
                    if (value instanceof IntegerTableCell) {
                        cell = new TableLongCell(((IntegerTableCell)value).getNumber());
                    } else if (value instanceof DoubleTableCell) {
                        cell = new TableDoubleCell(((DoubleTableCell)value).getNumber());
                    } else if (value instanceof DateTableCell) {
                        cell = new TableStringCell(format.format(((DateTableCell)value).getDateTime()));
                    } else if (value != null) {
                        cell = new TableStringCell(value.toString());
                    }
                    cells.add(cell);
                }
                translatedRows.add(cells);
            }
        }
        return new TableModel(columns, translatedRows);
    }
}

