/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractCompositeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractEntitySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchOperator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.AbstractSearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.IObjectAttributeProviderFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.ISearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchCriteriaTranslationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchCriteriaTranslatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchTranslationContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchSubCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchCriteriaConnection;
import java.util.ArrayList;

public abstract class AbstractCompositeSearchCriteriaTranslator
extends AbstractSearchCriteriaTranslator {
    private IDAOFactory daoFactory;
    private IObjectAttributeProviderFactory entityAttributeProviderFactory;

    protected AbstractCompositeSearchCriteriaTranslator(IDAOFactory daoFactory, IObjectAttributeProviderFactory entityAttributeProviderFactory) {
        this.daoFactory = daoFactory;
        this.entityAttributeProviderFactory = entityAttributeProviderFactory;
    }

    @Override
    protected SearchCriteriaTranslationResult doTranslate(SearchTranslationContext context, ISearchCriteria criteria) {
        AbstractCompositeSearchCriteria compositeCriteria = (AbstractCompositeSearchCriteria)criteria;
        DetailedSearchCriteria detailedSearchCriteria = new DetailedSearchCriteria();
        detailedSearchCriteria.setUseWildcardSearchMode(true);
        if (criteria instanceof AbstractEntitySearchCriteria) {
            detailedSearchCriteria.setConnection(this.translateOperator(((AbstractEntitySearchCriteria)compositeCriteria).getOperator()));
        }
        ArrayList<DetailedSearchCriterion> detailedCriterionList = new ArrayList<DetailedSearchCriterion>();
        ArrayList<DetailedSearchSubCriteria> detailedSubCriteriaList = new ArrayList<DetailedSearchSubCriteria>();
        for (ISearchCriteria subCriterion : compositeCriteria.getCriteria()) {
            ISearchCriteriaTranslator subTranslator = new SearchCriteriaTranslatorFactory(this.getDaoFactory(), this.getEntityAttributeProviderFactory()).getTranslator(subCriterion);
            SearchCriteriaTranslationResult translationResult = subTranslator.translate(context, subCriterion);
            if (translationResult == null) continue;
            for (DetailedSearchCriteria detailedSearchCriteria2 : translationResult.getCriteriaList()) {
                detailedCriterionList.addAll(detailedSearchCriteria2.getCriteria());
            }
            detailedCriterionList.addAll(translationResult.getCriterionList());
            detailedSubCriteriaList.addAll(translationResult.getSubCriteriaList());
        }
        detailedSearchCriteria.setCriteria(detailedCriterionList);
        detailedSearchCriteria.setSubCriterias(detailedSubCriteriaList);
        return new SearchCriteriaTranslationResult(detailedSearchCriteria);
    }

    private SearchCriteriaConnection translateOperator(SearchOperator operator) {
        switch (operator) {
            case AND: {
                return SearchCriteriaConnection.MATCH_ALL;
            }
            case OR: {
                return SearchCriteriaConnection.MATCH_ANY;
            }
        }
        throw new IllegalArgumentException("Unknown search operator: " + operator);
    }

    public IDAOFactory getDaoFactory() {
        return this.daoFactory;
    }

    public IObjectAttributeProviderFactory getEntityAttributeProviderFactory() {
        return this.entityAttributeProviderFactory;
    }
}

