/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractCompositeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.AbstractFieldSearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.IObjectAttributeProviderFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.ISearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchCriteriaTranslationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchCriteriaTranslatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchTranslationContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IAttributeSearchFieldKind;
import java.util.Collection;
import java.util.LinkedList;

public abstract class AbstractFieldFromCompositeSearchCriteriaTranslator
extends AbstractFieldSearchCriteriaTranslator {
    public AbstractFieldFromCompositeSearchCriteriaTranslator(IDAOFactory daoFactory, IObjectAttributeProviderFactory entityAttributeProviderFactory) {
        super(daoFactory, entityAttributeProviderFactory);
    }

    @Override
    protected SearchCriteriaTranslationResult doTranslate(SearchTranslationContext context, ISearchCriteria criteria) {
        AbstractCompositeSearchCriteria compositeCriteria = (AbstractCompositeSearchCriteria)criteria;
        Collection subCriteria = compositeCriteria.getCriteria();
        if (subCriteria != null && !subCriteria.isEmpty()) {
            LinkedList<DetailedSearchCriterion> detailedCriteria = new LinkedList<DetailedSearchCriterion>();
            for (ISearchCriteria subCriterion : subCriteria) {
                DetailedSearchCriterion detailedCriterion = this.doTranslateField(context, (ISearchCriteria)compositeCriteria, subCriterion);
                detailedCriteria.add(detailedCriterion);
            }
            return new SearchCriteriaTranslationResult(detailedCriteria.toArray(new DetailedSearchCriterion[0]));
        }
        return null;
    }

    protected DetailedSearchCriterion doTranslateField(SearchTranslationContext context, ISearchCriteria criteria, ISearchCriteria subCriteria) {
        ISearchCriteriaTranslator subTranslator = new SearchCriteriaTranslatorFactory(this.getDaoFactory(), this.getEntityAttributeProviderFactory()).getTranslator(subCriteria);
        SearchCriteriaTranslationResult translationResult = subTranslator.translate(context, subCriteria);
        Collection<String> values = translationResult.getCriterion().getValues();
        DetailedSearchField searchField = this.doTranslateSearchField(context, criteria, subCriteria);
        DetailedSearchCriterion detailedSearchCriterion = new DetailedSearchCriterion(searchField, values);
        return detailedSearchCriterion;
    }

    protected DetailedSearchField doTranslateSearchField(SearchTranslationContext context, ISearchCriteria criteria, ISearchCriteria subCriteria) {
        IAttributeSearchFieldKind attribute = this.getEntityAttributeProvider(context).getAttribute(criteria);
        DetailedSearchField searchField = DetailedSearchField.createAttributeField(attribute);
        return searchField;
    }
}

