/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchFieldType;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.AbstractSearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.IObjectAttributeProvider;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.IObjectAttributeProviderFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchObjectKind;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchTranslationContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;

public abstract class AbstractFieldSearchCriteriaTranslator
extends AbstractSearchCriteriaTranslator {
    private IDAOFactory daoFactory;
    private IObjectAttributeProviderFactory entityAttributeProviderFactory;

    public AbstractFieldSearchCriteriaTranslator(IDAOFactory daoFactory, IObjectAttributeProviderFactory entityAttributeProviderFactory) {
        this.daoFactory = daoFactory;
        this.entityAttributeProviderFactory = entityAttributeProviderFactory;
    }

    protected DetailedSearchField getDetailedSearchField(SearchTranslationContext context, AbstractFieldSearchCriteria<?> criteria) {
        DetailedSearchField field;
        if (criteria.getFieldType().equals((Object)SearchFieldType.PROPERTY)) {
            field = DetailedSearchField.createPropertyField(criteria.getFieldName());
        } else if (criteria.getFieldType().equals((Object)SearchFieldType.ATTRIBUTE)) {
            IAttributeSearchFieldKind attribute = this.getEntityAttributeProvider(context).getAttribute((ISearchCriteria)criteria);
            field = DetailedSearchField.createAttributeField(attribute);
        } else if (criteria.getFieldType().equals((Object)SearchFieldType.ANY_FIELD)) {
            field = DetailedSearchField.createAnyField(this.getEntityPropertyTypeDAO(context).listPropertyTypeCodes());
        } else if (criteria.getFieldType().equals((Object)SearchFieldType.ANY_PROPERTY)) {
            field = DetailedSearchField.createAnyPropertyField(this.getEntityPropertyTypeDAO(context).listPropertyTypeCodes());
        } else {
            throw new IllegalArgumentException("Unknown search field type: " + criteria.getFieldType());
        }
        return field;
    }

    protected IObjectAttributeProvider getEntityAttributeProvider(SearchTranslationContext context) {
        return this.getEntityAttributeProviderFactory().getProvider(context.peekObjectKind());
    }

    protected IEntityPropertyTypeDAO getEntityPropertyTypeDAO(SearchTranslationContext context) {
        EntityKind entityKind = this.getEntityPropertyKind(context.peekObjectKind());
        return this.getDaoFactory().getEntityPropertyTypeDAO(entityKind);
    }

    protected IDAOFactory getDaoFactory() {
        return this.daoFactory;
    }

    protected IObjectAttributeProviderFactory getEntityAttributeProviderFactory() {
        return this.entityAttributeProviderFactory;
    }

    private EntityKind getEntityPropertyKind(SearchObjectKind objectKind) {
        switch (objectKind) {
            case EXPERIMENT: {
                return EntityKind.EXPERIMENT;
            }
            case SAMPLE: {
                return EntityKind.SAMPLE;
            }
            case DATA_SET: {
                return EntityKind.DATA_SET;
            }
            case MATERIAL: {
                return EntityKind.MATERIAL;
            }
        }
        throw new IllegalArgumentException("Unknown object kind: " + (Object)((Object)objectKind));
    }
}

